CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_distributed_storage` (
  `storage_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) NOT NULL,
  `storage_key` varchar(40) NOT NULL DEFAULT '',
  `storage_chunk` int(11) NOT NULL DEFAULT '0',
  `storage_data` longtext NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_fingerprints` (
  `fingerprint_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint(20) unsigned NOT NULL,
  `fingerprint_hash` char(32) NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext NOT NULL,
  `fingerprint_snapshot` longtext NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int(11) NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) NOT NULL,
  `fingerprint_uuid` char(36) NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_geolocation_cache` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) NOT NULL,
  `location_credit` varchar(255) NOT NULL,
  `location_time` datetime NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  `lockout_context` text,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_host` varchar(40) DEFAULT NULL,
  `log_username` varchar(60) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=9915 DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_itsec_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint(20) unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint(20) unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) NOT NULL DEFAULT '',
  `blog_id` bigint(20) NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3298 DEFAULT CHARSET=utf8;

INSERT INTO `wp_itsec_logs` VALUES ("3289","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-24 20:55:26","2022-10-24 20:55:26","7384072","7418944","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3290","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666619426;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221025-095031-QPoxV39ZInwLIXB40J4bm8pBZwDRRQ.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221025-095031-QPoxV39ZInwLIXB40J4bm8pBZwDRRQ.zip\";s:4:\"size\";i:1683131;}","notice","2022-10-25 13:50:32","2022-10-25 13:50:31","8107616","34632016","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3283","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-21 20:50:27","2022-10-21 20:50:27","7383544","7418416","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3284","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666360226;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221022-095027-P8R3PtuVBeSipb5R0ZtGi5vn5XRAnB.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221022-095027-P8R3PtuVBeSipb5R0ZtGi5vn5XRAnB.zip\";s:4:\"size\";i:1696337;}","notice","2022-10-22 13:50:27","2022-10-22 13:50:26","8107088","34914112","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3279","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-19 20:49:54","2022-10-19 20:49:54","36459696","36495704","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3280","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666187394;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221020-095026-OLY0zV9SR7mGCdjDAmAxqZ5YFYtpOL.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221020-095026-OLY0zV9SR7mGCdjDAmAxqZ5YFYtpOL.zip\";s:4:\"size\";i:1699683;}","notice","2022-10-20 13:50:27","2022-10-20 13:50:26","37043472","64014336","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3295","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-27 20:59:08","2022-10-27 20:59:07","36447208","36483216","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3296","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666878548;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221028-094907-v4HR2EWgFukOUPisxI07n26kbqxZwz.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221028-094907-v4HR2EWgFukOUPisxI07n26kbqxZwz.zip\";s:4:\"size\";i:1697484;}","notice","2022-10-28 13:49:08","2022-10-28 13:49:07","37113184","63961168","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3272","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1665841613;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221016-094653-EFn6MzMof5ZRtLMbeMbpNABE0GluDp.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221016-094653-EFn6MzMof5ZRtLMbeMbpNABE0GluDp.zip\";s:4:\"size\";i:1692001;}","notice","2022-10-16 13:46:54","2022-10-16 13:46:53","37024272","63814912","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3287","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-23 20:50:51","2022-10-23 20:50:51","7380936","7415808","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3288","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666533027;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221024-095026-mOv6grdhiCJoJzBVRslW0rbLUwFiag.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221024-095026-mOv6grdhiCJoJzBVRslW0rbLUwFiag.zip\";s:4:\"size\";i:1699585;}","notice","2022-10-24 13:50:27","2022-10-24 13:50:26","8101208","34875464","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3292","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666705831;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221026-095026-DlZD9P04dw8eXLOHvjdkrGXUO8R1RY.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221026-095026-DlZD9P04dw8eXLOHvjdkrGXUO8R1RY.zip\";s:4:\"size\";i:1692465;}","notice","2022-10-26 13:50:27","2022-10-26 13:50:26","8109944","34749032","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3297","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-28 20:59:08","2022-10-28 20:59:08","36447960","36483968","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3269","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-14 20:41:54","2022-10-14 20:41:54","36438096","36474104","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3270","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1665755214;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221015-094654-I03fYJjbz1suQi2cLA08PpCSGZWEIA.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221015-094654-I03fYJjbz1suQi2cLA08PpCSGZWEIA.zip\";s:4:\"size\";i:1706391;}","notice","2022-10-15 13:46:54","2022-10-15 13:46:53","37034920","64063128","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3285","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-22 20:50:28","2022-10-22 20:50:28","7384288","7419160","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3286","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666446626;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221023-095027-BRWRdOMtAychR31g0oatizMuDobKgN.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221023-095027-BRWRdOMtAychR31g0oatizMuDobKgN.zip\";s:4:\"size\";i:1682789;}","notice","2022-10-23 13:50:28","2022-10-23 13:50:27","8109400","34650184","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3291","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-25 20:55:27","2022-10-25 20:55:27","7384824","7419696","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3293","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-26 20:55:50","2022-10-26 20:55:50","8146488","8181360","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3294","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666792226;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221027-094908-gNezYux9TDEvL2af5ERsSW6p0U2zx5.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221027-094908-gNezYux9TDEvL2af5ERsSW6p0U2zx5.zip\";s:4:\"size\";i:1701451;}","notice","2022-10-27 13:49:09","2022-10-27 13:49:08","37107200","64020720","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3271","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-15 20:46:01","2022-10-15 20:46:01","36426040","36462048","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3274","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1665928013;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221017-095101-s7x0nLO76pGByreeqOF3uzWOHWj08q.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221017-095101-s7x0nLO76pGByreeqOF3uzWOHWj08q.zip\";s:4:\"size\";i:1689589;}","notice","2022-10-17 13:51:02","2022-10-17 13:51:01","37027784","63826616","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3281","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-20 20:50:31","2022-10-20 20:50:25","37208112","37244040","https://dmcstudios.library.northeastern.edu/","1","0","155.33.16.249");
INSERT INTO `wp_itsec_logs` VALUES ("3282","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666273826;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221021-095026-4nfFJzw3TcQXE3sJ8pRgj2V0Q4dGhg.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221021-095026-4nfFJzw3TcQXE3sJ8pRgj2V0Q4dGhg.zip\";s:4:\"size\";i:1703773;}","notice","2022-10-21 13:50:27","2022-10-21 13:50:26","37036776","64069080","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3275","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-17 20:46:12","2022-10-17 20:46:12","36422904","36458912","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3276","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666014661;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221018-095036-TUiTsXcEpTZFBY7puFkcmLqzFYnBEs.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221018-095036-TUiTsXcEpTZFBY7puFkcmLqzFYnBEs.zip\";s:4:\"size\";i:1697852;}","notice","2022-10-18 13:50:37","2022-10-18 13:50:36","37046432","63964048","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3273","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-16 20:46:02","2022-10-16 20:46:02","36426792","36462800","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3277","0","notification_center","send_scheduled","a:2:{s:13:\"notifications\";a:1:{i:0;s:6:\"digest\";}s:6:\"silent\";b:0;}","debug","2022-10-18 20:49:54","2022-10-18 20:49:53","36453160","36489168","wp-cron","1","0","155.33.31.140");
INSERT INTO `wp_itsec_logs` VALUES ("3278","0","backup","file-stored","a:5:{s:8:\"settings\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666101036;}s:12:\"mail_success\";N;s:4:\"file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221019-094954-YSYtK4juerSmTfxChEd9aRJzTeAROi.sql\";s:11:\"output_file\";s:152:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups/backup-recording-studios-sh-20221019-094954-YSYtK4juerSmTfxChEd9aRJzTeAROi.zip\";s:4:\"size\";i:1702316;}","notice","2022-10-19 13:49:55","2022-10-19 13:49:54","37053352","64032408","wp-cron","1","0","155.33.31.140");


CREATE TABLE IF NOT EXISTS `wp_itsec_opaque_tokens` (
  `token_id` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_hashed` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



CREATE TABLE IF NOT EXISTS `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=18418 DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=1446802 DEFAULT CHARSET=utf8;

INSERT INTO `wp_options` VALUES ("1","siteurl","http://recordingstudios.library.northeastern.edu","yes");
INSERT INTO `wp_options` VALUES ("2","home","http://recordingstudios.library.northeastern.edu","yes");
INSERT INTO `wp_options` VALUES ("3","blogname","Recording Studios Showcase","yes");
INSERT INTO `wp_options` VALUES ("4","blogdescription","Created in Snell Library Studios","yes");
INSERT INTO `wp_options` VALUES ("5","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES ("6","admin_email","k.yee@neu.edu","yes");
INSERT INTO `wp_options` VALUES ("7","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES ("8","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES ("9","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES ("10","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES ("11","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES ("12","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES ("13","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES ("14","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES ("15","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES ("16","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES ("17","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES ("18","default_category","1","yes");
INSERT INTO `wp_options` VALUES ("19","default_comment_status","closed","yes");
INSERT INTO `wp_options` VALUES ("20","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES ("21","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES ("22","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES ("23","date_format","F j, Y","yes");
INSERT INTO `wp_options` VALUES ("24","time_format","g:i a","yes");
INSERT INTO `wp_options` VALUES ("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `wp_options` VALUES ("26","comment_moderation","","yes");
INSERT INTO `wp_options` VALUES ("27","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES ("28","permalink_structure","/%postname%","yes");
INSERT INTO `wp_options` VALUES ("29","hack_file","0","yes");
INSERT INTO `wp_options` VALUES ("30","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES ("31","moderation_keys","","no");
INSERT INTO `wp_options` VALUES ("32","active_plugins","a:11:{i:0;s:19:\"akismet/akismet.php\";i:1;s:41:\"better-wp-security/better-wp-security.php\";i:2;s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";i:3;s:17:\"drs-tk/drs-tk.php\";i:4;s:36:\"google-sitemap-generator/sitemap.php\";i:5;s:25:\"relevanssi/relevanssi.php\";i:6;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:7;s:41:\"transients-manager/transients-manager.php\";i:8;s:33:\"widget-context/widget-context.php\";i:9;s:23:\"wordfence/wordfence.php\";i:10;s:27:\"wp-rollback/wp-rollback.php\";}","yes");
INSERT INTO `wp_options` VALUES ("33","category_base","","yes");
INSERT INTO `wp_options` VALUES ("34","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES ("35","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES ("36","gmt_offset","","yes");
INSERT INTO `wp_options` VALUES ("37","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES ("38","recently_edited","a:4:{i:0;s:102:\"/mnt/wordpressdata/dmcstudios/wp-content/plugins/velvet-blues-update-urls/velvet-blues-update-urls.php\";i:1;s:69:\"/mnt/wordpressdata/dmcstudios/wp-content/themes/quest-child/style.css\";i:2;s:70:\"/mnt/wordpressdata/dmcstudios/wp-content/themes/quest-child/footer.php\";i:3;s:0:\"\";}","no");
INSERT INTO `wp_options` VALUES ("39","template","quest","yes");
INSERT INTO `wp_options` VALUES ("40","stylesheet","quest-child","yes");
INSERT INTO `wp_options` VALUES ("41","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES ("42","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES ("43","comment_registration","","yes");
INSERT INTO `wp_options` VALUES ("44","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES ("45","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES ("46","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES ("47","db_version","38590","yes");
INSERT INTO `wp_options` VALUES ("48","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES ("49","upload_path","","yes");
INSERT INTO `wp_options` VALUES ("50","blog_public","1","yes");
INSERT INTO `wp_options` VALUES ("51","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES ("52","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES ("53","tag_base","","yes");
INSERT INTO `wp_options` VALUES ("54","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES ("55","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES ("56","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES ("57","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES ("58","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES ("59","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES ("60","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES ("61","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES ("62","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES ("63","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES ("64","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES ("65","image_default_link_type","none","yes");
INSERT INTO `wp_options` VALUES ("66","image_default_size","","yes");
INSERT INTO `wp_options` VALUES ("67","image_default_align","","yes");
INSERT INTO `wp_options` VALUES ("68","close_comments_for_old_posts","","yes");
INSERT INTO `wp_options` VALUES ("69","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES ("70","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES ("71","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES ("72","page_comments","","yes");
INSERT INTO `wp_options` VALUES ("73","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES ("74","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES ("75","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES ("76","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("77","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("80","uninstall_plugins","a:3:{s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:16:\"handle_uninstall\";}s:25:\"relevanssi/relevanssi.php\";s:20:\"relevanssi_uninstall\";s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";}","no");
INSERT INTO `wp_options` VALUES ("81","timezone_string","America/New_York","yes");
INSERT INTO `wp_options` VALUES ("82","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES ("83","page_on_front","764","yes");
INSERT INTO `wp_options` VALUES ("84","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES ("85","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES ("86","finished_splitting_shared_terms","1","yes");
INSERT INTO `wp_options` VALUES ("87","site_icon","0","yes");
INSERT INTO `wp_options` VALUES ("88","medium_large_size_w","768","yes");
INSERT INTO `wp_options` VALUES ("89","medium_large_size_h","0","yes");
INSERT INTO `wp_options` VALUES ("90","initial_db_version","35700","yes");
INSERT INTO `wp_options` VALUES ("91","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:64:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES ("92","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("93","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("94","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("95","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("96","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("97","sidebars_widgets","a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"footer-widget\";N;s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES ("144528","itsec_temp_whitelist_ip","a:1:{s:14:\"129.10.106.215\";i:1663174162;}","no");
INSERT INTO `wp_options` VALUES ("137","WPLANG","","yes");
INSERT INTO `wp_options` VALUES ("140","recently_activated","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("99","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("100","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("101","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("102","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("103","cron","a:27:{i:1527882040;a:1:{s:10:\"itsec_cron\";a:0:{}}i:1527882520;a:1:{s:10:\"itsec_cron\";a:0:{}}i:1541803265;a:1:{s:10:\"itsec_cron\";a:0:{}}i:1667051253;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"3ec3d6914daf50bcdb5e5b065213e29b\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:17:\"purge-log-entries\";}s:8:\"interval\";i:86400;}}}i:1667051351;a:1:{s:15:\"wf_scan_monitor\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:24:\"wf_scan_monitor_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1667052001;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1667052333;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"aa768a35ceed34e467f270ebdc5d82f4\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:14:\"purge-lockouts\";}s:8:\"interval\";i:86400;}}}i:1667052753;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"7a0fd5d064c59cf40c3df9ad0bb6e63d\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:11:\"clear-locks\";}s:8:\"interval\";i:86400;}}}i:1667053971;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1667054783;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1667056055;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667065568;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667065583;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667068364;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667070728;a:1:{s:15:\"itsec_cron_test\";a:1:{s:32:\"a18a5f882299140c10b4bef59a834b5a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1667070728;}}}}i:1667071800;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"20d2f240a5c4b04ffd214e8f89688592\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1667071800;}}}}i:1667071990;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667075127;a:1:{s:13:\"sm_ping_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667079839;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1667079849;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667079999;a:1:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667080127;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"d3ad27d223d301b6ae68ed2a88d04d71\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:1:{i:0;s:12:\"health-check\";}s:8:\"interval\";i:86400;}}}i:1667137593;a:1:{s:10:\"itsec_cron\";a:1:{s:32:\"e0d50030fc9bde5ba86be99826a116eb\";a:3:{s:8:\"schedule\";s:12:\"itsec-backup\";s:4:\"args\";a:1:{i:0;s:6:\"backup\";}s:8:\"interval\";i:86400;}}}i:1667246400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1667331000;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"d90032ac0092d198c6c11dea4403f1c9\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1667331000;}}}}i:1667590200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"636c984ecc2c662df721f73750f40938\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1667590200;}}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES ("2087","jetpack_unique_connection","a:1:{s:12:\"disconnected\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2053","widget_origin_animated-image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2054","widget_origin_button","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2055","widget_origin_call-to-action","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("9260","drstk_default_search_per_page","10","yes");
INSERT INTO `wp_options` VALUES ("9261","drstk_search_show_facets","on","yes");
INSERT INTO `wp_options` VALUES ("9262","drstk_default_browse_per_page","10","yes");
INSERT INTO `wp_options` VALUES ("9263","drstk_browse_show_facets","on","yes");
INSERT INTO `wp_options` VALUES ("9264","drstk_mirador","","yes");
INSERT INTO `wp_options` VALUES ("9265","drstk_mirador_page_title","Book View","yes");
INSERT INTO `wp_options` VALUES ("9266","drstk_mirador_url","mirador","yes");
INSERT INTO `wp_options` VALUES ("9267","drstk_appears","","yes");
INSERT INTO `wp_options` VALUES ("9268","drstk_appears_title","Item Appears In","yes");
INSERT INTO `wp_options` VALUES ("596","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("1596","itsec_active_modules","a:10:{s:9:\"ban-users\";b:1;s:11:\"brute-force\";b:1;s:6:\"backup\";b:1;s:19:\"network-brute-force\";b:1;s:16:\"wordpress-tweaks\";b:1;s:13:\"404-detection\";b:0;s:9:\"away-mode\";b:0;s:11:\"file-change\";b:0;s:3:\"ssl\";b:1;s:13:\"system-tweaks\";b:1;}","yes");
INSERT INTO `wp_options` VALUES ("2057","widget_origin_price-box","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2058","widget_origin_testimonial","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2059","widget_siteorigin-panels-gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2060","widget_siteorigin-panels-image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2061","widget_siteorigin-panels-embedded-video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2062","widget_siteorigin-panels-video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2622","supercache_stats","a:3:{s:9:\"generated\";i:1523980536;s:10:\"supercache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}s:7:\"wpcache\";a:5:{s:7:\"expired\";i:0;s:6:\"cached\";i:0;s:5:\"fsize\";i:0;s:11:\"cached_list\";a:0:{}s:12:\"expired_list\";a:0:{}}}","yes");
INSERT INTO `wp_options` VALUES ("2632","drstk_home_url","","yes");
INSERT INTO `wp_options` VALUES ("2633","leaflet_api_key","","yes");
INSERT INTO `wp_options` VALUES ("2634","leaflet_project_key","","yes");
INSERT INTO `wp_options` VALUES ("2635","drstk_search_related_content_title","Related Content","yes");
INSERT INTO `wp_options` VALUES ("2636","drstk_default_sort","title_ssi%20asc","yes");
INSERT INTO `wp_options` VALUES ("2284","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:13:\"k.yee@neu.edu\";s:7:\"version\";s:6:\"4.9.22\";s:9:\"timestamp\";i:1666050640;}","no");
INSERT INTO `wp_options` VALUES ("87906","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("482","drstk_search_metadata","a:4:{i:0;s:5:\"Title\";i:1;s:7:\"Creator\";i:2;s:20:\"Abstract/Description\";i:3;s:12:\"Date Created\";}","yes");
INSERT INTO `wp_options` VALUES ("483","drstk_browse_metadata","a:4:{i:0;s:5:\"Title\";i:1;s:7:\"Creator\";i:2;s:20:\"Abstract/Description\";i:3;s:12:\"Date Created\";}","yes");
INSERT INTO `wp_options` VALUES ("484","drstk_facets","a:4:{i:0;s:11:\"creator_sim\";i:1;s:17:\"creation_year_sim\";i:2;s:11:\"subject_sim\";i:3;s:8:\"type_sim\";}","yes");
INSERT INTO `wp_options` VALUES ("485","drstk_creator_sim_title","","yes");
INSERT INTO `wp_options` VALUES ("486","drstk_creation_year_sim_title","","yes");
INSERT INTO `wp_options` VALUES ("487","drstk_subject_sim_title","","yes");
INSERT INTO `wp_options` VALUES ("488","drstk_type_sim_title","","yes");
INSERT INTO `wp_options` VALUES ("489","drstk_community_name_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("490","drstk_drs_department_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("491","drstk_drs_degree_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("492","drstk_drs_course_number_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("493","drstk_drs_course_title_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("494","drstk_assoc","","yes");
INSERT INTO `wp_options` VALUES ("495","drstk_assoc_title","Associated Files","yes");
INSERT INTO `wp_options` VALUES ("496","drstk_assoc_file_metadata","a:3:{i:0;s:14:\"full_title_ssi\";i:1;s:13:\"creator_tesim\";i:2;s:14:\"abstract_tesim\";}","yes");
INSERT INTO `wp_options` VALUES ("9269","drstk_annotations","","yes");
INSERT INTO `wp_options` VALUES ("9270","drstk_item_extensions","","yes");
INSERT INTO `wp_options` VALUES ("2300","sm_status","O:28:\"GoogleSitemapGeneratorStatus\":4:{s:39:\"\0GoogleSitemapGeneratorStatus\0startTime\";d:1622037721.92998;s:37:\"\0GoogleSitemapGeneratorStatus\0endTime\";d:1622037722.19517;s:41:\"\0GoogleSitemapGeneratorStatus\0pingResults\";a:2:{s:6:\"google\";a:5:{s:9:\"startTime\";d:1622037721.930494;s:7:\"endTime\";d:1622037722.097917;s:7:\"success\";b:1;s:3:\"url\";s:124:\"http://www.google.com/webmasters/sitemaps/ping?sitemap=https%3A%2F%2Frecordingstudios.library.northeastern.edu%2Fsitemap.xml\";s:4:\"name\";s:6:\"Google\";}s:4:\"bing\";a:5:{s:9:\"startTime\";d:1622037722.098479;s:7:\"endTime\";d:1622037722.194196;s:7:\"success\";b:1;s:3:\"url\";s:117:\"http://www.bing.com/webmaster/ping.aspx?siteMap=https%3A%2F%2Frecordingstudios.library.northeastern.edu%2Fsitemap.xml\";s:4:\"name\";s:4:\"Bing\";}}s:38:\"\0GoogleSitemapGeneratorStatus\0autoSave\";b:1;}","no");
INSERT INTO `wp_options` VALUES ("2637","drstk_facet_sort_order","fc_desc","yes");
INSERT INTO `wp_options` VALUES ("2638","drstk_niec","","yes");
INSERT INTO `wp_options` VALUES ("2639","drstk_niec_metadata","","yes");
INSERT INTO `wp_options` VALUES ("2640","drstk_niec_niec_gender_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2641","drstk_niec_niec_age_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2642","drstk_niec_niec_race_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2643","drstk_niec_niec_sign_pace_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2644","drstk_niec_niec_fingerspelling_extent_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2645","drstk_niec_niec_fingerspelling_pace_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2646","drstk_niec_niec_numbers_pace_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2647","drstk_niec_niec_numbers_extent_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2648","drstk_niec_niec_classifiers_extent_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2649","drstk_niec_niec_use_of_space_extent_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2650","drstk_niec_niec_how_space_used_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2651","drstk_niec_niec_text_type_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2652","drstk_niec_niec_register_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2653","drstk_niec_niec_conversation_type_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2654","drstk_niec_niec_audience_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2655","drstk_niec_niec_signed_language_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2656","drstk_niec_niec_spoken_language_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2657","drstk_niec_niec_lends_itself_to_classifiers_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2658","drstk_niec_niec_lends_itself_to_use_of_space_ssim_title","","yes");
INSERT INTO `wp_options` VALUES ("2659","drstk_item_page_custom_metadata","","yes");
INSERT INTO `wp_options` VALUES ("235","relevanssi_class","relevanssi-query-term","yes");
INSERT INTO `wp_options` VALUES ("236","relevanssi_excerpts","on","yes");
INSERT INTO `wp_options` VALUES ("237","relevanssi_excerpt_length","30","yes");
INSERT INTO `wp_options` VALUES ("238","relevanssi_excerpt_type","words","yes");
INSERT INTO `wp_options` VALUES ("239","relevanssi_excerpt_allowable_tags","","yes");
INSERT INTO `wp_options` VALUES ("240","relevanssi_log_queries","off","yes");
INSERT INTO `wp_options` VALUES ("241","relevanssi_log_queries_with_ip","off","yes");
INSERT INTO `wp_options` VALUES ("242","relevanssi_cat","0","yes");
INSERT INTO `wp_options` VALUES ("243","relevanssi_excat","0","yes");
INSERT INTO `wp_options` VALUES ("244","relevanssi_extag","0","yes");
INSERT INTO `wp_options` VALUES ("245","relevanssi_index_fields","","yes");
INSERT INTO `wp_options` VALUES ("246","relevanssi_exclude_posts","","yes");
INSERT INTO `wp_options` VALUES ("247","relevanssi_hilite_title","off","yes");
INSERT INTO `wp_options` VALUES ("248","relevanssi_highlight_docs","off","yes");
INSERT INTO `wp_options` VALUES ("249","relevanssi_highlight_comments","off","yes");
INSERT INTO `wp_options` VALUES ("250","relevanssi_index_comments","none","yes");
INSERT INTO `wp_options` VALUES ("251","relevanssi_show_matches","off","yes");
INSERT INTO `wp_options` VALUES ("252","relevanssi_show_matches_text","(Search hits: %body% in body, %title% in title, %category% in categories, %tags% in tags, %taxonomy% in other taxonomies, %comments% in comments. Score: %score%)","yes");
INSERT INTO `wp_options` VALUES ("152","itsec_four_oh_four","a:5:{s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}s:7:\"enabled\";b:0;}","yes");
INSERT INTO `wp_options` VALUES ("153","itsec_away_mode","a:4:{s:4:\"type\";i:1;s:7:\"enabled\";b:0;s:5:\"start\";i:1453420800;s:3:\"end\";i:1453528800;}","yes");
INSERT INTO `wp_options` VALUES ("156","itsec_brute_force","a:5:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES ("158","itsec_file_change","a:9:{s:6:\"method\";b:1;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:7:\"enabled\";b:0;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";d:1453305184;}","yes");
INSERT INTO `wp_options` VALUES ("46216","siteorigin_panels_active_version","2.18.2","yes");
INSERT INTO `wp_options` VALUES ("161","itsec_ssl","a:2:{s:8:\"frontend\";i:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES ("163","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:11:\"contributor\";}","yes");
INSERT INTO `wp_options` VALUES ("126781","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("2056","widget_origin_list","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("228","relevanssi_title_boost","5","yes");
INSERT INTO `wp_options` VALUES ("229","relevanssi_comment_boost","0.75","yes");
INSERT INTO `wp_options` VALUES ("230","relevanssi_admin_search","off","yes");
INSERT INTO `wp_options` VALUES ("231","relevanssi_highlight","strong","yes");
INSERT INTO `wp_options` VALUES ("232","relevanssi_txt_col","#ff0000","yes");
INSERT INTO `wp_options` VALUES ("233","relevanssi_bg_col","#ffaf75","yes");
INSERT INTO `wp_options` VALUES ("234","relevanssi_css","text-decoration: underline; text-color: #ff0000","yes");
INSERT INTO `wp_options` VALUES ("218","jetpack_options","a:2:{s:7:\"version\";s:16:\"3.8.2:1453223868\";s:11:\"old_version\";s:16:\"3.8.2:1453223868\";}","yes");
INSERT INTO `wp_options` VALUES ("219","jetpack_activated","1","yes");
INSERT INTO `wp_options` VALUES ("220","jetpack_file_data","a:50:{s:5:\"4.1.1\";a:49:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:25:\"Reports on site downtime.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:44:\"Recommended, Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:28:\"Prevent brute force attacks.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:30:\"Automatically promote content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:24:\"Display similar content.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:32:\"Visitors can share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:245:\"shortcodes, shortcode, embeds, media, bandcamp, blip.tv, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:24:\"favicon, icon, site icon\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:75:\"Creates sitemaps to allow your site to be easily indexed by search engines.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:27:\"Secure user authentication.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:31:\"Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:35:\"Collect traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:27:\"Daily or real-time backups.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:20:\"Performance-Security\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:77:\"Verify your site or domain with Google Search Console, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}s:22:\"after-the-deadline.php\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:12:\"carousel.php\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:12:\"comments.php\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:16:\"contact-form.php\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:24:\"custom-content-types.php\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:14:\"custom-css.php\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:9:\"debug.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:25:\"enhanced-distribution.php\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:20:\"gplus-authorship.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:23:\"gravatar-hovercards.php\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:16:\"holiday-snow.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:19:\"infinite-scroll.php\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:12:\"json-api.php\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:9:\"latex.php\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:9:\"likes.php\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:10:\"manage.php\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:12:\"markdown.php\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:13:\"minileven.php\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:15:\"mobile-push.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:17:\"module-extras.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:19:\"module-headings.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:15:\"module-info.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:11:\"monitor.php\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:25:\"Reports on site downtime.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:9:\"notes.php\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:14:\"omnisearch.php\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:6:\"search\";}s:10:\"photon.php\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:44:\"Recommended, Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:17:\"post-by-email.php\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:11:\"protect.php\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:28:\"Prevent brute force attacks.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:13:\"publicize.php\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:30:\"Automatically promote content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:19:\"random-redirect.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:17:\"related-posts.php\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:24:\"Display similar content.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:14:\"sharedaddy.php\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:32:\"Visitors can share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:14:\"shortcodes.php\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:245:\"shortcodes, shortcode, embeds, media, bandcamp, blip.tv, dailymotion, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:14:\"shortlinks.php\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:13:\"site-icon.php\";a:14:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:24:\"favicon, icon, site icon\";}s:12:\"sitemaps.php\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:75:\"Creates sitemaps to allow your site to be easily indexed by search engines.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:16:\"social-links.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:7:\"sso.php\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:27:\"Secure user authentication.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:31:\"Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:9:\"stats.php\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:35:\"Collect traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:17:\"subscriptions.php\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:15:\"theme-tools.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:17:\"tiled-gallery.php\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:12:\"tonesque.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:14:\"vaultpress.php\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:27:\"Daily or real-time backups.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:20:\"Performance-Security\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:22:\"verification-tools.php\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:77:\"Verify your site or domain with Google Search Console, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:14:\"videopress.php\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:21:\"widget-visibility.php\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:11:\"widgets.php\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:8:\"wpcc.php\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}","yes");
INSERT INTO `wp_options` VALUES ("221","jetpack_available_modules","a:1:{s:5:\"4.2.2\";a:37:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}","yes");
INSERT INTO `wp_options` VALUES ("223","jetpack_security_report","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("279","siteorigin_panels_settings","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("280","widget_siteorigin-panels-post-content","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("281","widget_siteorigin-panels-postloop","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("282","widget_siteorigin-panels-builder","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("253","relevanssi_fuzzy","sometimes","yes");
INSERT INTO `wp_options` VALUES ("254","relevanssi_indexed","done","yes");
INSERT INTO `wp_options` VALUES ("255","relevanssi_expand_shortcodes","on","yes");
INSERT INTO `wp_options` VALUES ("278","siteorigin_panels_initial_version","2.2.2","no");
INSERT INTO `wp_options` VALUES ("257","relevanssi_index_author","off","yes");
INSERT INTO `wp_options` VALUES ("258","relevanssi_implicit_operator","OR","yes");
INSERT INTO `wp_options` VALUES ("259","relevanssi_omit_from_logs","","yes");
INSERT INTO `wp_options` VALUES ("260","relevanssi_synonyms","a:1:{s:5:\"en_US\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES ("261","relevanssi_index_excerpt","off","yes");
INSERT INTO `wp_options` VALUES ("262","relevanssi_index_limit","500","yes");
INSERT INTO `wp_options` VALUES ("263","relevanssi_disable_or_fallback","off","yes");
INSERT INTO `wp_options` VALUES ("264","relevanssi_respect_exclude","on","yes");
INSERT INTO `wp_options` VALUES ("265","relevanssi_min_word_length","3","yes");
INSERT INTO `wp_options` VALUES ("266","relevanssi_wpml_only_current","off","yes");
INSERT INTO `wp_options` VALUES ("267","relevanssi_word_boundaries","on","yes");
INSERT INTO `wp_options` VALUES ("268","relevanssi_default_orderby","relevance","yes");
INSERT INTO `wp_options` VALUES ("269","relevanssi_db_version","6","yes");
INSERT INTO `wp_options` VALUES ("270","relevanssi_post_type_weights","a:2:{s:8:\"post_tag\";s:4:\"0.75\";s:8:\"category\";s:4:\"0.75\";}","yes");
INSERT INTO `wp_options` VALUES ("271","relevanssi_throttle","on","yes");
INSERT INTO `wp_options` VALUES ("272","relevanssi_throttle_limit","500","yes");
INSERT INTO `wp_options` VALUES ("273","relevanssi_index_post_types","a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}","yes");
INSERT INTO `wp_options` VALUES ("274","relevanssi_index_taxonomies_list","a:0:{}","yes");
INSERT INTO `wp_options` VALUES ("275","relevanssi_doc_count","7","yes");
INSERT INTO `wp_options` VALUES ("2102","jpsq_sync-1472757866.916217-10403-2","a:5:{i:0;s:14:\"updated_option\";i:1;a:3:{i:0;s:14:\"active_plugins\";i:1;a:8:{i:0;s:41:\"better-wp-security/better-wp-security.php\";i:1;s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";i:2;s:17:\"drs-tk/drs-tk.php\";i:3;s:19:\"jetpack/jetpack.php\";i:4;s:25:\"relevanssi/relevanssi.php\";i:5;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:6;s:41:\"transients-manager/transients-manager.php\";i:7;s:33:\"widget-context/widget-context.php\";}i:2;a:7:{i:0;s:41:\"better-wp-security/better-wp-security.php\";i:1;s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";i:2;s:17:\"drs-tk/drs-tk.php\";i:4;s:25:\"relevanssi/relevanssi.php\";i:5;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:6;s:41:\"transients-manager/transients-manager.php\";i:7;s:33:\"widget-context/widget-context.php\";}}i:2;i:2;i:3;d:1472757866.9162120819091796875;i:4;b:0;}","no");
INSERT INTO `wp_options` VALUES ("285","widget_black-studio-tinymce","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("292","theme_mods_twentysixteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1453224604;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES ("293","current_theme","DRS Toolkit (Quest Child Theme)","yes");
INSERT INTO `wp_options` VALUES ("294","theme_mods_quest","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1453224613;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"footer-widget\";N;}}}","yes");
INSERT INTO `wp_options` VALUES ("295","theme_switched","","yes");
INSERT INTO `wp_options` VALUES ("297","theme_mods_quest-child","a:34:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:21:\"layout_search_sidebar\";s:4:\"none\";s:19:\"layout_post_sidebar\";s:4:\"none\";s:19:\"layout_page_sidebar\";s:4:\"none\";s:20:\"colors_global_accent\";s:7:\"#cc0000\";s:26:\"colors_global_accent_shade\";s:7:\"#cc0000\";s:17:\"colors_header2_bg\";s:7:\"#494949\";s:19:\"colors_header2_text\";s:7:\"#afafaf\";s:25:\"colors_header2_border_top\";s:7:\"#3c3c3c\";s:20:\"colors_header2_sc_si\";s:7:\"#afafaf\";s:29:\"colors_header2_sc_si_hover_bg\";s:7:\"#efefef\";s:17:\"colors_menu_hover\";s:7:\"#cc0000\";s:21:\"colors_menu_sub_hover\";s:7:\"#cc0000\";s:19:\"colors_footer_sc_bg\";s:7:\"#3c3c3c\";s:20:\"colors_header_nulogo\";s:9:\"lib-light\";s:21:\"layout_header_callout\";s:0:\"\";s:20:\"layout_header_height\";i:66;s:25:\"layout_header_menu_height\";i:66;s:38:\"typography_site_tagline_text_transform\";s:9:\"uppercase\";s:27:\"typography_global_font_size\";i:19;s:18:\"custom_css_post_id\";i:-1;s:25:\"typography_menu_font_size\";i:14;s:29:\"typography_global_font_family\";s:16:\"Roboto Condensed\";s:30:\"typography_global_font_variant\";s:3:\"300\";s:33:\"typography_heading_h1_font_family\";s:16:\"Roboto Condensed\";s:33:\"typography_heading_h2_font_family\";s:16:\"Roboto Condensed\";s:33:\"typography_heading_h3_font_family\";s:16:\"Roboto Condensed\";s:34:\"typography_heading_h3_font_variant\";s:3:\"300\";s:34:\"typography_heading_h1_font_variant\";s:7:\"regular\";s:20:\"layout_header_search\";i:0;s:23:\"layout_header_secondary\";i:0;s:36:\"typography_heading_h1_letter_spacing\";d:1;s:29:\"typography_global_line_height\";d:1;}","yes");
INSERT INTO `wp_options` VALUES ("300","theme_mods_twentyfifteen","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1453224623;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES ("313","rewrite_rules","a:99:{s:34:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml$\";s:40:\"index.php?xml_sitemap=params=$matches[2]\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.xml\\.gz$\";s:49:\"index.php?xml_sitemap=params=$matches[2];zip=true\";s:35:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html$\";s:50:\"index.php?xml_sitemap=params=$matches[2];html=true\";s:38:\"sitemap(-+([a-zA-Z0-9_-]+))?\\.html.gz$\";s:59:\"index.php?xml_sitemap=params=$matches[2];html=true;zip=true\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:10:\"^browse/?$\";s:50:\"index.php?post_type=drs&drstk_template_type=browse\";s:10:\"^search/?$\";s:50:\"index.php?post_type=drs&drstk_template_type=search\";s:23:\"^item/([^/]*)/?([^/]*)*\";s:79:\"index.php?post_type=drs&drstk_template_type=item&pid=$matches[1]&js=$matches[2]\";s:19:\"^download/([^/]*)/?\";s:68:\"index.php?post_type=drs&drstk_template_type=download&pid=$matches[1]\";s:15:\"^collections/?$\";s:55:\"index.php?post_type=drs&drstk_template_type=collections\";s:21:\"^collection/([^/]*)/?\";s:70:\"index.php?post_type=drs&drstk_template_type=collection&pid=$matches[1]\";s:11:\"^mirador/?$\";s:51:\"index.php?post_type=drs&drstk_template_type=mirador\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=764&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO `wp_options` VALUES ("1444109","sm_rewrite_done","$Id: class-googlesitemapgeneratorloader.php 937300 2014-06-23 18:04:11Z arnee $","yes");
INSERT INTO `wp_options` VALUES ("2104","ossdl_off_cdn_url","http://recordingstudios.library.northeastern.edu","yes");
INSERT INTO `wp_options` VALUES ("2105","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO `wp_options` VALUES ("2106","ossdl_off_exclude",".php","yes");
INSERT INTO `wp_options` VALUES ("2107","ossdl_cname","","yes");
INSERT INTO `wp_options` VALUES ("138333","widget_akismet_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("314","relevanssi_index","","yes");
INSERT INTO `wp_options` VALUES ("320","drstk_collection","https://repository.library.northeastern.edu/sets/neu:cj82r500d","yes");
INSERT INTO `wp_options` VALUES ("321","drstk_search_title","on","yes");
INSERT INTO `wp_options` VALUES ("322","drstk_search_creator","on","yes");
INSERT INTO `wp_options` VALUES ("323","drstk_search_date","on","yes");
INSERT INTO `wp_options` VALUES ("324","drstk_search_abstract","on","yes");
INSERT INTO `wp_options` VALUES ("325","drstk_browse_title","on","yes");
INSERT INTO `wp_options` VALUES ("326","drstk_browse_creator","on","yes");
INSERT INTO `wp_options` VALUES ("327","drstk_browse_abstract","on","yes");
INSERT INTO `wp_options` VALUES ("328","drstk_browse_date","on","yes");
INSERT INTO `wp_options` VALUES ("329","drstk_search_page_title","Search","yes");
INSERT INTO `wp_options` VALUES ("330","drstk_browse_page_title","Browse","yes");
INSERT INTO `wp_options` VALUES ("331","drstk_collection_page_title","Browse","yes");
INSERT INTO `wp_options` VALUES ("332","drstk_collections_page_title","Collections","yes");
INSERT INTO `wp_options` VALUES ("333","drstk_item_page_metadata","","yes");
INSERT INTO `wp_options` VALUES ("430","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES ("2098","jetpack_sync_settings_disable","0","yes");
INSERT INTO `wp_options` VALUES ("2065","do_activate","0","yes");
INSERT INTO `wp_options` VALUES ("49002","fresh_site","0","yes");
INSERT INTO `wp_options` VALUES ("1093","widget_context_settings","a:1:{s:8:\"contexts\";a:5:{s:8:\"location\";s:1:\"1\";s:28:\"custom_post_types_taxonomies\";s:1:\"1\";s:10:\"word_count\";s:1:\"1\";s:3:\"url\";s:1:\"1\";s:11:\"admin_notes\";s:1:\"1\";}}","yes");
INSERT INTO `wp_options` VALUES ("2101","jpsq_sync-1472757866.915243-10403-1","a:5:{i:0;s:18:\"deactivated_plugin\";i:1;a:2:{i:0;s:19:\"jetpack/jetpack.php\";i:1;b:0;}i:2;i:2;i:3;d:1472757866.915234088897705078125;i:4;b:0;}","no");
INSERT INTO `wp_options` VALUES ("117287","wpsc_feed_list","a:51:{i:0;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:1;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:2;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:3;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:4;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:5;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:6;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:7;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:8;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:9;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:10;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:11;s:174:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.html/wp-cache-0d1fd6251d08490202729edb8d01e81c.php\";i:12;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:13;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:14;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:15;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:16;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:17;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:18;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:19;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:20;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:21;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:22;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:23;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:24;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:25;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:26;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:27;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:28;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:29;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:30;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:31;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:32;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:33;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:34;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:35;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:36;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:37;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:38;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:39;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:40;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:41;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:42;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:43;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:44;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";i:45;s:162:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-misc.xml/wp-cache-8dae2195a1a2d3054e093758cabbf9af.php\";i:46;s:158:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.html/wp-cache-a9cf7f091c7dfe591eef5e54163b8baa.php\";i:47;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:48;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-01.xml/wp-cache-7d8c8e0b9be78a3f5118553a5a07601a.php\";i:49;s:173:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap-pt-page-2016-02.xml/wp-cache-52accdf0e3e2cd59bcd34e7cf3d261ca.php\";i:50;s:157:\"/mnt/wordpressdata/dmcstudios/wp-content/cache/supercache/recordingstudios.library.northeastern.edu/sitemap.xml/wp-cache-c95d7fe9b43e98215fd66fc9efff5275.php\";}","yes");
INSERT INTO `wp_options` VALUES ("2109","sm_options","a:58:{s:18:\"sm_b_prio_provider\";s:41:\"GoogleSitemapGeneratorPrioByCountProvider\";s:9:\"sm_b_ping\";b:1;s:10:\"sm_b_stats\";b:0;s:12:\"sm_b_autozip\";b:1;s:11:\"sm_b_memory\";s:0:\"\";s:9:\"sm_b_time\";i:-1;s:18:\"sm_b_style_default\";b:1;s:10:\"sm_b_style\";s:0:\"\";s:12:\"sm_b_baseurl\";s:0:\"\";s:11:\"sm_b_robots\";b:1;s:9:\"sm_b_html\";b:1;s:12:\"sm_b_exclude\";a:1:{i:0;s:3:\"764\";}s:17:\"sm_b_exclude_cats\";a:0:{}s:10:\"sm_in_home\";b:1;s:11:\"sm_in_posts\";b:1;s:15:\"sm_in_posts_sub\";b:0;s:11:\"sm_in_pages\";b:1;s:10:\"sm_in_cats\";b:0;s:15:\"sm_product_tags\";b:1;s:17:\"sm_in_product_cat\";b:1;s:10:\"sm_in_arch\";b:0;s:10:\"sm_in_auth\";b:0;s:10:\"sm_in_tags\";b:0;s:9:\"sm_in_tax\";a:0:{}s:17:\"sm_in_customtypes\";a:0:{}s:13:\"sm_in_lastmod\";b:1;s:17:\"sm_b_sitemap_name\";s:7:\"sitemap\";s:10:\"sm_cf_home\";s:5:\"daily\";s:11:\"sm_cf_posts\";s:7:\"monthly\";s:11:\"sm_cf_pages\";s:6:\"weekly\";s:10:\"sm_cf_cats\";s:6:\"weekly\";s:17:\"sm_cf_product_cat\";s:6:\"weekly\";s:10:\"sm_cf_auth\";s:6:\"weekly\";s:15:\"sm_cf_arch_curr\";s:5:\"daily\";s:14:\"sm_cf_arch_old\";s:6:\"yearly\";s:10:\"sm_cf_tags\";s:6:\"weekly\";s:10:\"sm_pr_home\";d:1;s:11:\"sm_pr_posts\";d:0.6;s:15:\"sm_pr_posts_min\";d:0.2;s:11:\"sm_pr_pages\";d:0.6;s:10:\"sm_pr_cats\";d:0.3;s:17:\"sm_pr_product_cat\";d:0.3;s:10:\"sm_pr_arch\";d:0.3;s:10:\"sm_pr_auth\";d:0.3;s:10:\"sm_pr_tags\";d:0.3;s:12:\"sm_i_donated\";b:0;s:17:\"sm_i_hide_donated\";b:0;s:17:\"sm_i_install_date\";i:1472757919;s:16:\"sm_i_hide_survey\";b:0;s:14:\"sm_i_hide_note\";b:0;s:15:\"sm_i_hide_works\";b:0;s:16:\"sm_i_hide_donors\";b:0;s:9:\"sm_i_hash\";s:20:\"1447c254c4383e679ebf\";s:8:\"sm_i_tid\";s:0:\"\";s:13:\"sm_i_lastping\";i:1622037722;s:16:\"sm_i_supportfeed\";b:1;s:22:\"sm_i_supportfeed_cache\";i:1666615827;s:13:\"sm_links_page\";i:10;}","yes");
INSERT INTO `wp_options` VALUES ("2114","wpsupercache_start","1472757970","yes");
INSERT INTO `wp_options` VALUES ("2115","wpsupercache_count","0","yes");
INSERT INTO `wp_options` VALUES ("2116","wpsupercache_gc_time","1524588015","yes");
INSERT INTO `wp_options` VALUES ("2117","plugin_warm_cache_statdata","a:8:{i:1482818555;s:27:\"plugin_warm_cache1482818555\";i:1482904880;s:27:\"plugin_warm_cache1482904880\";i:1482991292;s:27:\"plugin_warm_cache1482991292\";i:1483077729;s:27:\"plugin_warm_cache1483077729\";i:1483164139;s:27:\"plugin_warm_cache1483164139\";i:1483250443;s:27:\"plugin_warm_cache1483250443\";i:1483336942;s:27:\"plugin_warm_cache1483336942\";i:1483423288;s:27:\"plugin_warm_cache1483423288\";}","no");
INSERT INTO `wp_options` VALUES ("2118","plugin_warm_cache_api","WBY8jf1dT","yes");
INSERT INTO `wp_options` VALUES ("2119","plugin_warm_cache_sitemap_override","http://recordingstudios.library.northeastern.edu/sitemap.xml","yes");
INSERT INTO `wp_options` VALUES ("6297","plugin_warm_cache_start","0","yes");
INSERT INTO `wp_options` VALUES ("1012","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES ("6248","can_compress_scripts","1","no");
INSERT INTO `wp_options` VALUES ("144524","itsec_cron","a:2:{s:6:\"single\";a:1:{s:11:\"file-change\";a:3:{s:32:\"4ba217b887dd2f9aadd876af1a396262\";a:1:{s:4:\"data\";a:4:{s:4:\"step\";s:9:\"get-files\";s:5:\"chunk\";s:5:\"admin\";s:10:\"loop_start\";i:1527882040;s:9:\"loop_item\";i:1;}}s:32:\"c6051d6e5aab9089073898af769b5dec\";a:1:{s:4:\"data\";a:4:{s:4:\"step\";s:9:\"get-files\";s:5:\"chunk\";s:5:\"admin\";s:10:\"loop_start\";i:1527882520;s:9:\"loop_item\";i:1;}}s:32:\"9dbd8cba91b046f20985ff71b59dc376\";a:1:{s:4:\"data\";a:4:{s:4:\"step\";s:9:\"get-files\";s:5:\"chunk\";s:5:\"admin\";s:10:\"loop_start\";i:1541803265;s:9:\"loop_item\";i:1;}}}}s:9:\"recurring\";a:5:{s:17:\"purge-log-entries\";a:1:{s:4:\"data\";a:0:{}}s:14:\"purge-lockouts\";a:1:{s:4:\"data\";a:0:{}}s:11:\"clear-locks\";a:1:{s:4:\"data\";a:0:{}}s:6:\"backup\";a:1:{s:4:\"data\";a:0:{}}s:12:\"health-check\";a:1:{s:4:\"data\";a:0:{}}}}","no");
INSERT INTO `wp_options` VALUES ("1603","itsec-storage","a:15:{s:6:\"global\";a:39:{s:15:\"lockout_message\";s:5:\"error\";s:20:\"user_lockout_message\";s:64:\"You have been locked out due to too many invalid login attempts.\";s:25:\"community_lockout_message\";s:77:\"Your IP address has been flagged as a threat by the iThemes Security network.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:4:{i:0;s:12:\"10.107.119.0\";i:1;s:12:\"10.15.0.0/16\";i:2;s:14:\"129.10.107.179\";i:3;s:13:\"10.15.181.237\";}s:12:\"log_rotation\";i:14;s:17:\"file_log_rotation\";i:180;s:8:\"log_type\";s:8:\"database\";s:12:\"log_location\";s:70:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/logs\";s:8:\"log_info\";s:18:\"dmc-studios-gtnbai\";s:14:\"allow_tracking\";b:0;s:11:\"write_files\";b:1;s:10:\"nginx_file\";s:40:\"/mnt/wordpressdata/dmcstudios/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:11:\"did_upgrade\";b:0;s:9:\"lock_file\";b:0;s:5:\"proxy\";s:9:\"automatic\";s:12:\"proxy_header\";s:20:\"HTTP_X_FORWARDED_FOR\";s:14:\"hide_admin_bar\";b:0;s:16:\"show_error_codes\";b:0;s:19:\"show_security_check\";b:0;s:5:\"build\";i:4116;s:13:\"initial_build\";i:4112;s:20:\"activation_timestamp\";i:1452894399;s:11:\"cron_status\";i:1;s:8:\"use_cron\";b:1;s:14:\"cron_test_time\";i:1667070728;s:19:\"enable_grade_report\";b:0;s:10:\"server_ips\";a:0:{}s:13:\"feature_flags\";a:0:{}s:14:\"proxy_override\";b:0;s:25:\"show_new_dashboard_notice\";b:0;s:12:\"digest_email\";b:1;s:19:\"email_notifications\";b:1;s:18:\"notification_email\";a:1:{i:0;s:13:\"k.yee@neu.edu\";}s:12:\"backup_email\";a:1:{i:0;s:13:\"k.yee@neu.edu\";}}s:13:\"404-detection\";a:4:{s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}}s:9:\"away-mode\";a:7:{s:4:\"type\";s:5:\"daily\";s:5:\"start\";i:1453435200;s:10:\"start_time\";i:0;s:3:\"end\";i:1453543200;s:8:\"end_time\";i:21600;s:13:\"override_type\";s:0:\"\";s:12:\"override_end\";i:0;}s:9:\"ban-users\";a:4:{s:7:\"default\";b:1;s:16:\"enable_ban_lists\";b:1;s:9:\"host_list\";a:1:{i:0;s:13:\"94.229.68.210\";}s:10:\"agent_list\";a:0:{}}s:11:\"brute-force\";a:4:{s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;s:14:\"auto_ban_admin\";b:0;}s:6:\"backup\";a:9:{s:9:\"all_sites\";b:0;s:6:\"method\";i:2;s:8:\"location\";s:73:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:10;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:1;s:8:\"last_run\";i:1666964947;}s:11:\"file-change\";a:11:{s:9:\"file_list\";a:0:{}s:5:\"types\";a:39:{i:0;s:4:\".log\";i:1;s:3:\".mo\";i:2;s:3:\".po\";i:3;s:4:\".bmp\";i:4;s:4:\".gif\";i:5;s:4:\".ico\";i:6;s:4:\".jpe\";i:7;s:5:\".jpeg\";i:8;s:4:\".jpg\";i:9;s:4:\".png\";i:10;s:4:\".psd\";i:11;s:4:\".raw\";i:12;s:4:\".svg\";i:13;s:4:\".tif\";i:14;s:5:\".tiff\";i:15;s:4:\".aif\";i:16;s:5:\".flac\";i:17;s:4:\".m4a\";i:18;s:4:\".mp3\";i:19;s:4:\".oga\";i:20;s:4:\".ogg\";i:22;s:3:\".ra\";i:23;s:4:\".wav\";i:24;s:4:\".wma\";i:25;s:4:\".asf\";i:26;s:4:\".avi\";i:27;s:4:\".mkv\";i:28;s:4:\".mov\";i:29;s:4:\".mp4\";i:30;s:4:\".mpe\";i:31;s:5:\".mpeg\";i:32;s:4:\".mpg\";i:33;s:4:\".ogv\";i:34;s:3:\".qt\";i:35;s:3:\".rm\";i:36;s:4:\".vob\";i:37;s:5:\".webm\";i:38;s:3:\".wm\";i:39;s:4:\".wmv\";}s:12:\"notify_admin\";b:1;s:12:\"show_warning\";b:0;s:15:\"expected_hashes\";a:0:{}s:9:\"last_scan\";i:0;s:6:\"method\";s:7:\"exclude\";s:5:\"email\";b:1;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";d:1466948975;}s:12:\"hide-backend\";a:6:{s:4:\"slug\";s:7:\"wplogin\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:7:\"enabled\";b:0;s:8:\"register\";s:15:\"wp-register.php\";}s:19:\"network-brute-force\";a:5:{s:7:\"api_key\";s:32:\"UqJVgwswBz26W74qeg1zy4rAkAxC5D1B\";s:10:\"api_secret\";s:128:\"uZahjoFlI7mgD988YACHZN1hq2RPj7262q39rU27JWC5En1396LtmUM6r5Bw9iZzV0AOuvfy99wf93P0V13n80fRwJMspKRKRMq5oUB61nQC62hFrDT7CId8QyXNZZ3G\";s:10:\"enable_ban\";b:1;s:13:\"updates_optin\";b:1;s:7:\"api_nag\";b:0;}s:3:\"ssl\";a:3:{s:11:\"require_ssl\";s:7:\"enabled\";s:8:\"frontend\";i:0;s:5:\"admin\";b:0;}s:16:\"strong-passwords\";a:1:{s:4:\"role\";s:11:\"contributor\";}s:13:\"system-tweaks\";a:8:{s:13:\"protect_files\";b:1;s:18:\"directory_browsing\";b:1;s:15:\"request_methods\";b:0;s:24:\"suspicious_query_strings\";b:1;s:22:\"non_english_characters\";b:1;s:16:\"long_url_strings\";b:1;s:17:\"write_permissions\";b:0;s:11:\"uploads_php\";b:1;}s:16:\"wordpress-tweaks\";a:13:{s:18:\"wlwmanifest_header\";b:1;s:14:\"edituri_header\";b:0;s:12:\"comment_spam\";b:1;s:11:\"file_editor\";b:0;s:14:\"disable_xmlrpc\";i:0;s:22:\"allow_xmlrpc_multiauth\";b:0;s:8:\"rest_api\";s:14:\"default-access\";s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:16:\"block_tabnapping\";b:0;s:21:\"valid_user_login_type\";s:4:\"both\";s:26:\"patch_thumb_file_traversal\";b:1;}s:19:\"notification-center\";a:8:{s:9:\"last_sent\";a:1:{s:6:\"digest\";i:1666990748;}s:9:\"resend_at\";a:0:{}s:4:\"data\";a:1:{s:6:\"digest\";a:0:{}}s:15:\"last_mail_error\";s:0:\"\";s:13:\"notifications\";a:4:{s:6:\"digest\";a:6:{s:8:\"schedule\";s:5:\"daily\";s:7:\"enabled\";b:1;s:9:\"user_list\";a:0:{}s:14:\"recipient_type\";s:7:\"default\";s:15:\"previous_emails\";a:1:{i:0;s:13:\"k.yee@neu.edu\";}s:7:\"subject\";N;}s:7:\"lockout\";a:5:{s:7:\"enabled\";b:0;s:9:\"user_list\";a:0:{}s:14:\"recipient_type\";s:7:\"default\";s:15:\"previous_emails\";a:1:{i:0;s:13:\"k.yee@neu.edu\";}s:7:\"subject\";N;}s:6:\"backup\";a:1:{s:14:\"recipient_type\";s:6:\"custom\";}s:11:\"file-change\";a:2:{s:7:\"enabled\";b:0;s:14:\"recipient_type\";s:6:\"custom\";}}s:12:\"admin_emails\";a:1:{i:0;s:13:\"k.yee@neu.edu\";}s:10:\"from_email\";s:0:\"\";s:18:\"default_recipients\";a:1:{s:9:\"user_list\";a:0:{}}}s:21:\"password-requirements\";a:2:{s:20:\"enabled_requirements\";a:1:{s:8:\"strength\";b:1;}s:20:\"requirement_settings\";a:1:{s:8:\"strength\";a:1:{s:4:\"role\";s:11:\"contributor\";}}}}","yes");
INSERT INTO `wp_options` VALUES ("87951","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("139633","akismet_strictness","0","yes");
INSERT INTO `wp_options` VALUES ("139634","akismet_show_user_comments_approved","0","yes");
INSERT INTO `wp_options` VALUES ("139635","wordpress_api_key","c68cd172fec6","yes");
INSERT INTO `wp_options` VALUES ("139636","akismet_spam_count","0","yes");
INSERT INTO `wp_options` VALUES ("1446111","_site_transient_timeout_itsec_wp_upload_dir","1667076248","no");
INSERT INTO `wp_options` VALUES ("1446112","_site_transient_itsec_wp_upload_dir","a:6:{s:4:\"path\";s:56:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads/2022/10\";s:3:\"url\";s:75:\"http://recordingstudios.library.northeastern.edu/wp-content/uploads/2022/10\";s:6:\"subdir\";s:8:\"/2022/10\";s:7:\"basedir\";s:48:\"/mnt/wordpressdata/dmcstudios/wp-content/uploads\";s:7:\"baseurl\";s:67:\"http://recordingstudios.library.northeastern.edu/wp-content/uploads\";s:5:\"error\";b:0;}","no");
INSERT INTO `wp_options` VALUES ("705848","wordfence_version","7.7.1","yes");
INSERT INTO `wp_options` VALUES ("705849","wordfence_case","1","yes");
INSERT INTO `wp_options` VALUES ("705850","wordfence_installed","1","yes");
INSERT INTO `wp_options` VALUES ("705851","wordfenceActivated","1","yes");
INSERT INTO `wp_options` VALUES ("87908","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("87907","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES ("706050","wordfence_ls_version","1.0.11","yes");
INSERT INTO `wp_options` VALUES ("764084","relevanssi_stopwords","a:1:{s:5:\"en_US\";s:1907:\"a,about,above,across,after,afterwards,again,against,all,almost,alone,along,already,also,although,always,am,among,amongst,amoungst,amount,an,and,another,any,anyhow,anyone,anything,anyway,anywhere,are,around,as,at,back,be,became,because,become,becomes,becoming,been,before,beforehand,behind,being,below,beside,besides,between,beyond,bill,both,bottom,but,by,call,can,cannot,cant,co,con,could,couldnt,cry,de,describe,detail,do,done,down,due,during,each,eg,eight,either,eleven,else,elsewhere,empty,enough,etc,even,ever,every,everyone,everything,everywhere,except,few,fifteen,fify,fill,find,fire,first,five,for,former,formerly,forty,found,four,from,front,full,further,get,give,go,had,has,hasnt,have,he,hence,her,here,hereafter,hereby,herein,hereupon,hers,herself,him,himself,his,how,however,hundred,ie,if,in,inc,indeed,interest,into,is,it,its,itself,keep,last,latter,latterly,least,less,ltd,made,many,may,me,meanwhile,might,mill,mine,more,moreover,most,mostly,move,much,must,my,myself,name,namely,neither,never,nevertheless,next,nine,no,nobody,none,noone,nor,not,nothing,now,nowhere,of,off,often,on,once,one,only,onto,or,other,others,otherwise,our,ours,ourselves,out,over,own,part,per,perhaps,please,put,rather,re,same,see,seem,seemed,seeming,seems,serious,several,she,should,show,side,since,sincere,six,sixty,so,some,somehow,someone,something,sometime,sometimes,somewhere,still,such,system,take,ten,than,that,the,their,them,themselves,then,thence,there,thereafter,thereby,therefore,therein,thereupon,these,they,thickv,thin,third,this,those,though,three,through,throughout,thru,thus,to,together,too,top,toward,towards,twelve,twenty,two,un,under,until,up,upon,us,very,via,was,we,well,were,what,whatever,when,whence,whenever,where,whereafter,whereas,whereby,wherein,whereupon,wherever,whether,which,while,whither,who,whoever,whole,whom,whose,why,will,with,within,without,would,yet,you,your,yours,yourself,yourselves\";}","yes");
INSERT INTO `wp_options` VALUES ("99997","bsr_page_size","20000","yes");
INSERT INTO `wp_options` VALUES ("843528","wfls_last_role_change","1664819270","no");
INSERT INTO `wp_options` VALUES ("1446573","_transient_timeout_748260dd9f8cbe5829925dbc698718ac","1667092149","no");
INSERT INTO `wp_options` VALUES ("1446574","_transient_748260dd9f8cbe5829925dbc698718ac","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m046q2368\" src=\"https://repository.library.northeastern.edu/downloads/neu:m046q238t?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m046q2368\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m046q2368\").hide();
  jwplayer(\"drs-item-video-neu-m046q2368\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m046q238t?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m046q2368/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m046q2368/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m046q2368\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m046q2368 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m046q238t?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m046q2368\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m046q2368\").show();
    $(\"#drs-item-video-neu-m046q2368\").hide();
  }
  jwplayer(\"drs-item-video-neu-m046q2368\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m046q2368\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m046q2368\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m046q2368\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m046q2368\").play()
   })
  });</script><div class=\"hidden\">2020-07-30T16:21:52Z<br/>2020-07-30T17:48:02Z<br/>A<br/>CoreFile<br/>neu:gm80mj70n<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2020-07-30T16:21:58Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mj70n+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2020-07-30T17:47:59Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mj70n+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2020-07-30T17:48:02Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1347,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mj70n+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.5\",\"dsCreateDate\":\"2020-07-30T16:24:15Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":752,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mj70n+properties+properties.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2020-07-30T17:47:59Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3375,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mj70n+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2020-07-30T16:21:52Z\",\"objLastModDate\":\"2020-07-30T17:48:02Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Agm80mj70n/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Agm80mj70n/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>001126975<br/>001126975<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_1<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_2<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_3<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_4<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_5<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_1<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_2<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_3<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_4<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:rx9189661<br/>000446743<br/>001126975<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_1<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_2<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_3<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_4<br/>/downloads/neu:m046q238t?datastream_id=thumbnail_5<br/>VideoFile<br/>In Plain Sight<br/>In Plain Sight<br/>In Plain Sight<br/>In Plain Sight<br/>A Too Many Cooks Production Special Thanks to: Michelle Carr and Zoie Pruner<br/>College of Arts, Media, and Design<br/>College of Arts, Media, and Design<br/>2020-07-30<br/>2020-07-30<br/>Street Art<br/>London<br/>Graffiti<br/>Documentary<br/>Street Art<br/>London<br/>Graffiti<br/>Documentary<br/>http://hdl.handle.net/2047/D20382505<br/>http://hdl.handle.net/2047/D20382505<br/>Street Art<br/>London<br/>Graffiti<br/>Documentary<br/>In Plain Sight<br/>In Plain Sight<br/>in plain sight<br/>2020/07/30<br/>In Plain Sight<br/>2020-07-30<br/>Street Art<br/>Banrey, Antonio<br/>Choate, Erica<br/>Cortina, Deanna<br/>Erram, Divya<br/>Gershbein, Vanessa<br/>List, Siena<br/>Wilson, Mary Beth<br/>Banrey, Antonio<br/>Choate, Erica<br/>Cortina, Deanna<br/>Erram, Divya<br/>Gershbein, Vanessa<br/>List, Siena<br/>Wilson, Mary Beth<br/>College of Arts, Media, and Design<br/>Banrey, Antonio<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2020-07-30T17:48:35.847Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446630","_transient_8040d619219797b5afe24a9f47976f64","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044g847j\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044g8493?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044g847j\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044g847j\").hide();
  jwplayer(\"drs-item-video-neu-m044g847j\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044g8493?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g847j/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g847j/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044g847j\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044g847j video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044g8493?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044g847j\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044g847j\").show();
    $(\"#drs-item-video-neu-m044g847j\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044g847j\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g847j\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g847j\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044g847j\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044g847j\").play()
   })
  });</script><div class=\"hidden\">2019-07-08T19:52:45Z<br/>2019-07-08T19:55:44Z<br/>A<br/>CoreFile<br/>neu:f1881z27t<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-07-08T19:52:46Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z27t+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2019-07-08T19:55:29Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z27t+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2019-07-08T19:55:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1038,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z27t+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2019-07-08T19:55:44Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":711,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z27t+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2019-07-08T19:55:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2637,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z27t+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-07-08T19:52:45Z\",\"objLastModDate\":\"2019-07-08T19:55:44Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z27t/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z27t/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_5<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8493?datastream_id=thumbnail_5<br/>AudioFile<br/>Sonic<br/>Sonic<br/>Sonic<br/>Sonic<br/>Liam Numrich: Guitar, Vocals Gabriel Pino: Drums, Keyboard, Guitar Joseph Handel: Bass Ryan Arshonsky: Lead Guitar Written by Liam Numrich Engineered by Gabriel Pino and Isaac Schutz (Snell Studios Co-op Spring 2019) Mixed by Gabriel Pino<br/>2019-06-14<br/>2019-06-14<br/>alternative<br/>rock<br/>indie<br/>indie rock<br/>post-punk<br/>Boston<br/>alternative<br/>rock<br/>indie<br/>indie rock<br/>post-punk<br/>Boston<br/>http://hdl.handle.net/2047/D20318898<br/>http://hdl.handle.net/2047/D20318898<br/>alternative<br/>rock<br/>indie<br/>indie rock<br/>post-punk<br/>Boston<br/>Sonic<br/>Sonic<br/>sonic<br/>2019/06/14<br/>Sonic<br/>2019-06-14<br/>alternative<br/>Channel, Midnight<br/>Channel, Midnight<br/>Channel, Midnight<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2019-07-08T19:55:44.619Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446569","_transient_timeout_9af6656c208251556e050f48b661aef6","1667092149","no");
INSERT INTO `wp_options` VALUES ("1446570","_transient_9af6656c208251556e050f48b661aef6","<div class=\'drs-item\'><img id=\"drs-item-img-neu-bz60hv16j\" src=\"https://repository.library.northeastern.edu/downloads/neu:bz60hv183?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-bz60hv16j\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-bz60hv16j\").hide();
  jwplayer(\"drs-item-video-neu-bz60hv16j\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:bz60hv183?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:bz60hv16j/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:bz60hv16j/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-bz60hv16j\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-bz60hv16j video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:bz60hv183?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-bz60hv16j\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-bz60hv16j\").show();
    $(\"#drs-item-video-neu-bz60hv16j\").hide();
  }
  jwplayer(\"drs-item-video-neu-bz60hv16j\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-bz60hv16j\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-bz60hv16j\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-bz60hv16j\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-bz60hv16j\").play()
   })
  });</script><div class=\"hidden\">2021-02-26T15:06:23Z<br/>2021-03-18T20:55:03Z<br/>A<br/>CoreFile<br/>neu:ww72bb87b<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2021-02-26T15:06:28Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bb87b+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2021-03-18T20:55:00Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bb87b+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2021-03-18T20:55:03Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":2269,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bb87b+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2021-02-26T15:12:40Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":707,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bb87b+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2021-03-18T20:55:01Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":4447,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bb87b+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2021-02-26T15:06:23Z\",\"objLastModDate\":\"2021-03-18T20:55:03Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Aww72bb87b/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Aww72bb87b/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_1<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_2<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_3<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_4<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_5<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_1<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_2<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_3<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_4<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_1<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_2<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_3<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_4<br/>/downloads/neu:bz60hv183?datastream_id=thumbnail_5<br/>AudioFile<br/>Protect The Pack<br/>Protect The Pack<br/>Protect The Pack<br/>Protect The Pack<br/>Recorded entirely in lockdown. Lyrics: People love dogs, and dogs have really helped people in the pandemic. The husky is a loyal friend to think about when you\'re feeling scared. lyrics How do you think I\'m feeling? Bored, and staring at my ceiling? The outside is appealing, but This mask still feels revealing. I can make the compromise, As long as you can empathize, If we all could harmonize, There\'d be much less to sacrifice Following the protocol Walk to the testing hall Play lots of Solitaire, try to keep us safe, that\'s all Lots of time in silence Sights inside my eyelids Appreciate the fact that we can all relate, it\'s timeless Gotta lotta guidelines Clouding up my mind\'s eye All my plans got sidelined But I\'m still in this fight Neighbors got their friends over Walls moving in, closer Stuck in a cell without bars At least I got a spot for the car Rather stay at home, cure this mental hangover<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>2021-03-15<br/>2021-03-15<br/>Protect the Pack<br/>Protect the Pack<br/>http://hdl.handle.net/2047/D20401748<br/>http://hdl.handle.net/2047/D20401748<br/>Protect the Pack<br/>Protect The Pack<br/>Protect The Pack<br/>protect the pack<br/>2021/03/15<br/>Protect The Pack<br/>2021-03-15<br/>Protect the Pack<br/>DeUrso, Ben<br/>Iannone, Jonathan<br/>di Pierro, Chris<br/>Sayers, Patrick<br/>Zimiroski, Jared<br/>Schutz, Isaac<br/>Chen, Kelly<br/>Barrett, Simon<br/>Short, Craig<br/>DeUrso, Ben<br/>Iannone, Jonathan<br/>di Pierro, Chris<br/>Sayers, Patrick<br/>Zimiroski, Jared<br/>Schutz, Isaac<br/>Chen, Kelly<br/>Barrett, Simon<br/>Short, Craig<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>De Urso, Ben<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2021-03-18T20:55:27.021Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446800","_transient_doing_cron","1667051347.0956969261169433593750","yes");
INSERT INTO `wp_options` VALUES ("1446801","itsec-lock-backup","1667051527","no");
INSERT INTO `wp_options` VALUES ("1445046","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1667036650;s:7:\"checked\";a:14:{s:19:\"akismet/akismet.php\";s:6:\"4.1.10\";s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";s:5:\"2.7.2\";s:17:\"drs-tk/drs-tk.php\";s:5:\"1.1.1\";s:36:\"google-sitemap-generator/sitemap.php\";s:5:\"4.1.5\";s:41:\"better-wp-security/better-wp-security.php\";s:5:\"7.6.1\";s:19:\"jetpack/jetpack.php\";s:5:\"7.1.3\";s:39:\"siteorigin-panels/siteorigin-panels.php\";s:6:\"2.18.2\";s:25:\"relevanssi/relevanssi.php\";s:6:\"4.17.1\";s:41:\"transients-manager/transients-manager.php\";s:5:\"1.8.1\";s:25:\"warm-cache/warm-cache.php\";s:5:\"4.0.0\";s:33:\"widget-context/widget-context.php\";s:5:\"1.3.2\";s:23:\"wordfence/wordfence.php\";s:5:\"7.7.1\";s:27:\"wp-rollback/wp-rollback.php\";s:5:\"1.7.2\";s:27:\"wp-super-cache/wp-cache.php\";s:5:\"1.7.4\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:13:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.0.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:5:\"6.0.3\";s:12:\"requires_php\";s:3:\"5.2\";s:13:\"compatibility\";a:0:{}}s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/black-studio-tinymce-widget\";s:4:\"slug\";s:27:\"black-studio-tinymce-widget\";s:6:\"plugin\";s:59:\"black-studio-tinymce-widget/black-studio-tinymce-widget.php\";s:11:\"new_version\";s:5:\"2.7.2\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/black-studio-tinymce-widget/\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/plugin/black-studio-tinymce-widget.2.7.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:80:\"https://ps.w.org/black-studio-tinymce-widget/assets/icon-256x256.png?rev=2627604\";s:2:\"1x\";s:72:\"https://ps.w.org/black-studio-tinymce-widget/assets/icon.svg?rev=2627604\";s:3:\"svg\";s:72:\"https://ps.w.org/black-studio-tinymce-widget/assets/icon.svg?rev=2627604\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/black-studio-tinymce-widget/assets/banner-1544x500.png?rev=2627604\";s:2:\"1x\";s:82:\"https://ps.w.org/black-studio-tinymce-widget/assets/banner-772x250.png?rev=2627604\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.1\";}s:36:\"google-sitemap-generator/sitemap.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:38:\"w.org/plugins/google-sitemap-generator\";s:4:\"slug\";s:24:\"google-sitemap-generator\";s:6:\"plugin\";s:36:\"google-sitemap-generator/sitemap.php\";s:11:\"new_version\";s:5:\"4.1.5\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/google-sitemap-generator/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/google-sitemap-generator.4.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/google-sitemap-generator/assets/icon-256x256.png?rev=2713572\";s:2:\"1x\";s:77:\"https://ps.w.org/google-sitemap-generator/assets/icon-128x128.png?rev=2713572\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/google-sitemap-generator/assets/banner-772x250.png?rev=2726546\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.3\";}s:41:\"better-wp-security/better-wp-security.php\";O:8:\"stdClass\":14:{s:2:\"id\";s:32:\"w.org/plugins/better-wp-security\";s:4:\"slug\";s:18:\"better-wp-security\";s:6:\"plugin\";s:41:\"better-wp-security/better-wp-security.php\";s:11:\"new_version\";s:5:\"8.1.3\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/better-wp-security/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/better-wp-security.8.1.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/better-wp-security/assets/icon-256x256.png?rev=2698018\";s:2:\"1x\";s:63:\"https://ps.w.org/better-wp-security/assets/icon.svg?rev=2698018\";s:3:\"svg\";s:63:\"https://ps.w.org/better-wp-security/assets/icon.svg?rev=2698018\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/better-wp-security/assets/banner-772x250.png?rev=2698018\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"7.3\";s:13:\"compatibility\";a:0:{}s:14:\"upgrade_notice\";s:57:\"<p>Version 8.1.3 includes important security updates.</p>\";}s:19:\"jetpack/jetpack.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:21:\"w.org/plugins/jetpack\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:4:\"11.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:55:\"https://downloads.wordpress.org/plugin/jetpack.11.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:60:\"https://ps.w.org/jetpack/assets/icon-256x256.png?rev=2638128\";s:2:\"1x\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2638128\";s:3:\"svg\";s:52:\"https://ps.w.org/jetpack/assets/icon.svg?rev=2638128\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/jetpack/assets/banner-1544x500.png?rev=2653649\";s:2:\"1x\";s:62:\"https://ps.w.org/jetpack/assets/banner-772x250.png?rev=2653649\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.0.3\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";a:0:{}}s:39:\"siteorigin-panels/siteorigin-panels.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/siteorigin-panels\";s:4:\"slug\";s:17:\"siteorigin-panels\";s:6:\"plugin\";s:39:\"siteorigin-panels/siteorigin-panels.php\";s:11:\"new_version\";s:6:\"2.18.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/siteorigin-panels/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/siteorigin-panels.2.18.2.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:70:\"https://ps.w.org/siteorigin-panels/assets/icon-256x256.png?rev=2556869\";s:2:\"1x\";s:62:\"https://ps.w.org/siteorigin-panels/assets/icon.svg?rev=2556869\";s:3:\"svg\";s:62:\"https://ps.w.org/siteorigin-panels/assets/icon.svg?rev=2556869\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/siteorigin-panels/assets/banner-1544x500.png?rev=2600116\";s:2:\"1x\";s:72:\"https://ps.w.org/siteorigin-panels/assets/banner-772x250.png?rev=2600116\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:25:\"relevanssi/relevanssi.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/relevanssi\";s:4:\"slug\";s:10:\"relevanssi\";s:6:\"plugin\";s:25:\"relevanssi/relevanssi.php\";s:11:\"new_version\";s:6:\"4.17.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/relevanssi/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/relevanssi.4.17.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/relevanssi/assets/icon-256x256.png?rev=2025044\";s:2:\"1x\";s:63:\"https://ps.w.org/relevanssi/assets/icon-128x128.png?rev=2025044\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/relevanssi/assets/banner-1544x500.jpg?rev=1647178\";s:2:\"1x\";s:65:\"https://ps.w.org/relevanssi/assets/banner-772x250.jpg?rev=1647180\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:41:\"transients-manager/transients-manager.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:32:\"w.org/plugins/transients-manager\";s:4:\"slug\";s:18:\"transients-manager\";s:6:\"plugin\";s:41:\"transients-manager/transients-manager.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/transients-manager/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/transients-manager.2.0.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/transients-manager/assets/icon-256x256.png?rev=1671074\";s:2:\"1x\";s:63:\"https://ps.w.org/transients-manager/assets/icon.svg?rev=1671074\";s:3:\"svg\";s:63:\"https://ps.w.org/transients-manager/assets/icon.svg?rev=1671074\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/transients-manager/assets/banner-1544x500.png?rev=2645363\";s:2:\"1x\";s:73:\"https://ps.w.org/transients-manager/assets/banner-772x250.png?rev=2645363\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/transients-manager/assets/banner-1544x500-rtl.png?rev=2645363\";s:2:\"1x\";s:77:\"https://ps.w.org/transients-manager/assets/banner-772x250-rtl.png?rev=2645363\";}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:5:\"6.0.3\";s:12:\"requires_php\";s:6:\"5.6.20\";s:13:\"compatibility\";a:0:{}}s:25:\"warm-cache/warm-cache.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/warm-cache\";s:4:\"slug\";s:10:\"warm-cache\";s:6:\"plugin\";s:25:\"warm-cache/warm-cache.php\";s:11:\"new_version\";s:5:\"4.0.0\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/warm-cache/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/warm-cache.4.0.0.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:54:\"https://s.w.org/plugins/geopattern-icon/warm-cache.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";}s:33:\"widget-context/widget-context.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/widget-context\";s:4:\"slug\";s:14:\"widget-context\";s:6:\"plugin\";s:33:\"widget-context/widget-context.php\";s:11:\"new_version\";s:5:\"1.3.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/widget-context/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/widget-context.1.3.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/widget-context/assets/icon-256x256.png?rev=1919865\";s:2:\"1x\";s:67:\"https://ps.w.org/widget-context/assets/icon-128x128.png?rev=1919865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/widget-context/assets/banner-1544x500.png?rev=1919865\";s:2:\"1x\";s:69:\"https://ps.w.org/widget-context/assets/banner-772x250.png?rev=1919865\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"7.7.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.7.7.1.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=2070855\";s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";}s:27:\"wp-rollback/wp-rollback.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/wp-rollback\";s:4:\"slug\";s:11:\"wp-rollback\";s:6:\"plugin\";s:27:\"wp-rollback/wp-rollback.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/wp-rollback/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wp-rollback.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/wp-rollback/assets/icon-256x256.jpg?rev=1159170\";s:2:\"1x\";s:64:\"https://ps.w.org/wp-rollback/assets/icon-128x128.jpg?rev=1159170\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/wp-rollback/assets/banner-772x250.jpg?rev=1948781\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.8\";}s:27:\"wp-super-cache/wp-cache.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:28:\"w.org/plugins/wp-super-cache\";s:4:\"slug\";s:14:\"wp-super-cache\";s:6:\"plugin\";s:27:\"wp-super-cache/wp-cache.php\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/wp-super-cache/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wp-super-cache.1.9.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/wp-super-cache/assets/icon-256x256.png?rev=1095422\";s:2:\"1x\";s:67:\"https://ps.w.org/wp-super-cache/assets/icon-128x128.png?rev=1095422\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/wp-super-cache/assets/banner-1544x500.png?rev=1082414\";s:2:\"1x\";s:69:\"https://ps.w.org/wp-super-cache/assets/banner-772x250.png?rev=1082414\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";s:6:\"tested\";s:5:\"6.0.3\";s:12:\"requires_php\";s:3:\"5.6\";s:13:\"compatibility\";a:0:{}}}}","no");
INSERT INTO `wp_options` VALUES ("1386428","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1667036650;s:7:\"checked\";a:3:{s:11:\"quest-child\";s:5:\"1.2.2\";s:5:\"quest\";s:5:\"1.5.3\";s:14:\"twentynineteen\";s:3:\"2.3\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","no");
INSERT INTO `wp_options` VALUES ("1446607","_transient_timeout_0a00efe7ea7dc01b81e3863e9c54b658","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446608","_transient_0a00efe7ea7dc01b81e3863e9c54b658","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0460279f\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0460281g?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0460279f\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0460279f\").hide();
  jwplayer(\"drs-item-video-neu-m0460279f\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0460281g?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0460279f/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0460279f/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0460279f\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0460279f video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0460281g?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0460279f\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0460279f\").show();
    $(\"#drs-item-video-neu-m0460279f\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0460279f\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0460279f\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0460279f\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0460279f\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0460279f\").play()
   })
  });</script><div class=\"hidden\">2020-04-29T14:42:47Z<br/>2020-04-29T17:02:28Z<br/>A<br/>CoreFile<br/>neu:gm80j792g<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2020-04-29T14:42:48Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j792g+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2020-04-29T17:02:27Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j792g+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2020-04-29T17:02:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1097,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j792g+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2020-04-29T14:56:08Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":738,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j792g+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2020-04-29T17:02:27Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2472,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j792g+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2020-04-29T14:42:47Z\",\"objLastModDate\":\"2020-04-29T17:02:28Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j792g/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j792g/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>001273100<br/>neu:gm80j406s<br/>neu:gm80j406s<br/>001273100<br/>001273100<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_1<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_2<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_3<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_4<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_5<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_1<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_2<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_3<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_4<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:gm80j406s<br/>001273100<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_1<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_2<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_3<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_4<br/>/downloads/neu:m0460281g?datastream_id=thumbnail_5<br/>VideoFile<br/>Caribbean American Foundation News Report<br/>Caribbean American Foundation News Report<br/>Caribbean American Foundation News Report<br/>Caribbean American Foundation News Report<br/>Documentary project from JRNL 5314 section, Spring 2020.<br/>Northeastern University Library Recording Studio<br/>Northeastern University School of Journalism<br/>Northeastern University Library Recording Studio<br/>Northeastern University School of Journalism<br/>2020-04-29<br/>2020-04-29<br/>Journalism<br/>Caribbean American Foundation<br/>Journalism<br/>Caribbean American Foundation<br/>http://hdl.handle.net/2047/D20357760<br/>http://hdl.handle.net/2047/D20357760<br/>Journalism<br/>Caribbean American Foundation<br/>Caribbean American Foundation News Report<br/>Caribbean American Foundation News Report<br/>caribbean american foundation news report<br/>2020/04/29<br/>Caribbean American Foundation News Report<br/>2020-04-29<br/>Journalism<br/>Karpova, Ekaterina<br/>Karpova, Ekaterina<br/>Northeastern University Library Recording Studio<br/>Northeastern University School of Journalism<br/>Karpova, Ekaterina<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:gm80j406s<br/>2020-04-29T17:02:39.175Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446621","_transient_timeout_7390710766feb04992921fe1b2ab17cd","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446622","_transient_7390710766feb04992921fe1b2ab17cd","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044fd88f\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044fd90g?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044fd88f\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044fd88f\").hide();
  jwplayer(\"drs-item-video-neu-m044fd88f\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044fd90g?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044fd88f/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044fd88f/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044fd88f\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044fd88f video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044fd90g?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044fd88f\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044fd88f\").show();
    $(\"#drs-item-video-neu-m044fd88f\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044fd88f\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044fd88f\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044fd88f\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044fd88f\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044fd88f\").play()
   })
  });</script><div class=\"hidden\">2019-06-14T18:39:24Z<br/>2019-06-14T18:43:00Z<br/>A<br/>CoreFile<br/>neu:f1881x81d<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-06-14T18:39:25Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881x81d+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2019-06-14T18:42:44Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881x81d+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2019-06-14T18:42:43Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1182,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881x81d+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2019-06-14T18:43:00Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":709,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881x81d+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2019-06-14T18:42:43Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2794,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881x81d+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2019-06-14T18:39:24Z\",\"objLastModDate\":\"2019-06-14T18:43:00Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881x81d/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881x81d/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_1<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_2<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_3<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_4<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_5<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_1<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_2<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_3<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_4<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_1<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_2<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_3<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_4<br/>/downloads/neu:m044fd90g?datastream_id=thumbnail_5<br/>AudioFile<br/>Shooting Blind<br/>Shooting Blind<br/>Shooting Blind<br/>Shooting Blind<br/>released February 15, 2019 Produced by Zac Kerwin (DMC Studios Co-op Fall 2018) Released with Green Line Records Cover art by Rosie Amato Layout design by Cole Haden Music and lyrics by Brennan Wedl Bass- Sophie Potrykus Electric guitar- Zack Page Drums- Austin Corona Acoustic guitar/vox- Brennan Wedl<br/>Green Line Records<br/>Green Line Records<br/>2019-02-15<br/>2019-02-15<br/>Boston Music<br/>Folk<br/>political folk<br/>singer songwriter<br/>indie folk<br/>alternative rock<br/>Boston Music<br/>Folk<br/>political folk<br/>singer songwriter<br/>indie folk<br/>alternative rock<br/>http://hdl.handle.net/2047/D20318247<br/>http://hdl.handle.net/2047/D20318247<br/>Boston Music<br/>Folk<br/>political folk<br/>singer songwriter<br/>indie folk<br/>alternative rock<br/>Shooting Blind<br/>Shooting Blind<br/>shooting blind<br/>2019/02/15<br/>Shooting Blind<br/>2019-02-15<br/>Boston Music<br/>Wedl, Brennan<br/>Wedl, Brennan<br/>Green Line Records<br/>Wedl, Brennan<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2019-06-14T18:43:00.882Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446619","_transient_timeout_4e3c5d7f67ef70f9cfedc84e3ad6eb87","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446620","_transient_4e3c5d7f67ef70f9cfedc84e3ad6eb87","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044hb60p\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044hb627?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044hb60p\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044hb60p\").hide();
  jwplayer(\"drs-item-video-neu-m044hb60p\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044hb627?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044hb60p/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044hb60p/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044hb60p\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044hb60p video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044hb627?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044hb60p\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044hb60p\").show();
    $(\"#drs-item-video-neu-m044hb60p\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044hb60p\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044hb60p\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044hb60p\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044hb60p\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044hb60p\").play()
   })
  });</script><div class=\"hidden\">2019-07-29T19:26:33Z<br/>2019-07-30T15:50:11Z<br/>A<br/>CoreFile<br/>neu:f1881z436<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-07-29T19:26:34Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z436+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2019-07-30T15:49:57Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z436+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2019-07-30T15:49:56Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":2009,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z436+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2019-07-30T15:50:12Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":711,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z436+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2019-07-30T15:49:56Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3478,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z436+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2019-07-29T19:26:33Z\",\"objLastModDate\":\"2019-07-30T15:50:11Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z436/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z436/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>northeastern:drs:library:dmc_studios<br/>001273100<br/>neu:rx9189661<br/>neu:rx9189661<br/>001273100<br/>001273100<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_1<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_2<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_3<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_4<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_5<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_1<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_2<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_3<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_4<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:rx9189661<br/>001273100<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_1<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_2<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_3<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_4<br/>/downloads/neu:m044hb627?datastream_id=thumbnail_5<br/>VideoFile<br/>Got To Feel It<br/>Got To Feel It<br/>Got To Feel It<br/>Got To Feel It<br/>caliibri is a well-rounded musician who has a sufficient enough grasp on her genre\'s music that she is able to create her own tracks independently. Due to the fact that she plays both guitar and bass and produces her own music, she is able to turn an idea into a full, Soundcloud-ready upload in a few days. \"Jessica Erdmann makes music for the party AND the after-party\" The music she releases as caliibri aims to get people dancing, even as it incorporates complex melodies and chordal structures. A musician from a young age, she started taking guitar lessons as a kid and became fascinated with soloing and creating her own songs and riffs. By high school, she had become a guitar teacher and started putting her guitar recordings on Garageband. After moving from Vermont to Boston, she started exploring the possibilities of creating sound with samples and synthesizers rather than acoustic instruments. She adopted the caliibri moniker, and has since been focused mainly on lofi and house music. In addition to producing her own music, Jessica has also DJed parties, written music for podcasts, and played as a session musician on bass and guitar. Her upcoming single \"Get To Feel It\" and an accompanying music video will be released in Spring 2019.<br/>2019-03-20<br/>2019-03-20<br/>EDM<br/>Music Industry<br/>MUSU 333<br/>EDM<br/>Music Industry<br/>MUSU 333<br/>http://hdl.handle.net/2047/D20319718<br/>http://hdl.handle.net/2047/D20319718<br/>EDM<br/>Music Industry<br/>MUSU 333<br/>Got To Feel It<br/>Got To Feel It<br/>got to feel it<br/>2019/03/20<br/>Got To Feel It<br/>2019-03-20<br/>EDM<br/>Erdmann, Jessica<br/>Erdmann, Jessica<br/>Erdmann, Jessica<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2019-07-30T15:50:12.595Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("294096","new_admin_email","k.yee@neu.edu","yes");
INSERT INTO `wp_options` VALUES ("1446615","_transient_timeout_e829499782a85223a1771e9381899a2b","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446616","_transient_e829499782a85223a1771e9381899a2b","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0445760b\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0445762w?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0445760b\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0445760b\").hide();
  jwplayer(\"drs-item-video-neu-m0445760b\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0445762w?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0445760b/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0445760b/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0445760b\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0445760b video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0445762w?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0445760b\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0445760b\").show();
    $(\"#drs-item-video-neu-m0445760b\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0445760b\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0445760b\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0445760b\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0445760b\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0445760b\").play()
   })
  });</script><div class=\"hidden\">2019-04-05T14:01:02Z<br/>2019-07-09T13:17:52Z<br/>A<br/>CoreFile<br/>neu:m0445759k<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-04-05T16:01:36Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:m0445759k+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2019-07-09T13:17:51Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":704,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:m0445759k+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.16\",\"dsCreateDate\":\"2019-07-09T13:17:52Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1320,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:m0445759k+DC+DC.16\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.3\",\"dsCreateDate\":\"2019-04-05T16:01:36Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":721,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:m0445759k+properties+properties.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.6\",\"dsCreateDate\":\"2019-07-09T13:17:52Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3578,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:m0445759k+mods+mods.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-04-05T14:01:02Z\",\"objLastModDate\":\"2019-07-09T13:17:52Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Am0445759k/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Am0445759k/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000127586<br/>000000000<br/>neu:f1881m124<br/>neu:f1881m124<br/>000000000<br/>000000000<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_1<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_2<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_3<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_4<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_5<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_1<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_2<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_3<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_4<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:f1881m124<br/>000000000<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_1<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_2<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_3<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_4<br/>/downloads/neu:m0445762w?datastream_id=thumbnail_5<br/>VideoFile<br/>LatinX Northeastern Community Center<br/>LatinX Northeastern Community Center<br/>LatinX Northeastern Community Center<br/>LatinX Northeastern Community Center<br/>A student story video detailing the contributions of the LatinX center to the Northeastern student body.<br/>2019-04-01<br/>2019-04-01<br/>LatinX<br/>Cultural Center<br/>Student Video<br/>LatinX<br/>Cultural Center<br/>Student Video<br/>104 Forsyth St, Boston, MA, 02115<br/>104 Forsyth St, Boston, MA, 02115<br/>http://hdl.handle.net/2047/D20310625<br/>http://hdl.handle.net/2047/D20310625<br/>LatinX<br/>Cultural Center<br/>Student Video<br/>LatinX Northeastern Community Center<br/>LatinX Northeastern Community Center<br/>latinx northeastern community center<br/>2019/04/01<br/>LatinX Northeastern Community Center<br/>2019-04-01<br/>LatinX<br/>Cultural Center<br/>Student Video<br/>104 Forsyth St, Boston, MA, 02115<br/>Geanacopoulos, Walter<br/>Cruz, Elisely<br/>Leake, Jackson<br/>Hilli, Nate<br/>Munoz (interviewee), Rebeca<br/>Geanacopoulos, Walter<br/>Cruz, Elisely<br/>Leake, Jackson<br/>Hilli, Nate<br/>Munoz (interviewee), Rebeca<br/>Geanacopoulos, Walter<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:f1881m124<br/>2019-07-09T13:17:58.516Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446617","_transient_timeout_6644c4df9efdb62d62c2eb21146a31e8","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446618","_transient_6644c4df9efdb62d62c2eb21146a31e8","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0447x592\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0447x613?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0447x592\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0447x592\").hide();
  jwplayer(\"drs-item-video-neu-m0447x592\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0447x613?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0447x592/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0447x592/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0447x592\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0447x592 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0447x613?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0447x592\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0447x592\").show();
    $(\"#drs-item-video-neu-m0447x592\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0447x592\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0447x592\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0447x592\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0447x592\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0447x592\").play()
   })
  });</script><div class=\"hidden\">2019-04-18T19:27:09Z<br/>2022-05-17T20:54:28Z<br/>A<br/>CoreFile<br/>neu:f1881s14q<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.2\",\"dsCreateDate\":\"2020-09-10T13:23:28Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881s14q+RELS-EXT+RELS-EXT.2\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2019-04-18T19:36:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":701,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881s14q+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.5\",\"dsCreateDate\":\"2022-05-17T20:54:29Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1167,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881s14q+DC+DC.5\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2020-09-10T13:23:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":700,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881s14q+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2022-05-17T20:54:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2302,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881s14q+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-04-18T19:27:09Z\",\"objLastModDate\":\"2022-05-17T20:54:28Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Af1881s14q/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Af1881s14q/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:loaders:spreadsheet<br/>northeastern:drs:repository:staff<br/>public<br/>001273100<br/>neu:gm80mp15d<br/>neu:gm80mp15d<br/>001273100<br/>001273100<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_1<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_2<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_3<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_4<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_5<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_1<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_2<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_3<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_4<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:gm80mp15d<br/>001273100<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_1<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_2<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_3<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_4<br/>/downloads/neu:m0447x613?datastream_id=thumbnail_5<br/>VideoFile<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>The Chicken Slacks perform some Motown and funk for their Valentine\'s Day<br/>2019-02-14<br/>2019-02-14<br/>738 Massachusetts Ave., Cambridge, MA, 02139<br/>738 Massachusetts Ave., Cambridge, MA, 02139<br/>funk<br/>music<br/>cambridge<br/>communities<br/>funk<br/>music<br/>cambridge<br/>communities<br/>http://hdl.handle.net/2047/D20313555<br/>http://hdl.handle.net/2047/D20313555<br/>funk<br/>music<br/>cambridge<br/>communities<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>video of the chicken slacks performing motown and funk<br/>2019/02/14<br/>Video of the Chicken Slacks Performing Motown and Funk<br/>2019-02-14<br/>738 Massachusetts Ave., Cambridge, MA, 02139<br/>funk<br/>music<br/>cambridge<br/>communities<br/>Amodie, Samantha<br/>Reavey, Mike<br/>Valedez, Jeremy<br/>Lusignea, Rick<br/>Jones, James<br/>Amodie, Samantha<br/>Reavey, Mike<br/>Valedez, Jeremy<br/>Lusignea, Rick<br/>Jones, James<br/>Amodie, Samantha<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:gm80mp15d<br/>2022-05-17T20:54:29.371Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1401217","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1663130968","no");
INSERT INTO `wp_options` VALUES ("1118433","akismet_comment_form_privacy_notice","hide","yes");
INSERT INTO `wp_options` VALUES ("705852","wf_plugin_act_error","","yes");
INSERT INTO `wp_options` VALUES ("710173","wordfence_syncAttackDataAttempts","0","no");
INSERT INTO `wp_options` VALUES ("710174","wordfence_syncingAttackData","0","no");
INSERT INTO `wp_options` VALUES ("710176","wordfence_lastSyncAttackData","1666862422","no");
INSERT INTO `wp_options` VALUES ("1446631","_transient_timeout_758c2237830cb36b6e51c2e56c3d51a4","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446632","_transient_758c2237830cb36b6e51c2e56c3d51a4","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0461673s\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0461675b?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0461673s\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0461673s\").hide();
  jwplayer(\"drs-item-video-neu-m0461673s\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0461675b?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0461673s/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0461673s/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0461673s\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0461673s video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0461675b?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0461673s\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0461673s\").show();
    $(\"#drs-item-video-neu-m0461673s\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0461673s\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0461673s\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0461673s\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0461673s\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0461673s\").play()
   })
  });</script><div class=\"hidden\">2020-05-04T17:44:13Z<br/>2020-05-04T18:13:52Z<br/>A<br/>CoreFile<br/>neu:gm80j941d<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2020-05-04T17:44:14Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j941d+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2020-05-04T18:13:51Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j941d+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2020-05-04T18:13:52Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1096,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j941d+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2020-05-04T17:47:28Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":711,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j941d+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2020-05-04T18:13:51Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2447,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j941d+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2020-05-04T17:44:13Z\",\"objLastModDate\":\"2020-05-04T18:13:52Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j941d/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j941d/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_1<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_2<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_3<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_4<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_5<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_1<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_2<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_3<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_4<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_1<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_2<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_3<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_4<br/>/downloads/neu:m0461675b?datastream_id=thumbnail_5<br/>AudioFile<br/>Almost Heaven<br/>Almost Heaven<br/>Almost Heaven<br/>Almost Heaven<br/>Recorded entirely by Zac Kerwin, Studio\'s part-time Engineer and former Studios Co-op in Fall 2018. This pop rock track has influences of Classic Rock bands such as The Byrds and Steely Dan.<br/>Northeastern University Library Recording Studio<br/>Northeastern University Library Recording Studio<br/>2019-09-14<br/>2019-09-14<br/>Pop Recording<br/>Easy Listening<br/>Pop Recording<br/>Easy Listening<br/>http://hdl.handle.net/2047/D20358966<br/>http://hdl.handle.net/2047/D20358966<br/>Pop Recording<br/>Easy Listening<br/>Almost Heaven<br/>Almost Heaven<br/>almost heaven<br/>2019/09/14<br/>Almost Heaven<br/>2019-09-14<br/>Pop Recording<br/>Kerwin, Zac<br/>Kerwin, Zac<br/>Northeastern University Library Recording Studio<br/>Kerwin, Zac<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2020-05-04T18:13:57.633Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("117119","ossdl_off_blog_url","http://recordingstudios.library.northeastern.edu","yes");
INSERT INTO `wp_options` VALUES ("140138","drstk_search_placeholder","Search ...","yes");
INSERT INTO `wp_options` VALUES ("1435345","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:12:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.3-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.9.5.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.9.5-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.9.5-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.9.5\";s:7:\"version\";s:5:\"5.9.5\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:3;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.6.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.6.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.6-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.6-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.8.6\";s:7:\"version\";s:5:\"5.8.6\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:4;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.7.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.7.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.7.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.7.8\";s:7:\"version\";s:5:\"5.7.8\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:5;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.6.10.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.6.10.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.6.10-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.6.10-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.6.10\";s:7:\"version\";s:6:\"5.6.10\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:6;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.5.11.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.5.11.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.5.11-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.5.11-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.5.11\";s:7:\"version\";s:6:\"5.5.11\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:7;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.4.12.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.4.12.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.4.12-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.4.12-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.4.12\";s:7:\"version\";s:6:\"5.4.12\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:8;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.3.14.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.3.14.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.3.14-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.3.14-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.3.14\";s:7:\"version\";s:6:\"5.3.14\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:9;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.2.17.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.2.17.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.2.17-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.2.17-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.2.17\";s:7:\"version\";s:6:\"5.2.17\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:10;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.15.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.1.15.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.1.15-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.1.15-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.1.15\";s:7:\"version\";s:6:\"5.1.15\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}i:11;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.0.18.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:60:\"https://downloads.wordpress.org/release/wordpress-5.0.18.zip\";s:10:\"no_content\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.0.18-no-content.zip\";s:11:\"new_bundled\";s:72:\"https://downloads.wordpress.org/release/wordpress-5.0.18-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:6:\"5.0.18\";s:7:\"version\";s:6:\"5.0.18\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1667036648;s:15:\"version_checked\";s:6:\"4.9.22\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO `wp_options` VALUES ("1445731","_transient_timeout_b7fe1719a3f04aaf154bc2f0834391dc","1667017164","no");
INSERT INTO `wp_options` VALUES ("1445732","_transient_b7fe1719a3f04aaf154bc2f0834391dc","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m040gh643\" src=\"https://repository.library.northeastern.edu/downloads/neu:m040gh66n?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m040gh643\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m040gh643\").hide();
  jwplayer(\"drs-item-video-neu-m040gh643\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m040gh66n?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m040gh643/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m040gh643/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m040gh643\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m040gh643 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m040gh66n?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m040gh643\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m040gh643\").show();
    $(\"#drs-item-video-neu-m040gh643\").hide();
  }
  jwplayer(\"drs-item-video-neu-m040gh643\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m040gh643\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m040gh643\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m040gh643\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m040gh643\").play()
   })
  });</script><div class=\"hidden\">2016-09-09T19:59:26Z<br/>2016-09-09T20:00:51Z<br/>A<br/>CoreFile<br/>neu:cj82nh78v<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2016-09-09T19:59:28Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82nh78v+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2016-09-09T20:00:27Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":639,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82nh78v+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2016-09-09T20:00:26Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":582,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82nh78v+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2018-12-21T16:09:05Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":780,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82nh78v+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2016-09-09T20:00:26Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":1751,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82nh78v+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":\"neu_m039xn606_new.mov\",\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2016-09-09T19:59:26Z\",\"objLastModDate\":\"2016-09-09T20:00:51Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82nh78v/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82nh78v/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>001670214<br/>001670214<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_1<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_2<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_3<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_4<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_5<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_1<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_2<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_3<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_4<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>001670214<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_1<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_2<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_3<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_4<br/>/downloads/neu:m040gh66n?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>Bee Charmer (new)<br/>Bee Charmer (new)<br/>Bee Charmer (new)<br/>Bee Charmer (new)<br/>The<br/>The<br/>DMC<br/>DMC<br/>http://hdl.handle.net/2047/D20215126<br/>http://hdl.handle.net/2047/D20215126<br/>DMC<br/>The<br/>Bee Charmer (new)<br/>The Bee Charmer (new)<br/>bee charmer new<br/>The<br/>The Bee Charmer (new)<br/>DMC<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2018-12-21T16:09:06.216Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446629","_transient_timeout_8040d619219797b5afe24a9f47976f64","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446627","_transient_timeout_e950143f8e9987b6a3e6d6f35659bc4b","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446628","_transient_e950143f8e9987b6a3e6d6f35659bc4b","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044g841w\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044g843f?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044g841w\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044g841w\").hide();
  jwplayer(\"drs-item-video-neu-m044g841w\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044g843f?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g841w/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g841w/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044g841w\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044g841w video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044g843f?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044g841w\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044g841w\").show();
    $(\"#drs-item-video-neu-m044g841w\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044g841w\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g841w\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g841w\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044g841w\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044g841w\").play()
   })
  });</script><div class=\"hidden\">2019-07-08T19:09:23Z<br/>2019-07-08T19:12:42Z<br/>A<br/>CoreFile<br/>neu:f1881z258<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-07-08T19:09:24Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z258+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.3\",\"dsCreateDate\":\"2019-07-08T19:12:42Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z258+rightsMetadata+rightsMetadata.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.6\",\"dsCreateDate\":\"2019-07-08T19:12:42Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1282,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z258+DC+DC.6\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2019-07-08T19:11:32Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":755,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z258+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.3\",\"dsCreateDate\":\"2019-07-08T19:12:42Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2643,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z258+mods+mods.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-07-08T19:09:23Z\",\"objLastModDate\":\"2019-07-08T19:12:42Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z258/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z258/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_1<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_2<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_3<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_4<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_5<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_1<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_2<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_3<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_4<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_1<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_2<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_3<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_4<br/>/downloads/neu:m044g843f?datastream_id=thumbnail_5<br/>AudioFile<br/>Why can\'t people just say what they need to say<br/>Why can\'t people just say what they need to say<br/>Why can\'t people just say what they need to say<br/>Why can\'t people just say what they need to say<br/>Written, Produced, and Mixed By: Chelsey Meyer Mastering: Dante Marino Track Art: Sasha Avilov Drums: Ben DeUrso Bass: Seth Queeney Guitar: Jack FU Back-up Vocals: Jack Beresford, Justine Cowan, Noah DeMoss, Jack Halliwell, Brittany Joline, Jason Levy, Raquel Massoud, Carolyn Noyes, Mark Velino Drums recorded at Snell Library Studios<br/>2019-04-05<br/>2019-04-05<br/>POP<br/>indie<br/>indie pop<br/>Boston<br/>POP<br/>indie<br/>indie pop<br/>Boston<br/>http://hdl.handle.net/2047/D20318896<br/>http://hdl.handle.net/2047/D20318896<br/>POP<br/>indie<br/>indie pop<br/>Boston<br/>Why can\'t people just say what they need to say<br/>Why can\'t people just say what they need to say<br/>why cant people just say what they need to say<br/>2019/04/05<br/>Why can\'t people just say what they need to say<br/>2019-04-05<br/>POP<br/>Meyer, Chelsey<br/>Meyer, Chelsey<br/>Meyer, Chelsey<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2019-07-08T19:12:48.809Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1401433","_transient_quest_categories","0","yes");
INSERT INTO `wp_options` VALUES ("1445734","_transient_timeout_3caa59cf77dd510b8cf06a2dd568dc55","1667017167","no");
INSERT INTO `wp_options` VALUES ("1445735","_transient_3caa59cf77dd510b8cf06a2dd568dc55","<div class=\'freewall\' id=\'freewall\' data-type=\'pinterest-hover\' data-cell-height=\'200\' data-cell-width=\'200\' data-text-align=\'left\'><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:m043nj58f?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82sz05q\'>Circa<br/>Midnight Channel<br/></a><div class=\"hidden\">2018-12-18T14:42:14Z<br/>2018-12-19T16:20:00Z<br/>A<br/>CoreFile<br/>neu:cj82sz05q<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000127586<br/>neu:rx9181539<br/>neu:rx9181539<br/>000127586<br/>000127586<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_1<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_2<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_3<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_4<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_5<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_1<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_2<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_3<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_4<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000127586<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_1<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_2<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_3<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_4<br/>/downloads/neu:m043nj58f?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Circa<br/>Circa<br/>Circa<br/>Circa<br/>Not so often a band comes around with the quirky, energetic heartfelt undertones of Midnight Channel, while still maintaining their edgy rock focus. Every one of the instruments on their EP is played by the two members: the reserved Ringo-esque front man Liam Numrich, or the perfect counter balance drummer/bassist, Gabriel Pino. Formed from the ashes of local sensation, The Blinds, Midnight Channel have never been so energized or well prepared to deliver chills down your spine. The EP was recorded and mixed by Zac Kerwin, giving the band that final polish and clarity, that only scratches the surface of their potential, and at the sam time, realizes it.<br/>Midnight Channel<br/>Midnight Channel<br/>2018-12-14<br/>2018-12-14<br/>Rock<br/>Rock<br/>http://hdl.handle.net/2047/D20296753<br/>http://hdl.handle.net/2047/D20296753<br/>Rock<br/>Circa<br/>Circa<br/>circa<br/>2018/12/14<br/>Circa<br/>2018-12-14<br/>Rock<br/>Midnight Channel<br/>Midnight Channel<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:11.837Z<br/></div></div></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445736","_transient_timeout_172aabcb17038c776d7f54b880c843bc","1667017167","no");
INSERT INTO `wp_options` VALUES ("1445737","_transient_172aabcb17038c776d7f54b880c843bc","<div class=\'freewall\' id=\'freewall\' data-type=\'even-row\' data-cell-height=\'200\' data-cell-width=\'200\' data-text-align=\'left\'><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m042gd138?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r264b\'>Mouthful<br/>Temper, Gentle<br/>Northeastern University <br/></a><div class=\"hidden\">2018-02-15T19:44:38Z<br/>2018-02-15T19:46:16Z<br/>A<br/>CoreFile<br/>neu:cj82r264b<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_5<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd138?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Mouthful<br/>Mouthful<br/>Mouthful<br/>Mouthful<br/>Gentle Temper is Ryan Meier and Marion Earley, an ocean-folk duo with a blues tide from the bayous of Boston, MA. Marion and Ryan met while attending college in Boston and began writing and playing together in their final year. Their live sound builds on a sturdy foundation of lyrical storytelling &amp; animated harmonies.<br/>Northeastern University <br/>Northeastern University <br/>2018-01<br/>2018-01<br/>Music<br/>Gentle Temper<br/>Music<br/>Gentle Temper<br/>http://hdl.handle.net/2047/D20268999<br/>http://hdl.handle.net/2047/D20268999<br/>Music<br/>Gentle Temper<br/>Mouthful<br/>Mouthful<br/>mouthful<br/>2018/01/01<br/>Mouthful<br/>2018-01<br/>Music<br/>Temper, Gentle<br/>Temper, Gentle<br/>Northeastern University <br/>Temper, Gentle<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:26.456Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m042gd10f?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r2632\'>Sunny<br/>Temper, Gentle<br/>Northeastern University<br/></a><div class=\"hidden\">2018-02-15T19:42:08Z<br/>2018-02-16T14:19:26Z<br/>A<br/>CoreFile<br/>neu:cj82r2632<br/>northeastern:drs:repository:staff<br/>public<br/>northeastern:drs:all<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_5<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd10f?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Sunny<br/>Sunny<br/>Sunny<br/>Sunny<br/>Gentle Temper is Ryan Meier and Marion Earley, an ocean-folk duo with a blues tide from the bayous of Boston, MA. Marion and Ryan met while attending college in Boston and began writing and playing together in their final year. Their live sound builds on a sturdy foundation of lyrical storytelling &amp; animated harmonies<br/>Northeastern University<br/>Northeastern University<br/>2018-01<br/>2018-01<br/>Music<br/>Gentle Temper<br/>Ocean<br/>Music<br/>Gentle Temper<br/>Ocean<br/>http://hdl.handle.net/2047/D20268998<br/>http://hdl.handle.net/2047/D20268998<br/>Music<br/>Gentle Temper<br/>Ocean<br/>Sunny<br/>Sunny<br/>sunny<br/>2018/01/01<br/>Sunny<br/>2018-01<br/>Music<br/>Temper, Gentle<br/>Temper, Gentle<br/>Northeastern University<br/>Temper, Gentle<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:31.924Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m042gd163?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r265m\'>Heavy<br/>Temper, Gentle<br/>Northeastern University <br/></a><div class=\"hidden\">2018-02-15T19:46:59Z<br/>2018-02-15T19:51:31Z<br/>A<br/>CoreFile<br/>neu:cj82r265m<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_5<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_1<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_2<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_3<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_4<br/>/downloads/neu:m042gd163?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Heavy<br/>Heavy<br/>Heavy<br/>Heavy<br/>Gentle Temper is Ryan Meier and Marion Earley, an ocean-folk duo with a blues tide from the bayous of Boston, MA. Marion and Ryan met while attending college in Boston and began writing and playing together in their final year. Their live sound builds on a sturdy foundation of lyrical storytelling &amp; animated harmonies.<br/>Northeastern University <br/>Northeastern University <br/>2018-01<br/>2018-01<br/>Music<br/>Gentle Temper<br/>Ocean<br/>Music<br/>Gentle Temper<br/>Ocean<br/>http://hdl.handle.net/2047/D20269000<br/>http://hdl.handle.net/2047/D20269000<br/>Music<br/>Gentle Temper<br/>Ocean<br/>Heavy<br/>Heavy<br/>heavy<br/>2018/01/01<br/>Heavy<br/>2018-01<br/>Music<br/>Temper, Gentle<br/>Temper, Gentle<br/>Northeastern University <br/>Temper, Gentle<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:19.287Z<br/></div></div></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445738","_transient_timeout_b8df16816d495a4540c9eda06ef2a210","1667017168","no");
INSERT INTO `wp_options` VALUES ("1445739","_transient_b8df16816d495a4540c9eda06ef2a210","<div class=\'freewall\' id=\'freewall\' data-type=\'even-row\' data-cell-height=\'200\' data-cell-width=\'200\' data-text-align=\'left\'><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:cj82kv957?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx918154k\'>Blessing and a Curse<br/>Knoll, Andrew<br/></a><div class=\"hidden\">2015-11-17T20:37:10Z<br/>2020-09-01T02:09:59Z<br/>A<br/>CoreFile<br/>neu:rx918154k<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_5<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv957?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Blessing and a Curse<br/>Blessing and a Curse<br/>Blessing and a Curse<br/>Blessing and a Curse<br/>Punchy, electrorock with sexy, poetic lyrics, apathetic vocals, heavy distortion and synthetic drums<br/>2015-07-06<br/>2015-07-06<br/>Music<br/>Electrorock<br/>Snell Studios<br/>Rock<br/>Music<br/>Electrorock<br/>Snell Studios<br/>Rock<br/>http://hdl.handle.net/2047/D20198909<br/>http://hdl.handle.net/2047/D20198909<br/>Music<br/>Electrorock<br/>Snell Studios<br/>Rock<br/>Blessing and a Curse<br/>Blessing and a Curse<br/>blessing and a curse<br/>2015/07/06<br/>Blessing and a Curse<br/>2015-07-06<br/>Music<br/>Electrorock<br/>Snell Studios<br/>Rock<br/>Knoll, Andrew<br/>Knoll, Andrew<br/>Knoll, Andrew<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-01T02:10:01.457Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:cj82n0324?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx9183647\'>Mulher Gaucha<br/>Rosa, Bruno<br/>Northeastern University<br/></a><div class=\"hidden\">2015-12-01T18:42:35Z<br/>2020-09-05T02:13:36Z<br/>A<br/>CoreFile<br/>neu:rx9183647<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_1<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_2<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_3<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_4<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_5<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_1<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_2<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_3<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_4<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_1<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_2<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_3<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_4<br/>/downloads/neu:cj82n0324?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Mulher Gaucha<br/>Mulher Gaucha<br/>Mulher Gaucha<br/>Mulher Gaucha<br/>Northeastern University<br/>Northeastern University<br/>2015-03-10<br/>2015-03-10<br/>Brazilian Rock<br/>Brazil<br/>Rock<br/>Brazilian Rock<br/>Brazil<br/>Rock<br/>http://hdl.handle.net/2047/D20199241<br/>http://hdl.handle.net/2047/D20199241<br/>Brazilian Rock<br/>Brazil<br/>Rock<br/>Mulher Gaucha<br/>Mulher Gaucha<br/>mulher gaucha<br/>2015/03/10<br/>Mulher Gaucha<br/>2015-03-10<br/>Brazilian Rock<br/>Brazil<br/>Rock<br/>Rosa, Bruno<br/>Rosa, Bruno<br/>Northeastern University<br/>Rosa, Bruno<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-05T02:13:38.388Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m039rw51t?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx918366s\'>Track 1<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/></a><div class=\"hidden\">2015-12-01T19:06:17Z<br/>2020-09-11T01:12:19Z<br/>A<br/>CoreFile<br/>neu:rx918366s<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_5<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw51t?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Track 1<br/>Track 1<br/>Track 1<br/>Track 1<br/>Sayeh is an Iranian music ensemble that started in Boston in 2010. The members of the group are all Iranian professionals that are passionate about music and have dedicated parts of their time to creating and performing Persian music. The ensemble has performed at various venues since its establishment. The group aims to explore novel avenues and to this end its focus is to compose, harmonize and perform original songs with a fresh perspective on traditional Persian music.<br/>Northeastern University<br/>Northeastern University<br/>2015-11-24<br/>2015-11-24<br/>Persian<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>PouyaPouya<br/>Persian<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>PouyaPouya<br/>http://hdl.handle.net/2047/D20199243<br/>http://hdl.handle.net/2047/D20199243<br/>Persian<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>PouyaPouya<br/>Track 1<br/>Track 1<br/>track 000001<br/>2015/11/24<br/>Track 1<br/>2015-11-24<br/>Persian<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>PouyaPouya<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/>Tabkhi, Hamed<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-11T01:12:21.542Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m039rw33w?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx918359c\'>Track 2<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shabanpour, Pouya<br/>Northeastern University<br/></a><div class=\"hidden\">2015-12-01T18:23:00Z<br/>2020-09-03T18:43:31Z<br/>A<br/>CoreFile<br/>neu:rx918359c<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_5<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw33w?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Track 2<br/>Track 2<br/>Track 2<br/>Track 2<br/>Sayeh is an Iranian music ensemble that was formed in Boston in 2010. The members of the group are all Iranian professionals that are passionate about music and have dedicated parts of their time to creating and performing Persian music. The ensemble has performed at various events. The group aims to explore novel avenues and to this end its focus is to compose, harmonize and perform original songs with a fresh perspective on traditional Persian music.<br/>Northeastern University<br/>Northeastern University<br/>2015-06-30<br/>2015-06-30<br/>Matineh Shaker<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Pouya Shabanpour<br/>Matineh Shaker<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Pouya Shabanpour<br/>http://hdl.handle.net/2047/D20199236<br/>http://hdl.handle.net/2047/D20199236<br/>Matineh Shaker<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Pouya Shabanpour<br/>Track 2<br/>Track 2<br/>track 000002<br/>2015/06/30<br/>Track 2<br/>2015-06-30<br/>Matineh Shaker<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Pouya Shabanpour<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shabanpour, Pouya<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shabanpour, Pouya<br/>Northeastern University<br/>Tabkhi, Hamed<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-03T19:10:26.806Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m039rw36q?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx9183604\'></a><div class=\"hidden\">2015-12-01T18:28:13Z<br/>2020-09-04T19:22:39Z<br/>A<br/>CoreFile<br/>neu:rx9183604<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_5<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw36q?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-04T19:44:28.457Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m039rw39j?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx918361d\'>Track 4<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/></a><div class=\"hidden\">2015-12-01T18:31:29Z<br/>2020-09-01T02:10:16Z<br/>A<br/>CoreFile<br/>neu:rx918361d<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_5<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw39j?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Track 4<br/>Track 4<br/>Track 4<br/>Track 4<br/>Sayeh is an Iranian music ensemble that started in Boston in 2010. The members of the group are all Iranian professionals that are passionate about music and have dedicated parts of their time to creating and performing Persian music. The ensemble has performed at various venues since its establishment. The group aims to explore novel avenues and to this end its focus is to compose, harmonize and perform original songs with a fresh perspective on traditional Persian music.<br/>Northeastern University<br/>Northeastern University<br/>2015-06-30<br/>2015-06-30<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>http://hdl.handle.net/2047/D20199238<br/>http://hdl.handle.net/2047/D20199238<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Track 4<br/>Track 4<br/>track 000004<br/>2015/06/30<br/>Track 4<br/>2015-06-30<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/>Tabkhi, Hamed<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-01T02:10:18.321Z<br/></div></div></div><div class=\'cell\' data-thumbnail=\'https://repository.library.northeastern.edu/downloads/neu:m039rw42v?datastream_id=thumbnail_4\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:rx918362p\'>Track 5<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/></a><div class=\"hidden\">2015-12-01T18:33:25Z<br/>2020-09-11T16:20:57Z<br/>A<br/>CoreFile<br/>neu:rx918362p<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_5<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_1<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_2<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_3<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_4<br/>/downloads/neu:m039rw42v?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Track 5<br/>Track 5<br/>Track 5<br/>Track 5<br/>Sayeh is an Iranian music ensemble that started in Boston in 2010. The members of the group are all Iranian professionals that are passionate about music and have dedicated parts of their time to creating and performing Persian music. The ensemble has performed at various venues since its establishment. The group aims to explore novel avenues and to this end its focus is to compose, harmonize and perform original songs with a fresh perspective on traditional Persian music.<br/>Northeastern University<br/>Northeastern University<br/>2015-06-30<br/>2015-06-30<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>http://hdl.handle.net/2047/D20199239<br/>http://hdl.handle.net/2047/D20199239<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Track 5<br/>Track 5<br/>track 000005<br/>2015/06/30<br/>Track 5<br/>2015-06-30<br/>Persian Music<br/>Hamed Tabkhi<br/>Maryam Vaziri Pashkam<br/>Matineh Shaker<br/>Pouya Shabanpour<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Tabkhi, Hamed<br/>Vaziri Pashkam, Maryam<br/>Shaker, Matineh<br/>Shabanpour, Pouya<br/>Northeastern University<br/>Tabkhi, Hamed<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2020-09-11T16:20:59.229Z<br/></div></div></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446623","_transient_timeout_6cb1980fceccb0cb0b380a02cf899645","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446624","_transient_6cb1980fceccb0cb0b380a02cf899645","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m046rk59v\" src=\"https://repository.library.northeastern.edu/downloads/neu:m046rk61w?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m046rk59v\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m046rk59v\").hide();
  jwplayer(\"drs-item-video-neu-m046rk59v\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m046rk61w?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m046rk59v/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m046rk59v/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m046rk59v\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m046rk59v video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m046rk61w?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m046rk59v\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m046rk59v\").show();
    $(\"#drs-item-video-neu-m046rk59v\").hide();
  }
  jwplayer(\"drs-item-video-neu-m046rk59v\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m046rk59v\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m046rk59v\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m046rk59v\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m046rk59v\").play()
   })
  });</script><div class=\"hidden\">2020-08-20T15:16:02Z<br/>2020-08-20T15:22:55Z<br/>A<br/>CoreFile<br/>neu:gm80mn067<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2020-08-20T15:16:07Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mn067+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2020-08-20T15:20:13Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mn067+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2020-08-20T15:20:12Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1106,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mn067+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2020-08-20T15:22:55Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":720,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mn067+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2020-08-20T15:20:12Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2638,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80mn067+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2020-08-20T15:16:02Z\",\"objLastModDate\":\"2020-08-20T15:22:55Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Agm80mn067/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Agm80mn067/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:staff<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_1<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_2<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_3<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_4<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_5<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_1<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_2<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_3<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_4<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_1<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_2<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_3<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_4<br/>/downloads/neu:m046rk61w?datastream_id=thumbnail_5<br/>AudioFile<br/>Remote beat collaboration 7-23<br/>Remote beat collaboration 7-23<br/>Remote beat collaboration 7-23<br/>Remote beat collaboration 7-23<br/>The remote beat collaboration is a snippet that Craig Short (Studios Co-op, Spring 2020) made with friends using a system with Zoom and AudioMovers where musicians swapped samples and assigned one musician to \"assemble\" them on screen in their DAW. This is one example of how to remotely collaborate.<br/>Northeastern University Library Recording Studio<br/>Northeastern University Library Recording Studio<br/>2020-07-23<br/>2020-07-23<br/>Beat making<br/>Audio<br/>Remote Collaboration<br/>Beat making<br/>Audio<br/>Remote Collaboration<br/>http://hdl.handle.net/2047/D20383758<br/>http://hdl.handle.net/2047/D20383758<br/>Beat making<br/>Audio<br/>Remote Collaboration<br/>Remote beat collaboration 7-23<br/>Remote beat collaboration 7-23<br/>remote beat collaboration 000723<br/>2020/07/23<br/>Remote beat collaboration 7-23<br/>2020-07-23<br/>Beat making<br/>Short, Craig<br/>Short, Craig<br/>Northeastern University Library Recording Studio<br/>Short, Craig<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2020-08-20T15:22:57.347Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445721","_transient_timeout_f0a5b180265da3d1050db92c87498da1","1667017157","no");
INSERT INTO `wp_options` VALUES ("1445722","_transient_f0a5b180265da3d1050db92c87498da1","<div class=\'freewall\' id=\'freewall\' data-type=\'pinterest-hover\' data-cell-height=\'200\' data-cell-width=\'200\' data-text-align=\'left\'><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:m0432q934?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r939f\'>Nina Chase<br/>Brown, Nick<br/>Northeastern University<br/></a><div class=\"hidden\">2018-05-16T16:01:50Z<br/>2018-05-16T16:04:15Z<br/>A<br/>CoreFile<br/>neu:cj82r939f<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_5<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q934?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Nina Chase<br/>Nina Chase<br/>Nina Chase<br/>Nina Chase<br/>Students created podcasts of landscape artists.<br/>Northeastern University<br/>Northeastern University<br/>Podcast<br/>Nina Chase<br/>Landscape<br/>Podcast<br/>Nina Chase<br/>Landscape<br/>http://hdl.handle.net/2047/D20283837<br/>http://hdl.handle.net/2047/D20283837<br/>Podcast<br/>Nina Chase<br/>Landscape<br/>Nina Chase<br/>Nina Chase<br/>nina chase<br/>Nina Chase<br/>Podcast<br/>Brown, Nick<br/>Brown, Nick<br/>Northeastern University<br/>Brown, Nick<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:30.038Z<br/></div></div></div><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:m0432q96z?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r9406\'>Gina Ford<br/>Brown, Nick<br/>Northeastern University<br/></a><div class=\"hidden\">2018-05-16T16:04:26Z<br/>2018-05-16T16:06:14Z<br/>A<br/>CoreFile<br/>neu:cj82r9406<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_5<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q96z?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Gina Ford<br/>Gina Ford<br/>Gina Ford<br/>Gina Ford<br/>Students created a podcast of a landscape artist.<br/>Northeastern University<br/>Northeastern University<br/>Podcast<br/>Gina Ford<br/>Landscape<br/>Podcast<br/>Gina Ford<br/>Landscape<br/>http://hdl.handle.net/2047/D20283838<br/>http://hdl.handle.net/2047/D20283838<br/>Podcast<br/>Gina Ford<br/>Landscape<br/>Gina Ford<br/>Gina Ford<br/>gina ford<br/>Gina Ford<br/>Podcast<br/>Brown, Nick<br/>Brown, Nick<br/>Northeastern University<br/>Brown, Nick<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:17.305Z<br/></div></div></div><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:m0432q99s?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82r941g\'>Blaine Merker<br/>Brown, Nick<br/>Northeastern University<br/></a><div class=\"hidden\">2018-05-16T16:06:40Z<br/>2018-05-16T16:08:03Z<br/>A<br/>CoreFile<br/>neu:cj82r941g<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9181539<br/>neu:rx9181539<br/>000446743<br/>000446743<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_5<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>true<br/>true<br/>neu:rx9181539<br/>000446743<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_1<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_2<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_3<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_4<br/>/downloads/neu:m0432q99s?datastream_id=thumbnail_5<br/>AudioFile<br/>true<br/>Blaine Merker<br/>Blaine Merker<br/>Blaine Merker<br/>Blaine Merker<br/>Students created a podcast of a landscape artist.<br/>Northeastern University<br/>Northeastern University<br/>podcast<br/>Blaine Merker<br/>Landscape<br/>podcast<br/>Blaine Merker<br/>Landscape<br/>http://hdl.handle.net/2047/D20283839<br/>http://hdl.handle.net/2047/D20283839<br/>podcast<br/>Blaine Merker<br/>Landscape<br/>Blaine Merker<br/>Blaine Merker<br/>blaine merker<br/>Blaine Merker<br/>podcast<br/>Brown, Nick<br/>Brown, Nick<br/>Northeastern University<br/>Brown, Nick<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9181539<br/>2018-12-21T16:09:08.234Z<br/></div></div></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445723","_transient_timeout_5975827b691e8337a542919085f54086","1667017158","no");
INSERT INTO `wp_options` VALUES ("1446611","_transient_timeout_f1328083522e9b7a66bc10a376dd3ff1","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446612","_transient_f1328083522e9b7a66bc10a376dd3ff1","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044v727r\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044v7299?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044v727r\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044v727r\").hide();
  jwplayer(\"drs-item-video-neu-m044v727r\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044v7299?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044v727r/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044v727r/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044v727r\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044v727r video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044v7299?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044v727r\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044v727r\").show();
    $(\"#drs-item-video-neu-m044v727r\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044v727r\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044v727r\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044v727r\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044v727r\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044v727r\").play()
   })
  });</script><div class=\"hidden\">2019-11-26T15:55:40Z<br/>2019-12-05T19:20:39Z<br/>A<br/>CoreFile<br/>neu:f1882381m<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-11-26T15:55:41Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1882381m+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.5\",\"dsCreateDate\":\"2019-12-05T19:20:38Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1882381m+rightsMetadata+rightsMetadata.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.12\",\"dsCreateDate\":\"2019-12-05T19:20:39Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1673,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1882381m+DC+DC.12\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.5\",\"dsCreateDate\":\"2019-11-26T15:57:37Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":749,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1882381m+properties+properties.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.5\",\"dsCreateDate\":\"2019-12-05T19:20:38Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3154,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1882381m+mods+mods.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-11-26T15:55:40Z\",\"objLastModDate\":\"2019-12-05T19:20:39Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1882381m/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1882381m/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>001126975<br/>001126975<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_1<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_2<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_3<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_4<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_5<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_1<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_2<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_3<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_4<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:rx9189661<br/>000446743<br/>001126975<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_1<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_2<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_3<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_4<br/>/downloads/neu:m044v7299?datastream_id=thumbnail_5<br/>VideoFile<br/>Songs of Love<br/>Songs of Love<br/>Songs of Love<br/>Songs of Love<br/>Petrina Danardatu sings original and classic \"Songs of Love\" in the Library\'s Recording Studio. The performance was also streamed on the Library Facebook page. Petrina is a first-year student at Northeastern with a combined major in Journalism and English. Her family is Indonesian and Slovakian. Though Petrina has lived in seven countries including Indonesia, Canada, Libya, Saudi Arabia Denmark and Scotland, English is her first language. Video editing by Antonio Banrey and audio Editing by Jon Reed.<br/>Northeastern University Library Recording Studio<br/>Northeastern University Library Recording Studio<br/>2019-11-21<br/>2019-11-21<br/>live stream<br/>Daniel Johnston<br/>Sam Cooke<br/>Lana Del Ray<br/>Recording Studio<br/>Music<br/>Singer Songwriter<br/>Guitar<br/>live stream<br/>Daniel Johnston<br/>Sam Cooke<br/>Lana Del Ray<br/>Recording Studio<br/>Music<br/>Singer Songwriter<br/>Guitar<br/>http://hdl.handle.net/2047/D20327476<br/>http://hdl.handle.net/2047/D20327476<br/>live stream<br/>Daniel Johnston<br/>Sam Cooke<br/>Lana Del Ray<br/>Recording Studio<br/>Music<br/>Singer Songwriter<br/>Guitar<br/>Songs of Love<br/>Songs of Love<br/>songs of love<br/>2019/11/21<br/>Songs of Love<br/>2019-11-21<br/>live stream<br/>Danardatu, Petrina<br/>Danardatu, Petrina<br/>Northeastern University Library Recording Studio<br/>Danardatu, Petrina<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2019-12-05T19:20:45.747Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446609","_transient_timeout_4002a045d2ecd8fd0346d47baf6f65fa","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446610","_transient_4002a045d2ecd8fd0346d47baf6f65fa","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m045sj33j\" src=\"https://repository.library.northeastern.edu/downloads/neu:m045sj36c?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m045sj33j\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m045sj33j\").hide();
  jwplayer(\"drs-item-video-neu-m045sj33j\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m045sj36c?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m045sj33j/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m045sj33j/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m045sj33j\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m045sj33j video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m045sj36c?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m045sj33j\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m045sj33j\").show();
    $(\"#drs-item-video-neu-m045sj33j\").hide();
  }
  jwplayer(\"drs-item-video-neu-m045sj33j\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m045sj33j\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m045sj33j\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m045sj33j\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m045sj33j\").play()
   })
  });</script><div class=\"hidden\">2020-04-15T17:58:13Z<br/>2020-04-29T19:07:58Z<br/>A<br/>CoreFile<br/>neu:gm80j408b<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2020-04-15T17:58:14Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j408b+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2020-04-29T19:07:57Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":752,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j408b+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2020-04-29T19:07:58Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":961,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j408b+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.5\",\"dsCreateDate\":\"2020-04-15T18:05:00Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":764,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j408b+properties+properties.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2020-04-29T19:07:57Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2321,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:gm80j408b+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2020-04-15T17:58:13Z\",\"objLastModDate\":\"2020-04-29T19:07:58Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j408b/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Agm80j408b/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>northeastern:drs:repository:loaders:spreadsheet<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>001126975<br/>001126975<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_1<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_2<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_3<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_4<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_5<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_1<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_2<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_3<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_4<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:rx9189661<br/>000446743<br/>001126975<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_1<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_2<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_3<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_4<br/>/downloads/neu:m045sj36c?datastream_id=thumbnail_5<br/>VideoFile<br/>Emerald Session: Red Shaydez<br/>Emerald Session: Red Shaydez<br/>Emerald Session: Red Shaydez<br/>Emerald Session: Red Shaydez<br/>Northeastern University Library<br/>Green Line Records<br/>Northeastern University Library<br/>Green Line Records<br/>2020-03-12<br/>2020-03-12<br/>studio session<br/>Hip Hop<br/>studio session<br/>Hip Hop<br/>http://hdl.handle.net/2047/D20352223<br/>http://hdl.handle.net/2047/D20352223<br/>studio session<br/>Hip Hop<br/>Emerald Session: Red Shaydez<br/>Emerald Session: Red Shaydez<br/>emerald session red shaydez<br/>2020/03/12<br/>Emerald Session: Red Shaydez<br/>2020-03-12<br/>studio session<br/>Shaydez, Red<br/>Shaydez, Red<br/>Northeastern University Library<br/>Green Line Records<br/>Shaydez, Red<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2020-04-29T19:08:06.012Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446605","_transient_timeout_9b79ab2c52b42f631a60449ebb087358","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446606","_transient_9b79ab2c52b42f631a60449ebb087358","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0419f53f\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0419f550?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0419f53f\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0419f53f\").hide();
  jwplayer(\"drs-item-video-neu-m0419f53f\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0419f550?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f53f/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f53f/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0419f53f\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0419f53f video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0419f550?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0419f53f\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0419f53f\").show();
    $(\"#drs-item-video-neu-m0419f53f\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0419f53f\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f53f\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f53f\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0419f53f\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0419f53f\").play()
   })
  });</script><div class=\"hidden\">2017-05-18T15:46:39Z<br/>2017-05-18T15:53:24Z<br/>A<br/>CoreFile<br/>neu:cj82px093<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2017-05-18T15:46:41Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px093+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2017-05-18T15:52:42Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":639,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px093+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2017-05-18T15:52:41Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1168,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px093+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2018-12-21T16:09:24Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":737,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px093+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2017-05-18T15:52:41Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2728,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px093+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2017-05-18T15:46:39Z\",\"objLastModDate\":\"2017-05-18T15:53:24Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px093/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px093/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_5<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f550?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>Kaleidoscope<br/>Kaleidoscope<br/>Kaleidoscope<br/>Kaleidoscope<br/>Tirelle Barron who releases music under the moniker The Noise Above. Tirelle\'s style is an intellectual blend of lyricism and low-key funk and jazz-inspired beats which are complex yet accessible. His work is uniquely personal as he creates and produces all of his own beats and writes deeply introspective lyrics regarding personal experience, perspective, and growth through various struggles.<br/>Northeastern University<br/>Northeastern University<br/>Aidan Breen<br/>Camellia Chorsi<br/>Paula Crea<br/>The Noise Above<br/>Aidan Breen<br/>Camellia Chorsi<br/>Paula Crea<br/>The Noise Above<br/>http://hdl.handle.net/2047/D20241955<br/>http://hdl.handle.net/2047/D20241955<br/>Aidan Breen<br/>Camellia Chorsi<br/>Paula Crea<br/>The Noise Above<br/>Kaleidoscope<br/>Kaleidoscope<br/>kaleidoscope<br/>Kaleidoscope<br/>Aidan Breen<br/>Breen, Aidan<br/>Breen, Aidan<br/>Northeastern University<br/>Breen, Aidan<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2018-12-21T16:09:24.674Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445725","_transient_timeout_c6425b395f782ec038482fcfb6c77064","1667017158","no");
INSERT INTO `wp_options` VALUES ("1445726","_transient_c6425b395f782ec038482fcfb6c77064","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0419f568\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0419f58t?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0419f568\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0419f568\").hide();
  jwplayer(\"drs-item-video-neu-m0419f568\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0419f58t?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f568/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f568/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0419f568\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0419f568 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0419f58t?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0419f568\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0419f568\").show();
    $(\"#drs-item-video-neu-m0419f568\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0419f568\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f568\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f568\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0419f568\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0419f568\").play()
   })
  });</script><div class=\"hidden\">2017-05-18T16:15:38Z<br/>2017-05-18T16:18:40Z<br/>A<br/>CoreFile<br/>neu:cj82px10v<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2017-05-18T16:15:40Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px10v+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2017-05-18T16:18:04Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":639,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px10v+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2017-05-18T16:18:03Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1113,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px10v+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2018-12-21T16:09:15Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":726,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px10v+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2017-05-18T16:18:03Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2585,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px10v+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2017-05-18T16:15:38Z\",\"objLastModDate\":\"2017-05-18T16:18:40Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px10v/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px10v/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_5<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f58t?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>Flash Paper<br/>Flash Paper<br/>Flash Paper<br/>Flash Paper<br/>Build iT! is a Boston based punk band who love being sad, big beautiful penguins and sometimes writing banger tunes. It has been heavily rumored that this band does indeed play music, but there is still research to be done. There are currently four members of the band, but they are willing and open to add a third member<br/>Northeastern University<br/>Northeastern University<br/>Build it<br/>Andrew Ricci<br/>Matt Wikstrom<br/>Chris Miller<br/>Joseph Buza<br/>Build it<br/>Andrew Ricci<br/>Matt Wikstrom<br/>Chris Miller<br/>Joseph Buza<br/>http://hdl.handle.net/2047/D20241956<br/>http://hdl.handle.net/2047/D20241956<br/>Build it<br/>Andrew Ricci<br/>Matt Wikstrom<br/>Chris Miller<br/>Joseph Buza<br/>Flash Paper<br/>Flash Paper<br/>flash paper<br/>Flash Paper<br/>Build it<br/>Northeastern University<br/>Northeastern University<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2018-12-21T16:09:15.494Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445727","_transient_timeout_c5f6775b74c464749cdf38617ca5a343","1667017158","no");
INSERT INTO `wp_options` VALUES ("1445728","_transient_c5f6775b74c464749cdf38617ca5a343","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m0419f50m\" src=\"https://repository.library.northeastern.edu/downloads/neu:m0419f525?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m0419f50m\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m0419f50m\").hide();
  jwplayer(\"drs-item-video-neu-m0419f50m\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m0419f525?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f50m/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m0419f50m/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m0419f50m\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m0419f50m video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m0419f525?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m0419f50m\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m0419f50m\").show();
    $(\"#drs-item-video-neu-m0419f50m\").hide();
  }
  jwplayer(\"drs-item-video-neu-m0419f50m\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f50m\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m0419f50m\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m0419f50m\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m0419f50m\").play()
   })
  });</script><div class=\"hidden\">2017-05-18T15:22:19Z<br/>2017-05-18T15:24:18Z<br/>A<br/>CoreFile<br/>neu:cj82px08t<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2017-05-18T15:22:21Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px08t+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.2\",\"dsCreateDate\":\"2017-05-18T15:23:44Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":639,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px08t+rightsMetadata+rightsMetadata.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.3\",\"dsCreateDate\":\"2017-05-18T15:23:43Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1665,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px08t+DC+DC.3\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2018-12-21T16:09:22Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":730,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px08t+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.2\",\"dsCreateDate\":\"2017-05-18T15:23:43Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3189,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82px08t+mods+mods.2\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/afmodel:CoreFile\",\"info:fedora/fedora-system:FedoraObject-3.0\"],\"objCreateDate\":\"2017-05-18T15:22:19Z\",\"objLastModDate\":\"2017-05-18T15:24:18Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px08t/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82px08t/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_5<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_1<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_2<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_3<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_4<br/>/downloads/neu:m0419f525?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>Jelly Apple<br/>Jelly Apple<br/>Jelly Apple<br/>Jelly Apple<br/>Hailing from Westport, Connecticut, singer-songwriter Mike Orent is set to break into the Boston music scene with his self proclaimed \"sad folk / twinkly emo\" catalogue. Orent began playing the guitar over a decade ago and hasn\'t been able to put it down since. You can tell when he plays that his instrument is organically a part of him and that his comfortability with it has contributed to the conception of his several earnest, sincere, and wholehearted refrains. Drawing inspiration and influence from a variety of artists such as Elvis Costello, The Smiths, Pile, Elliot Smith, and Saves The Day, you are sure to be moved after hearing the honest lyrics and impressive vocals Mike offers up. Although this is Orents first solo project outside of his Alt-Rock band \"Pennies In The Couch\", his songs, especially Connect The Locks and Jelly Apple, tug at the heartstrings of listeners, showcasing his vulnerability and dynamic range.<br/>Northeastern University<br/>Northeastern University<br/>David Herlihy<br/>Music<br/>Abstract<br/>David Herlihy<br/>Music<br/>Abstract<br/>http://hdl.handle.net/2047/D20241954<br/>http://hdl.handle.net/2047/D20241954<br/>David Herlihy<br/>Music<br/>Abstract<br/>Jelly Apple<br/>Jelly Apple<br/>jelly apple<br/>Jelly Apple<br/>David Herlihy<br/>Orent, Mike<br/>Orent, Mike<br/>Northeastern University<br/>Orent, Mike<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2018-12-21T16:09:22.815Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445729","_transient_timeout_a9250dff89faa9643235dfa98855b8e2","1667017158","no");
INSERT INTO `wp_options` VALUES ("1445730","_transient_a9250dff89faa9643235dfa98855b8e2","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m039vr974\" src=\"https://repository.library.northeastern.edu/downloads/neu:cj82kv914?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m039vr974\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m039vr974\").hide();
  jwplayer(\"drs-item-video-neu-m039vr974\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:cj82kv914?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m039vr974/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m039vr974/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m039vr974\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m039vr974 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:cj82kv914?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m039vr974\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m039vr974\").show();
    $(\"#drs-item-video-neu-m039vr974\").hide();
  }
  jwplayer(\"drs-item-video-neu-m039vr974\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m039vr974\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m039vr974\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m039vr974\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m039vr974\").play()
   })
  });</script><div class=\"hidden\">2016-02-10T18:57:34Z<br/>2020-09-09T01:27:16Z<br/>A<br/>CoreFile<br/>neu:cj82kh556<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2016-02-10T18:57:39Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kh556+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.5\",\"dsCreateDate\":\"2016-03-11T14:48:55Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":712,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kh556+rightsMetadata+rightsMetadata.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.8\",\"dsCreateDate\":\"2020-09-09T01:27:16Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1097,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kh556+DC+DC.8\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.10\",\"dsCreateDate\":\"2018-12-21T16:09:20Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":753,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kh556+properties+properties.10\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.8\",\"dsCreateDate\":\"2020-09-09T01:27:13Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":1970,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kh556+mods+mods.8\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":\"The Ryan Martin Band - Hollow Heart.mov\",\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2016-02-10T18:57:34Z\",\"objLastModDate\":\"2020-09-09T01:27:16Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Acj82kh556/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Acj82kh556/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>northeastern:drs:library:dmc_studios<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_5<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_1<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_2<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_3<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_4<br/>/downloads/neu:cj82kv914?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>Hollow Heart<br/>Hollow Heart<br/>Hollow Heart<br/>Hollow Heart<br/>The Ryan Martin Band delivers powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds.<br/>Northeastern University<br/>Northeastern University<br/>2015-12-07<br/>2015-12-07<br/>Ryan Martin Band<br/>Hollow Heart<br/>David Herlihy<br/>Ryan Martin Band<br/>Hollow Heart<br/>David Herlihy<br/>http://hdl.handle.net/2047/D20201623<br/>http://hdl.handle.net/2047/D20201623<br/>Ryan Martin Band<br/>Hollow Heart<br/>David Herlihy<br/>Hollow Heart<br/>Hollow Heart<br/>hollow heart<br/>2015/12/07<br/>Hollow Heart<br/>2015-12-07<br/>Ryan Martin Band<br/>Hollow Heart<br/>David Herlihy<br/>Northeastern University<br/>Northeastern University<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2020-09-09T01:27:18.5Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446571","_transient_timeout_66a1457d4ea7a1032aac33479c2cab66","1667092149","no");
INSERT INTO `wp_options` VALUES ("1446572","_transient_66a1457d4ea7a1032aac33479c2cab66","<div class=\'drs-item\'><img id=\"drs-item-img-neu-bz60kz955\" src=\"https://repository.library.northeastern.edu/downloads/neu:bz60kz97q?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-bz60kz955\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-bz60kz955\").hide();
  jwplayer(\"drs-item-video-neu-bz60kz955\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:bz60kz97q?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:bz60kz955/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:bz60kz955/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-bz60kz955\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-bz60kz955 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:bz60kz97q?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-bz60kz955\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-bz60kz955\").show();
    $(\"#drs-item-video-neu-bz60kz955\").hide();
  }
  jwplayer(\"drs-item-video-neu-bz60kz955\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-bz60kz955\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-bz60kz955\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-bz60kz955\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-bz60kz955\").play()
   })
  });</script><div class=\"hidden\">2021-03-18T20:47:03Z<br/>2021-03-18T21:25:48Z<br/>A<br/>CoreFile<br/>neu:ww72bc80m<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2021-03-18T20:47:07Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bc80m+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.3\",\"dsCreateDate\":\"2021-03-18T21:25:45Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bc80m+rightsMetadata+rightsMetadata.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.6\",\"dsCreateDate\":\"2021-03-18T21:25:48Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1519,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bc80m+DC+DC.6\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.5\",\"dsCreateDate\":\"2021-03-18T21:18:21Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":708,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bc80m+properties+properties.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.3\",\"dsCreateDate\":\"2021-03-18T21:25:46Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":3594,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:ww72bc80m+mods+mods.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2021-03-18T20:47:03Z\",\"objLastModDate\":\"2021-03-18T21:25:48Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Aww72bc80m/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Aww72bc80m/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>001273100<br/>neu:rx9189661<br/>neu:rx9189661<br/>001273100<br/>001273100<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_1<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_2<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_3<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_4<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_5<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_1<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_2<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_3<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_4<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:rx9189661<br/>001273100<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_1<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_2<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_3<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_4<br/>/downloads/neu:bz60kz97q?datastream_id=thumbnail_5<br/>VideoFile<br/>Making of Protect the Pack<br/>Making of Protect the Pack<br/>Making of Protect the Pack<br/>Making of Protect the Pack<br/>The<br/>The<br/>An interview with the members of Snell Family and how the creation of \"Protect The Pack\" came to life.<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>Northeastern University Library<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>Northeastern University Library<br/>2021-03-05<br/>2021-03-05<br/>Remote Recording<br/>Snell Family Band<br/>Protect the Pack<br/>Remote Recording<br/>Snell Family Band<br/>Protect the Pack<br/>http://hdl.handle.net/2047/D20403383<br/>http://hdl.handle.net/2047/D20403383<br/>Remote Recording<br/>Snell Family Band<br/>Protect the Pack<br/>The<br/>Making of Protect the Pack<br/>The Making of Protect the Pack<br/>making of protect the pack<br/>The<br/>2021/03/05<br/>The Making of Protect the Pack<br/>2021-03-05<br/>Remote Recording<br/>Iannone, Jonathan<br/>DeUrso, Ben<br/>di Pierro, Chris<br/>Sayers, Patrick<br/>Schutz, Isaac<br/>Short, Criag<br/>Zimiroski, Jared<br/>Iannone, Jonathan<br/>DeUrso, Ben<br/>di Pierro, Chris<br/>Sayers, Patrick<br/>Schutz, Isaac<br/>Short, Criag<br/>Zimiroski, Jared<br/>Northeastern University Library Recording Studios<br/>Snell Family Band<br/>Northeastern University Library<br/>Iannone, Jonathan<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2021-03-18T21:26:13.662Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1445740","_transient_timeout_e46ebce4026166c267d34dfbbec19f56","1667017175","no");
INSERT INTO `wp_options` VALUES ("1445741","_transient_e46ebce4026166c267d34dfbbec19f56","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m039xn78n\" src=\"https://repository.library.northeastern.edu/downloads/neu:m039xn80p?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m039xn78n\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m039xn78n\").hide();
  jwplayer(\"drs-item-video-neu-m039xn78n\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m039xn80p?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m039xn78n/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m039xn78n/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m039xn78n\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m039xn78n video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m039xn80p?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m039xn78n\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m039xn78n\").show();
    $(\"#drs-item-video-neu-m039xn78n\").hide();
  }
  jwplayer(\"drs-item-video-neu-m039xn78n\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m039xn78n\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m039xn78n\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m039xn78n\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m039xn78n\").play()
   })
  });</script><div class=\"hidden\">2016-03-11T19:30:21Z<br/>2018-12-20T15:33:42Z<br/>A<br/>CoreFile<br/>neu:cj82kv92d<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2016-03-11T19:30:25Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kv92d+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.3\",\"dsCreateDate\":\"2016-03-11T19:44:51Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":712,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kv92d+rightsMetadata+rightsMetadata.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.6\",\"dsCreateDate\":\"2018-12-20T15:33:42Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1414,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kv92d+DC+DC.6\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2018-12-21T16:09:02Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":746,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kv92d+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.5\",\"dsCreateDate\":\"2018-12-20T15:33:39Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2220,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:cj82kv92d+mods+mods.5\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":\"AllIHadtoGiveFINALVideo4_new.mov\",\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2016-03-11T19:30:21Z\",\"objLastModDate\":\"2018-12-20T15:33:42Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82kv92d/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Acj82kv92d/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000446743<br/>neu:rx9189661<br/>neu:rx9189661<br/>000446743<br/>000446743<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_1<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_2<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_3<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_4<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_5<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_1<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_2<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_3<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_4<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>true<br/>true<br/>neu:rx9189661<br/>000446743<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_1<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_2<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_3<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_4<br/>/downloads/neu:m039xn80p?datastream_id=thumbnail_5<br/>VideoFile<br/>true<br/>All I Had to Give<br/>All I Had to Give<br/>All I Had to Give<br/>All I Had to Give<br/>Blindspot is a female-fronted indie rock band from Boston, MA.  They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees and Coldplay.  Their unique sound,
passion, and drive make them stand out against other musicians of their age. blindspot has opened for inter- nationally recognized bands such as Gin Blossoms, Candlebox, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantri<br/>Northeastern University<br/>Northeastern University<br/>2015-12-07<br/>2015-12-07<br/>All Had to Give<br/>David Herliey<br/>Blindspot<br/>All Had to Give<br/>David Herliey<br/>Blindspot<br/>http://hdl.handle.net/2047/D20203288<br/>http://hdl.handle.net/2047/D20203288<br/>All Had to Give<br/>David Herliey<br/>Blindspot<br/>All I Had to Give<br/>All I Had to Give<br/>all i had to give<br/>2015/12/07<br/>All I Had to Give<br/>2015-12-07<br/>All Had to Give<br/>Northeastern University<br/>Northeastern University<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:rx9189661<br/>2018-12-21T16:09:02.528Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446652","_site_transient_timeout_theme_roots","1667038450","no");
INSERT INTO `wp_options` VALUES ("1446653","_site_transient_theme_roots","a:3:{s:11:\"quest-child\";s:7:\"/themes\";s:5:\"quest\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";}","no");
INSERT INTO `wp_options` VALUES ("1445724","_transient_5975827b691e8337a542919085f54086","<div class=\'freewall\' id=\'freewall\' data-type=\'pinterest-hover\' data-cell-height=\'200\' data-cell-width=\'200\' data-text-align=\'left\'><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:gm80mp83j?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82qp53c\'>Black Women Sexuality vs. Japanese Women Sexuality<br/>Ajegwu, Rose<br/>Gandolfo, Sakura<br/></a><div class=\"hidden\">2017-12-04T18:04:25Z<br/>2020-10-05T15:59:04Z<br/>A<br/>CoreFile<br/>neu:cj82qp53c<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000000000<br/>neu:cj82qp24x<br/>neu:cj82qp24x<br/>000000000<br/>000000000<br/>001126975<br/>001126975<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_5<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82qp24x<br/>000000000<br/>001126975<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mp83j?datastream_id=thumbnail_5<br/>AudioFile<br/>Black Women Sexuality vs. Japanese Women Sexuality: The Impact of media, culture, society on health.<br/>Black Women Sexuality vs. Japanese Women Sexuality: The Impact of media, culture, society on health.<br/>Black Women Sexuality vs. Japanese Women Sexuality<br/>Black Women Sexuality vs. Japanese Women Sexuality<br/>The Impact of media, culture, society on health<br/>The Impact of media, culture, society on health<br/>How culture, media, society, and science impacts the health and sexuality of Black women and Japanese women<br/>
         Creator
      <br/>
         Creator
      <br/>
         Creator
      <br/>
         Creator
      <br/>podcasts<br/>2017-12-04<br/>2017-12-04<br/>black women<br/>Japanese women<br/>sexuality<br/>health<br/>medicine<br/>science<br/>women<br/>society<br/>culture<br/>black women<br/>Japanese women<br/>sexuality<br/>health<br/>medicine<br/>science<br/>women<br/>society<br/>culture<br/>http://hdl.handle.net/2047/D20260270<br/>http://hdl.handle.net/2047/D20260270<br/>black women<br/>Japanese women<br/>sexuality<br/>health<br/>medicine<br/>science<br/>women<br/>society<br/>culture<br/>Black Women Sexuality vs. Japanese Women Sexuality<br/>Power, Privilege, Perseverance<br/>Black Women Sexuality vs. Japanese Women Sexuality: The Impact of media, culture, society on health.<br/>black women sexuality vs japanese women sexuality the impact of media culture society on health<br/>2017/12/04<br/>Black Women Sexuality vs. Japanese Women Sexuality<br/>2017-12-04<br/>black women<br/>Japanese women<br/>sexuality<br/>health<br/>medicine<br/>science<br/>women<br/>society<br/>culture<br/>Ajegwu, Rose<br/>Gandolfo, Sakura<br/>Ajegwu, Rose<br/>Gandolfo, Sakura<br/>Ajegwu, Rose<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82qp24x<br/>2020-10-05T15:59:07.057Z<br/></div></div></div><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:gm80mq221?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82qp477\'>The Rainbow Ceiling of Medical Schools and Careers<br/>Flores Romero, Gladys<br/>Kim, Sooji<br/>Seltzer, Cynthia<br/></a><div class=\"hidden\">2017-12-04T16:40:18Z<br/>2020-10-05T15:55:45Z<br/>A<br/>CoreFile<br/>neu:cj82qp477<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000000000<br/>neu:cj82qp24x<br/>neu:cj82qp24x<br/>000000000<br/>000000000<br/>001126975<br/>001126975<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_5<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82qp24x<br/>000000000<br/>001126975<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq221?datastream_id=thumbnail_5<br/>AudioFile<br/>Rainbow Ceiling of Medical Schools and Careers<br/>Rainbow Ceiling of Medical Schools and Careers<br/>Rainbow Ceiling of Medical Schools and Careers<br/>Rainbow Ceiling of Medical Schools and Careers<br/>The<br/>The<br/>While modern society has taken advancements to fight for the rights of the LGBTQ community, there still exists negative climates that set up discrimination and inequity for LGBTQ members interested in pursuing a medical career. This podcast explores examples of discrimination and inequities from statistical research and personal encounters of medical professionals. We take you through medical applications, schooling, and residency pursuits to show how LGBTQ members are put at significant disadvantages or forced to limit their choices due to gender/sexual identity.<br/>
         Creator
      <br/>
         Creator
      <br/>
         Interviewee
      <br/>
         Creator
      <br/>
         Creator
      <br/>
         Interviewee
      <br/>podcasts<br/>2017-12-03<br/>2017-12-03<br/>LGBTQ<br/>gender identity<br/>sexual identity<br/>human rights<br/>medical school<br/>medical career<br/>discrimination<br/>disability<br/>transgender rights<br/>microinequities<br/>mental health<br/>underrepresentation in medicine<br/>LGBTQ<br/>gender identity<br/>sexual identity<br/>human rights<br/>medical school<br/>medical career<br/>discrimination<br/>disability<br/>transgender rights<br/>microinequities<br/>mental health<br/>underrepresentation in medicine<br/>http://hdl.handle.net/2047/D20260258<br/>http://hdl.handle.net/2047/D20260258<br/>LGBTQ<br/>gender identity<br/>sexual identity<br/>human rights<br/>medical school<br/>medical career<br/>discrimination<br/>disability<br/>transgender rights<br/>microinequities<br/>mental health<br/>underrepresentation in medicine<br/>The<br/>Rainbow Ceiling of Medical Schools and Careers<br/>Power, Privilege, Perseverance<br/>The Rainbow Ceiling of Medical Schools and Careers<br/>rainbow ceiling of medical schools and careers<br/>The<br/>2017/12/03<br/>The Rainbow Ceiling of Medical Schools and Careers<br/>2017-12-03<br/>LGBTQ<br/>gender identity<br/>sexual identity<br/>human rights<br/>medical school<br/>medical career<br/>discrimination<br/>disability<br/>transgender rights<br/>microinequities<br/>mental health<br/>underrepresentation in medicine<br/>Flores Romero, Gladys<br/>Kim, Sooji<br/>Seltzer, Cynthia<br/>Flores Romero, Gladys<br/>Kim, Sooji<br/>Seltzer, Cynthia<br/>Flores Romero, Gladys<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82qp24x<br/>2020-10-05T15:55:47.962Z<br/></div></div></div><div class=\'brick brick-hover\'><img src=\'https://repository.library.northeastern.edu/downloads/neu:gm80mq16w?datastream_id=thumbnail_4\' style=\'width:100%\'><div class=\'info wp-caption-text\'><a href=\'https://recordingstudios.library.northeastern.edu/item/neu:cj82qp55x\'>Sexual Education in Boston Communities<br/>Buxton, Claire<br/>Spaulding, Shelby<br/></a><div class=\"hidden\">2017-12-04T19:25:07Z<br/>2020-10-05T15:57:05Z<br/>A<br/>CoreFile<br/>neu:cj82qp55x<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000000000<br/>neu:cj82qp24x<br/>neu:cj82qp24x<br/>000000000<br/>000000000<br/>001126975<br/>001126975<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_5<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82qp24x<br/>000000000<br/>001126975<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_1<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_2<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_3<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_4<br/>/downloads/neu:gm80mq16w?datastream_id=thumbnail_5<br/>AudioFile<br/>Sexual Education in Boston Communities<br/>Sexual Education in Boston Communities<br/>Sexual Education in Boston Communities<br/>Sexual Education in Boston Communities<br/>In this podcast, we study the differing standards of sexual education in communities of different demographics and incomes within the city of Boston as compared to the surrounding suburban communities. Additionally, we provide some study of the effects of comprehensive sexual education including a decline in teen pregnancy.<br/>
         Creator
      <br/>
         Creator
      <br/>
         Creator
      <br/>
         Creator
      <br/>podcasts<br/>2017-12-03<br/>2017-12-03<br/>Boston<br/>sexual education<br/>legislation<br/>inequality<br/>teen pregnancy<br/>Boston<br/>sexual education<br/>legislation<br/>inequality<br/>teen pregnancy<br/>http://hdl.handle.net/2047/D20260271<br/>http://hdl.handle.net/2047/D20260271<br/>Boston<br/>sexual education<br/>legislation<br/>inequality<br/>teen pregnancy<br/>Sexual Education in Boston Communities<br/>Power, Privilege, Perseverance<br/>Sexual Education in Boston Communities<br/>sexual education in boston communities<br/>2017/12/03<br/>Sexual Education in Boston Communities<br/>2017-12-03<br/>Boston<br/>sexual education<br/>legislation<br/>inequality<br/>teen pregnancy<br/>Buxton, Claire<br/>Spaulding, Shelby<br/>Buxton, Claire<br/>Spaulding, Shelby<br/>Buxton, Claire<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82qp24x<br/>2020-10-05T15:57:08.027Z<br/></div></div></div></div>","no");
INSERT INTO `wp_options` VALUES ("1446625","_transient_timeout_0b9c6ce8a2601bc237b34db7ef311723","1667094850","no");
INSERT INTO `wp_options` VALUES ("1446626","_transient_0b9c6ce8a2601bc237b34db7ef311723","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m044g844q\" src=\"https://repository.library.northeastern.edu/downloads/neu:m044g8468?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m044g844q\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"sound\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m044g844q\").hide();
  jwplayer(\"drs-item-video-neu-m044g844q\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m044g8468?datastream_id=thumbnail_4\",provider: \"sound\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g844q/plain\", type:\"mp3\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m044g844q/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m044g844q\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m044g844q video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m044g8468?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m044g844q\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m044g844q\").show();
    $(\"#drs-item-video-neu-m044g844q\").hide();
  }
  jwplayer(\"drs-item-video-neu-m044g844q\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g844q\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m044g844q\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m044g844q\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m044g844q\").play()
   })
  });</script><div class=\"hidden\">2019-07-08T19:14:52Z<br/>2019-07-08T19:47:50Z<br/>A<br/>CoreFile<br/>neu:f1881z26j<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.1\",\"dsCreateDate\":\"2019-07-08T19:14:53Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z26j+RELS-EXT+RELS-EXT.1\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.3\",\"dsCreateDate\":\"2019-07-08T19:47:49Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":639,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z26j+rightsMetadata+rightsMetadata.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.6\",\"dsCreateDate\":\"2019-07-08T19:47:50Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":1300,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z26j+DC+DC.6\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.6\",\"dsCreateDate\":\"2019-07-08T19:23:56Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":725,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z26j+properties+properties.6\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.3\",\"dsCreateDate\":\"2019-07-08T19:47:49Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2677,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881z26j+mods+mods.3\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-07-08T19:14:52Z\",\"objLastModDate\":\"2019-07-08T19:47:50Z\",\"objDissIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z26j/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://nb4676.neu.edu:8080/fedora/objects/neu%3Af1881z26j/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>public<br/>001273100<br/>neu:cj82kf08d<br/>neu:cj82kf08d<br/>001273100<br/>001273100<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_5<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_5<br/>AudioFile<br/>AudioFile<br/>neu:cj82kf08d<br/>001273100<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_1<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_2<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_3<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_4<br/>/downloads/neu:m044g8468?datastream_id=thumbnail_5<br/>AudioFile<br/>Self<br/>Self<br/>Self<br/>Self<br/>Recorded, mixed, and mastered at Snell Studios in 2018 Saxophone: Barak Isaac Drums: Dan Mulligan Bass: Luke Miller Bass: Zac Kerwin Album Cover Photo: Eden Desta Album Cover Edit: Maddie Seraphin Special thanks to Ben DeUrso, Jack Fallon-Underwood, The DMC Snell Studios @ Northeastern University &amp; Citizens\' Loft. Citizens\' Loft Records<br/>2018-09-15<br/>2018-09-15<br/>Citizen\'s Loft<br/>R&B<br/>Soul<br/>neo soul<br/>Boston<br/>Citizen\'s Loft<br/>R&B<br/>Soul<br/>neo soul<br/>Boston<br/>http://hdl.handle.net/2047/D20318897<br/>http://hdl.handle.net/2047/D20318897<br/>Citizen\'s Loft<br/>R&B<br/>Soul<br/>neo soul<br/>Boston<br/>Self<br/>Self<br/>self<br/>2018/09/15<br/>Self<br/>2018-09-15<br/>Citizen\'s Loft<br/>Yeboah, Julian<br/>Yeboah, Julian<br/>Yeboah, Julian<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:cj82kf08d<br/>2019-07-08T19:47:56.414Z<br/></div></div>","no");
INSERT INTO `wp_options` VALUES ("1441822","_transient_timeout_feed_d21d2a68bac70d38fb7f9a7bd3d1725e","1667220627","no");
INSERT INTO `wp_options` VALUES ("1441823","_transient_feed_d21d2a68bac70d38fb7f9a7bd3d1725e","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:5:\"

	
	\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:370:\"

		
		
		
				
		
		

		
		
			
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

				
				

							
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WordPress.org Forums » [XML Sitemaps] Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/support/plugin/google-sitemap-generator/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Oct 2022 12:46:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://bbpress.org/?v=2.7.0-alpha-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/support/topic/excluded-by-noindex-tag-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Excluded by ‘noindex’ tag\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/support/topic/excluded-by-noindex-tag-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Oct 2022 11:07:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:693:\"
						
						<p>Replies: 2</p>
						<p>Hi there;<br />
I just received an email from GSC regarding the &#8220;Excluded by ‘noindex’ tag&#8221; issue.<br />
The effected URL; is <a href=\"https://peshto.com/sitemap.html\" target=\"_blank\" rel=\"noopener nofollow ugc\">https://peshto.com/sitemap.html</a></p>
<p>I haven&#8217;t changed any settings of XML Sitemaps Plugin on my website since I set up the plugin. I have many websites that I use your plugin. I think, sooner or later; GSC will start to send the same &#8220;Excluded by ‘noindex’ tag&#8221; issue for my other sites too.</p>
<p>Do you have any suggestions regarding how to fix this?<br />
Thanks in advance.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"brs76\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/support/topic/sitemap-not-working-23/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Sitemap not working\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/support/topic/sitemap-not-working-23/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Oct 2022 12:07:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"
						
						<p>Replies: 0</p>
						<p>Hi<br />
I activated your sitemap plugin but it not working dont know why</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Don Akanido\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/support/topic/my-posts-is-no-longer-indexing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"My Posts Is No Longer Indexing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/support/topic/my-posts-is-no-longer-indexing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Oct 2022 10:34:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:194:\"
						
						<p>Replies: 0</p>
						<p>Please I need help my posts was indexing normal until I changed my theme to a different theme since then it&#8217;s no longer indexing..</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"harrisonpius\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/support/topic/sitemap-for-non-wp-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"sitemap for non wp site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/support/topic/sitemap-for-non-wp-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Oct 2022 08:44:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:657:\"
						
						<p>Replies: 0</p>
						<p>I have my wp site in a subfolder like<br />
stampden.com/wp</p>
<p>Can this plugin be made to create a sitemap for the main domain stampden.com?<br />
Stampden.com IS NOT a wp site</p>
<p>Thanks</p>


<ul id=\"bbp-topic-revision-log-16117466\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-16117466-item-16117471\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 4 days, 4 hours ago by <a href=\"https://wordpress.org/support/users/russromei/\" title=\"View russromei&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">russromei</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"russromei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/support/topic/do-not-work-sitemap/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"&lt;span class=&quot;resolved&quot; aria-label=&quot;Resolved&quot; title=&quot;Topic is resolved.&quot;&gt;&lt;/span&gt;Do not work sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/support/topic/do-not-work-sitemap/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Oct 2022 17:17:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:824:\"
						
						<p>Replies: 2</p>
						<p>Hi.<br />
I have been using XML Sitemaps for two years.<br />
But today when i try to open my site, i saw a message:<br />
&#8220;This page contains the following errors:<br />
error on line 2 at column 1: Extra content at the end of the document<br />
Below is a rendering of the page up to the first error.&#8221;<br />
Can you give me advice ? Thanks.</p>


<ul id=\"bbp-topic-revision-log-16111335\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-16111335-item-16111466\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 5 days, 18 hours ago by <a href=\"https://wordpress.org/support/users/oratorslova/\" title=\"View oratorslova&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">oratorslova</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"oratorslova\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/support/topic/custom-links-included-in-sitemap/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Custom links included in sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/support/topic/custom-links-included-in-sitemap/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Oct 2022 19:46:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"
						
						<p>Replies: 3</p>
						<p>Hi, a cache specialist mentioned that I should include certain links inside my sitemap in order for them to load faster and pre-warm. How do I add these custom wordpress links to my Sitemap using this plugin? </p>
<p>These custom wordpress links include links to product pages instructing the drop down menus to pre-populate (they link to specific attribute combinations). </p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"mattsws\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/support/topic/robots-txt-21/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"robots.txt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/support/topic/robots-txt-21/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Oct 2022 10:14:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"
						
						<p>Replies: 1</p>
						<p>You try to open robots.txt for read/write access. The file is read-only (no matter why). In effect it generates</p>
<blockquote><p>PHP Warning:  file(&#8230;/robots.txt): failed to open stream: Permission denied in &#8230;/wp-content/plugins/google-sitemap-generator/sitemap-core.php on line 1186</p></blockquote>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"pik256\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/support/topic/sitemap-xml-slow-to-load/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Sitemap.xml slow to load\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/support/topic/sitemap-xml-slow-to-load/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Oct 2022 09:46:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:690:\"
						
						<p>Replies: 1</p>
						<p>Our XML sitemap at <a href=\"https://www.hawsons.co.uk/sitemap.xml\" rel=\"nofollow ugc\">https://www.hawsons.co.uk/sitemap.xml</a> takes a long time to load (10 seconds). This may or may not be the reason why our WP Rocket caching is not working as it should, as it&#8217;s possible that WP Rocket can&#8217;t get the information from the sitemap to cache the pages. I notice that the http version ie. <a href=\"http://www.hawsons.co.uk/sitemap.xml\" rel=\"nofollow ugc\">http://www.hawsons.co.uk/sitemap.xml</a> loads almost instantly. Do you have any advice on how to identify what is wrong / to speed up the https version?</p>
<p>Thanks</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"hawsonsck\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/support/topic/generate-sitemap-tax-1-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Generate sitemap-tax&amp;#8211;1.xml\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/support/topic/generate-sitemap-tax-1-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Oct 2022 07:18:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1793:\"
						
						<p>Replies: 1</p>
						<p>class-googlesitemapgeneratorstandardbuilder.php<br />
<code>$gsg-&gt;add_sitemap( &#039;tax-&#039; . $taxs[ $tax_count ]-&gt;taxonomy, $step, $blog_update );</code></p>
<p>You should see &#8220;sitemap-tax&#8211;1.xml&#8221; (two hyphens before 1) in /sitemap.xml.</p>
<p>The expected file name is:<br />
sitemap-tax-[taxonomy_name]-1.xml</p>
<p>The keys of the return value array of the WordPress function &#8220;get_terms&#8221; do not necessarily start from 0.</p>
<p>For example, it should be modified as follows:<br />
<code>$gsg-&gt;add_sitemap( &#039;tax-&#039; . $tax, $step, $blog_update );</code></p>
<p>Environment<br />
Core version: 6.0.x<br />
Plugin version: 4.1.5 and develop</p>


<ul id=\"bbp-topic-revision-log-16091409\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-16091409-item-16091414\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 1 week, 5 days ago by <a href=\"https://wordpress.org/support/users/effatainc/\" title=\"View effatainc&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">effatainc</span></a>.
	</li>
	<li id=\"bbp-topic-revision-log-16091409-item-16091415\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 1 week, 5 days ago by <a href=\"https://wordpress.org/support/users/effatainc/\" title=\"View effatainc&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">effatainc</span></a>.
	</li>
	<li id=\"bbp-topic-revision-log-16091409-item-16091423\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 1 week, 5 days ago by <a href=\"https://wordpress.org/support/users/effatainc/\" title=\"View effatainc&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">effatainc</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"effatainc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/support/topic/sitemaps-showing-webstories/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Sitemaps showing webstories\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/support/topic/sitemaps-showing-webstories/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Oct 2022 08:37:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:273:\"
						
						<p>Replies: 1</p>
						<p>Enabled sitemap on website <a href=\"https://cult.technology/\" rel=\"nofollow ugc\">cult.technology</a>. However it is showing web stories sitemaps as well. Please help to disable the webstories appearing from sitemap.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"subbamma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/support/topic/sitemap-not-adding-new-authors-to-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Sitemap not adding new Authors to XML\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/support/topic/sitemap-not-adding-new-authors-to-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Oct 2022 12:58:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:528:\"
						
						<p>Replies: 1</p>
						<p>Example: <a href=\"https://www.example.co.uk/sitemap-authors.xml\" rel=\"nofollow ugc\">https://www.example.co.uk/sitemap-authors.xml</a></p>
<p>Does anyone know why newly created authors/users (not posts or pages) are not being added to the sitemap link above? If I remove an author page from the site the sitemap-authors updated and removes the link. But it does not add new one&#8217;s that are created on the site.</p>
<p>Any help is appreciated.</p>
<p>Thanks,<br />
C.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"chiefochiefo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/support/topic/php-8-1-compatibility-error/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"PHP 8.1 Compatibility Error\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/support/topic/php-8-1-compatibility-error/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Sep 2022 20:26:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1641:\"
						
						<p>Replies: 1</p>
						<p>This is the following output when using php code sniffer to check for php 8.1 compatibility, should we fix this ourselves or wait for the next release? Thanks!</p>
<p>FILE: google-sitemap-generator\\sitemap-core.php<br />
&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8211;<br />
FOUND 1 ERROR AND 1 WARNING AFFECTING 2 LINES<br />
&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8211;<br />
 2204 | ERROR   | Since PHP 7.0, functions inspecting arguments, like<br />
      |         | debug_backtrace(), no longer report the original value as<br />
      |         | passed to a parameter, but will instead provide the current<br />
      |         | value. The parameter &#8220;$last_mod&#8221; was changed on line 2196.<br />
 2232 | WARNING | Since PHP 7.0, functions inspecting arguments, like<br />
      |         | debug_backtrace(), no longer report the original value as<br />
      |         | passed to a parameter, but will instead provide the current<br />
      |         | value. The parameter &#8220;$type&#8221; was used, and possibly changed<br />
      |         | (by reference), on line 2224.<br />
&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8212;&#8211;</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"aaronmcquade\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/support/topic/pages-for-archives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Pages for archives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/support/topic/pages-for-archives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Sep 2022 09:36:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:645:\"
						
						<p>Replies: 1</p>
						<p>Hello,<br />
is there a way to force adding pages for the archives and/or main blog. Now it adds just adds the first page. Ideally it would be to have an option on items per page (since this can be configured in different themes). Example:<br />
<a href=\"http://domain.com/blog/\" rel=\"nofollow ugc\">http://domain.com/blog/</a><br />
<a href=\"http://domain.com/blog/page/2\" rel=\"nofollow ugc\">http://domain.com/blog/page/2</a><br />
<a href=\"http://domain.com/blog/page/3\" rel=\"nofollow ugc\">http://domain.com/blog/page/3</a><br />
where there are 25 posts and so these are divided by 10.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"dingdang\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/support/topic/unsupported-file-format-in-search-console/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"unsupported file format in search console\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/support/topic/unsupported-file-format-in-search-console/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Sep 2022 16:52:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:216:\"
						
						<p>Replies: 6</p>
						<p>Hello, the plugin seems to be not working. When I try to load it I see a blank page and Google Search Console indicates &#8220;unsupported file format&#8221; </p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"algopoco\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/xml-sitemap-42/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"XML Sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/xml-sitemap-42/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Sep 2022 22:37:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:226:\"
						
						<p>Replies: 1</p>
						<p>Have a quick question&#8230;</p>
<p>Is it necessary to keep &#8216;Google XML Sitemaps&#8217; plugin in order to make it work for google search?</p>
<p>Thanks,<br />
NC</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"codenyc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/support/topic/error-in-sql-syntax-version-4-1-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Error in SQL syntax, Version 4.1.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/support/topic/error-in-sql-syntax-version-4-1-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 18 Sep 2022 22:02:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3036:\"
						
						<p>Replies: 1</p>
						<p>I&#8217;m seeing the below error on both blogs of mine that use this plugin.  If I downgrade to 4.1.1, I don&#8217;t see the errors (but I would rather stay on latest and greatest for security).  I see that this error occurred for <a href=\"https://wordpress.org/support/topic/sql-query-bug-in-google-xml-sitemaps-v-4-1-4/\" rel=\"noopener\" target=\"_blank\">someone here 3-4 months</a> back in v4.1.4.  Is anyone else seeing this?</p>
<ul>
<li><strong>Version numbers:</strong> WordPress Version 6.0.2, plugin Version 4.1.5</li>
<li><strong>The URL to blog:</strong> <a href=\"https://www.nowwerecookin.org/\" target=\"_blank\" rel=\"noopener nofollow ugc\">nowwerecookin.org</a> and <a href=\"https://www.nickifaulk.com/\" target=\"_blank\" rel=\"noopener nofollow ugc\">nickifaulk.com</a> both run this.</li>
<li><strong>Software of webserver:</strong> Apache/2.4.54</li>
<li><strong>List of other plugins used, especially plugins which modify the output, like caching or SEO plugins:</strong> Akismet, Classic Editor, Display Posts, Print PDF, Remove Noreferrer, Search Meter, Sharify, TaxoPress, Very Simple Contact Form, WP Super Cache</li>
</ul>
<p><strong>Error_log contents:</strong></p>
<pre><code>[18-Sep-2022 07:12:37 UTC] WordPress database error You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near &#039;-&gt;posts} p WHERE p.post_status=&#039;publish&#039;&#039; at line 1 for query SELECT COUNT(*) FROM {$wpdb-&gt;posts} p WHERE p.post_status=&#039;publish&#039; made by do_action_ref_array(&#039;sm_ping_daily&#039;), WP_Hook-&gt;do_action, WP_Hook-&gt;apply_filters, GoogleSitemapGeneratorLoader::call_send_ping_daily, GoogleSitemapGenerator-&gt;send_ping_daily, GoogleSitemapGenerator-&gt;send_stats
[18-Sep-2022 13:54:54 UTC] WordPress database error You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near &#039;-&gt;posts} p WHERE p.post_status=&#039;publish&#039;&#039; at line 1 for query SELECT COUNT(*) FROM {$wpdb-&gt;posts} p WHERE p.post_status=&#039;publish&#039; made by do_action_ref_array(&#039;sm_ping_daily&#039;), WP_Hook-&gt;do_action, WP_Hook-&gt;apply_filters, GoogleSitemapGeneratorLoader::call_send_ping_daily, GoogleSitemapGenerator-&gt;send_ping_daily, GoogleSitemapGenerator-&gt;send_stats
[18-Sep-2022 19:04:22 UTC] WordPress database error You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near &#039;-&gt;posts} p WHERE p.post_status=&#039;publish&#039;&#039; at line 1 for query SELECT COUNT(*) FROM {$wpdb-&gt;posts} p WHERE p.post_status=&#039;publish&#039; made by do_action_ref_array(&#039;sm_ping_daily&#039;), WP_Hook-&gt;do_action, WP_Hook-&gt;apply_filters, GoogleSitemapGeneratorLoader::call_send_ping_daily, GoogleSitemapGenerator-&gt;send_ping_daily, GoogleSitemapGenerator-&gt;send_stats</code></pre>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Nicki Faulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/support/topic/seo-sitemaps-issues-google-sitemap-generator-created-missing-slug-in-the-url/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Missing slug of the URL in the sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"https://wordpress.org/support/topic/seo-sitemaps-issues-google-sitemap-generator-created-missing-slug-in-the-url/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Sep 2022 08:05:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1320:\"
						
						<p>Replies: 1</p>
						<p>I am using XML sitemap generator plugin on WordPress to create the sitemap. My website has two categories as blogs and case studies. The point is that on website/sitemap.xml, our blog is missing slug /blog/ in between.</p>
<p>For example, the correct URL is xyz.com/blog/welcome-to-xyz. But in the sitemap, it is generated the link is xyz.com/welcome-to-xyz (because it&#8217;s missing slug &#8220;blog&#8221; in the middle, all of the pages listed on the sitemap returned 404 error)</p>
<p>Do you know why it happens and any way to fix it?</p>
<p>Thanks</p>


<ul id=\"bbp-topic-revision-log-16000460\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-16000460-item-16000473\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 1 month, 1 week ago by <a href=\"https://wordpress.org/support/users/daolyy/\" title=\"View daolyy&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">daolyy</span></a>.
	</li>
	<li id=\"bbp-topic-revision-log-16000460-item-16000480\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 1 month, 1 week ago by <a href=\"https://wordpress.org/support/users/daolyy/\" title=\"View daolyy&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">daolyy</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"daolyy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/support/topic/delete-link-sitemap-misc-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"delete link sitemap-misc.xml\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/support/topic/delete-link-sitemap-misc-xml/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Sep 2022 19:31:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1169:\"
						
						<p>Replies: 1</p>
						<p>i have 3 questions<br />
See screenshot <a href=\"https://prnt.sc/m4zjiv8wepdY\" rel=\"nofollow ugc\">https://prnt.sc/m4zjiv8wepdY</a><br />
1. how to remove link from xml sitemap <a href=\"https://digitalburbank.com/sitemap-misc.xml\" rel=\"nofollow ugc\">https://digitalburbank.com/sitemap-misc.xml</a><br />
2. how to remove link from xml sitemap <a href=\"https://digitalburbank.com/sitemap-tax&#8211;1.xml\" rel=\"nofollow ugc\">https://digitalburbank.com/sitemap-tax&#8211;1.xml</a><br />
3. in the sitemap itself, I have links to find in groups. in the sense you open one link and there are 3 links in it. how to show all links at once on the first page and remove groups. this link group, (See screenshot ) <a href=\"https://prnt.sc/AewjS7DTIHHs\" rel=\"nofollow ugc\">https://prnt.sc/AewjS7DTIHHs</a> and in it the main links (See screenshot ) <a href=\"https://prnt.sc/_s1yr8YrU5V9\" rel=\"nofollow ugc\">https://prnt.sc/_s1yr8YrU5V9</a> . how to remove group links and leave only main links.<br />
I need to remove these links and leave only the links that are in them<br />
(See screenshot )https://prnt.sc/3tHwYG2ROlGM</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"sipan13\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/support/topic/plugin-only-available-to-administrator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Plugin only available to administrator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/support/topic/plugin-only-available-to-administrator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Aug 2022 23:24:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:805:\"
						
						<p>Replies: 1</p>
						<p>This is an issue when restricting access to the WP Admin to different roles. For example, using the WP plugin &#8216;Members&#8217;, we have created roles that restrict what a user can do in the WP Admin. This is important for granting access to SEO Agencies where they should be able to create posts and modify SEO settings (like a sitemap), but not be allowed to add users, manage plugins etc.</p>
<p>I noticed that your plugin set the capability of the plugin&#8217;s settings page to &#8216;administrator&#8217;. As such, using the plugin requires that we allow someone to have the administrator capability. Is there a way we can set this capability to something like &#8216;manage_options&#8217; which allows finer control of different roles?</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"11thhoursolutions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wordpress.org/support/topic/is-there-a-way-to-create-a-sitemap-branch-with-videos-from-the-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"&lt;span class=&quot;resolved&quot; aria-label=&quot;Resolved&quot; title=&quot;Topic is resolved.&quot;&gt;&lt;/span&gt;Is there a way to create a sitemap branch with videos from the web?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wordpress.org/support/topic/is-there-a-way-to-create-a-sitemap-branch-with-videos-from-the-web/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Aug 2022 06:59:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:151:\"
						
						<p>Replies: 4</p>
						<p>There are a way to create a sitemap branch with videos from the web?</p>
<p>thanks in advance</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"alexander_sp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/support/topic/sitemap-conflicts-with-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sitemap conflicts with products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/support/topic/sitemap-conflicts-with-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Aug 2022 18:17:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"
						
						<p>Replies: 1</p>
						<p>Not only this plugin doesn&#8217;t contain products and categories made by woocommerce, but also when you check the option of including products, they will be removed.<br />
It has been over 3 years that I&#8217;m using this plugin rather than simple no feature Rank Math sitemap. if you&#8217;re reading this, let me know if the problems are going to be fixed.<br />
Thank you.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"mahdi4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/support/topic/sitemap-rewrite-rules-for-custom-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Sitemap rewrite rules for custom products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wordpress.org/support/topic/sitemap-rewrite-rules-for-custom-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 20 Aug 2022 12:38:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:412:\"
						
						<p>Replies: 3</p>
						<p>Hi,</p>
<p>I&#8217;m using this plugin and I had to add the rewrite rules in the nginx config file for it to work properly. So far so good.<br />
However, I have another sitemap (address is googlecatalog.xml) that now doesn&#8217;t load in the browser (404 error). Should I use another rewrite rule for this custom sitemap? Which is it?</p>
<p>Thank you.</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"RobotFX\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wordpress.org/support/topic/maps-marker-pro-plugin-integration-is-broken-with-new-versions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"„Maps Marker Pro“ plugin integration is broken with new versions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wordpress.org/support/topic/maps-marker-pro-plugin-integration-is-broken-with-new-versions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Aug 2022 15:59:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1053:\"
						
						<p>Replies: 1</p>
						<p>According to your documentation (available even in the latest version) we have been using the documented instance <code>GetInstance</code> and the method <code>AddUrl</code> to add geositemaps created with our mapping plugin <a href=\"https://www.mapsmarker.com/\" target=\"_blank\" rel=\"noopener nofollow ugc\">http://www.mapsmarker.com</a> to the sitemap.</p>
<p>We now found, that this integration got broken with a new version of this plugin (not sure which version exactly): the instance <code>GetInstance</code> got renamed to <code>get_instance</code> and the method <code>AddUrl</code> to <code>add_url</code>.</p>
<p>We fixed this for now in Maps Marker Pro v4.22 by adding a check which instances/methods are available – anyway these changes have likely resulted in lots of other broken 3rd party integrations.</p>
<p>So my advise/request would be to add wrapper function for example to re-add backward-compatibility for existing 3rd party integrations.<br />
Happy mapping,</p>
<p>Robert</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Robert Seyfriedsberger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/html-sitemap-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"HTML Sitemap\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/html-sitemap-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Aug 2022 11:56:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:995:\"
						
						<p>Replies: 1</p>
						<p>Hi,<br />
I have submitted .xml sitemap (example.com/sitemap.xml) to Google Search Console.<br />
Do I need to submit .html sitemap (example.com/sitemap.html) to Google too?</p>


<ul id=\"bbp-topic-revision-log-15927870\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-15927870-item-15927880\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 2 months, 1 week ago by <a href=\"https://wordpress.org/support/users/rockstaremperor/\" title=\"View rockstaremperor&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">rockstaremperor</span></a>.
	</li>
	<li id=\"bbp-topic-revision-log-15927870-item-15927882\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 2 months, 1 week ago by <a href=\"https://wordpress.org/support/users/rockstaremperor/\" title=\"View rockstaremperor&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">rockstaremperor</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"rockstaremperor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/support/topic/error-v4-1-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Error V4.1.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/support/topic/error-v4-1-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Aug 2022 05:48:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1191:\"
						
						<p>Replies: 1</p>
						<p>[16-Aug-2022 11:33:26 UTC] PHP Warning:  Cannot modify header information &#8211; headers already sent in /xxx/public_html/wp-content/plugins/google-sitemap-generator/sitemap-core.php on line 1937</p>
<p>Cơ sở dữ liệu của WordPress gặp lỗi You have an error in your SQL syntax; check the manual that corresponds to your MariaDB server version for the right syntax to use near &#8216;-&gt;posts} p WHERE p.post_status=&#8217;publish&#8221; at line 1 với truy vấn SELECT COUNT(*) FROM {$wpdb-&gt;posts} p WHERE p.post_status=&#8217;publish&#8217; yêu cầu bởi require(&#8216;wp-blog-header.php&#8217;), require_once(&#8216;wp-load.php&#8217;), require_once(&#8216;wp-config.php&#8217;), require_once(&#8216;wp-settings.php&#8217;), do_action(&#8216;wp_loaded&#8217;), WP_Hook-&gt;do_action, WP_Hook-&gt;apply_filters, _wp_cron, spawn_cron, include_once(&#8216;wp-cron.php&#8217;), do_action_ref_array(&#8216;sm_ping_daily&#8217;), WP_Hook-&gt;do_action, WP_Hook-&gt;apply_filters, GoogleSitemapGeneratorLoader::call_send_ping_daily, GoogleSitemapGenerator-&gt;send_ping_daily, GoogleSitemapGenerator-&gt;send_stats</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"macken\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/support/topic/include-sitemap-in-a-subdirectory/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Include sitemap in a subdirectory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/support/topic/include-sitemap-in-a-subdirectory/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 17 Aug 2022 06:12:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"
						
						<p>Replies: 1</p>
						<p>Hi, can advise how do I include my sitemap in a sub-directory? This is an example of what I am trying to achieve. Eg. <a href=\"https://myhost.com/sitemap.xml\" rel=\"nofollow ugc\">https://myhost.com/sitemap.xml</a> change to <a href=\"https://myhost.com/subdirectory/sitemap.xml\" rel=\"nofollow ugc\">https://myhost.com/subdirectory/sitemap.xml</a></p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"darylaurito\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/php-notice-220/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"PHP Notice\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/support/topic/php-notice-220/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 07 Aug 2022 19:04:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:427:\"
						
						<p>Replies: 3</p>
						<p>Wordpress 6.0.1<br />
PHP 7.4<br />
Google XML Sitemaps 4.1.5 </p>
<p>The same error message repeated numerous times in the &#8220;apache.error.log&#8221; file:</p>
<p><code>PHP message: PHP Notice:  Undefined property: GoogleSitemapGeneratorPage::$_url in /home/....../plugins/google-sitemap-generator/class-googlesitemapgeneratorstandardbuilder.php on line 746</code></p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"almendron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/support/topic/submitted-url-marked-noindex-28/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Submitted URL marked ‘noindex’\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/support/topic/submitted-url-marked-noindex-28/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 07 Aug 2022 06:33:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:216:\"
						
						<p>Replies: 4</p>
						<p>Got this message from Google Search console. </p>
<p>Says the sitemap.xml file cannot be indexed because it is marked ‘noindex’</p>
<p>Using Version 4.1.5</p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Ali.T.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/support/topic/error-in-sitemap-in-search-console/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Error in Sitemap in Search Console\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/support/topic/error-in-sitemap-in-search-console/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 31 Jul 2022 03:39:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:602:\"
						
						<p>Replies: 1</p>
						<p>Error is showing in search console sitemap and I&#8217;ve attached screenshot of that below. My whole website is not indexing. I have not changed a single thing on my website. Also it says the robot.txt file is missing. I have check the address of robot.txt of my website personally, it&#8217;s there untouched.<br />
Please help me as my website indexing is seriously down.<br />
<a href=\"https://ibb.co/v4SLfNG\" rel=\"nofollow ugc\">https://ibb.co/v4SLfNG</a><br />
<a href=\"https://ibb.co/Dfht5Qg\" rel=\"nofollow ugc\">https://ibb.co/Dfht5Qg</a></p>
						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"bepalabergetar90\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:67:\"
					
					
					
					
					

					
					

					
					
					
				\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/support/topic/error-1673/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Error in log\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/support/topic/error-1673/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 30 Jul 2022 13:45:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1101:\"
						
						<p>Replies: 1</p>
						<p>Hello<br />
I keep getting this line in my log file:</p>
<p>[30-Jul-2022 13:38:51 UTC] PHP Warning:  Use of undefined constant ddsg_language &#8211; assumed &#8216;ddsg_language&#8217; (this will throw an Error in a future version of PHP) in /home/&#8230;ova.ru/wp-content/plugins/sitemap-generator/sitemap-generator.php on line 45</p>


<ul id=\"bbp-topic-revision-log-15873393\" class=\"bbp-topic-revision-log\">

	<li id=\"bbp-topic-revision-log-15873393-item-15873412\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 2 months, 3 weeks ago by <a href=\"https://wordpress.org/support/users/alexdn/\" title=\"View alexdn&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">alexdn</span></a>.
	</li>
	<li id=\"bbp-topic-revision-log-15873393-item-15873416\" class=\"bbp-topic-revision-log-item\">
		This topic was modified 2 months, 3 weeks ago by <a href=\"https://wordpress.org/support/users/alexdn/\" title=\"View alexdn&#039;s profile\" class=\"bbp-author-link\"><span  class=\"bbp-author-name\">alexdn</span></a>.
	</li>

</ul>

						
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"alexdn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:67:\"https://wordpress.org/support/plugin/google-sitemap-generator/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 24 Oct 2022 12:50:27 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20201025013224\";}","no");
INSERT INTO `wp_options` VALUES ("1401214","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1663130968","no");
INSERT INTO `wp_options` VALUES ("1401227","_transient_is_multi_author","0","yes");
INSERT INTO `wp_options` VALUES ("1441824","_transient_timeout_feed_mod_d21d2a68bac70d38fb7f9a7bd3d1725e","1667220627","no");
INSERT INTO `wp_options` VALUES ("1441825","_transient_feed_mod_d21d2a68bac70d38fb7f9a7bd3d1725e","1666615827","no");
INSERT INTO `wp_options` VALUES ("1446613","_transient_timeout_8b1868c9a02cb93a3e5a2a5568913201","1667094849","no");
INSERT INTO `wp_options` VALUES ("1446614","_transient_8b1868c9a02cb93a3e5a2a5568913201","<div class=\'drs-item\'><img id=\"drs-item-img-neu-m043qk929\" src=\"https://repository.library.northeastern.edu/downloads/neu:m043qk94v?datastream_id=thumbnail_4\" class=\"replace_thumbs\"/><div id=\"drs-item-video-neu-m043qk929\"></div><script type=\"text/javascript\">
  jwplayer.key=\"6keHwedw4fQnScJOPJbFMey9UxSWktA1KWf1vIe5fGc=\";
  var primary = \"html5\";
  var provider = \"video\";
  var is_chrome = navigator.userAgent.indexOf(\'Chrome\') > -1;
  var is_safari = navigator.userAgent.indexOf(\"Safari\") > -1;
  if ((is_chrome)&&(is_safari)) {is_safari=false;}
  jQuery(document).ready(function($){
  $(\"#drs-item-img-neu-m043qk929\").hide();
  jwplayer(\"drs-item-video-neu-m043qk929\").setup({width: \"100%\",
        height: 400,
        rtmp: {bufferlength: 5},image: \"https://repository.library.northeastern.edu/downloads/neu:m043qk94v?datastream_id=thumbnail_4\",provider: \"video\",
    androidhls: \"true\",
    primary: primary,
    hlshtml: \"true\",
    aspectratio: \"16:9\",sources:
    [{ file: \"https://repository.library.northeastern.edu/wowza/neu:m043qk929/plain\", type:\"mp4\"},{ file: \"https://repository.library.northeastern.edu/wowza/neu:m043qk929/playlist.m3u8\"}
    ],
  });
  jwplayer(\"drs-item-video-neu-m043qk929\").on(\"ready\", function() {
   if (is_safari){
    // Set poster image for video element to avoid black background for audio-only programs.
    $(\"drs-item-video-neu-m043qk929 video\").attr(\"poster\", \"https://repository.library.northeastern.edu/downloads/neu:m043qk94v?datastream_id=thumbnail_4\");
   }
  });
  function errorMessage() {
    $(\"#drs-item-img-neu-m043qk929\").before(\"<div class=\'alert alert-warning\'>There was an issue playing this file. Please contact the site administrator.<br /><strong>Error Message:</strong> \"+e.message+\"</div>\");
    $(\"#drs-item-img-neu-m043qk929\").show();
    $(\"#drs-item-video-neu-m043qk929\").hide();
  }
  jwplayer(\"drs-item-video-neu-m043qk929\").on(\'error\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m043qk929\").on(\'setupError\', function(){
    errorMessage();
  });
  jwplayer(\"drs-item-video-neu-m043qk929\").on(\'buffer\', function() {
    theTimeout = setTimeout(function(e) {
      errorMessage(e);
    }, 5000);
  });
  jwplayer(\"drs-item-video-neu-m043qk929\").on(\"play\", function(){
     clearTimeout(theTimeout);
   });
   $(\".replace_thumbs\").click(function() {
     jwplayer(\"drs-item-video-neu-m043qk929\").play()
   })
  });</script><div class=\"hidden\">2019-02-06T20:19:25Z<br/>2020-12-15T21:21:18Z<br/>A<br/>CoreFile<br/>neu:f1881m42v<br/>{\"datastreams\":{\"RELS-EXT\":{\"dsLabel\":\"Fedora Object-to-Object Relationship Metadata\",\"dsVersionID\":\"RELS-EXT.2\",\"dsCreateDate\":\"2020-12-14T18:54:34Z\",\"dsState\":\"A\",\"dsMIME\":\"application/rdf+xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"X\",\"dsSize\":425,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881m42v+RELS-EXT+RELS-EXT.2\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"rightsMetadata\":{\"dsLabel\":null,\"dsVersionID\":\"rightsMetadata.4\",\"dsCreateDate\":\"2020-12-15T21:21:15Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":690,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881m42v+rightsMetadata+rightsMetadata.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"DC\":{\"dsLabel\":\"Dublin Core Record for this object\",\"dsVersionID\":\"DC.9\",\"dsCreateDate\":\"2020-12-15T21:21:18Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":\"http://www.openarchives.org/OAI/2.0/oai_dc/\",\"dsControlGroup\":\"X\",\"dsSize\":958,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881m42v+DC+DC.9\",\"dsLocationType\":null,\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"properties\":{\"dsLabel\":null,\"dsVersionID\":\"properties.7\",\"dsCreateDate\":\"2020-12-14T18:54:34Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":718,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881m42v+properties+properties.7\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"},\"mods\":{\"dsLabel\":null,\"dsVersionID\":\"mods.4\",\"dsCreateDate\":\"2020-12-15T21:21:16Z\",\"dsState\":\"A\",\"dsMIME\":\"text/xml\",\"dsFormatURI\":null,\"dsControlGroup\":\"M\",\"dsSize\":2264,\"dsVersionable\":true,\"dsInfoType\":null,\"dsLocation\":\"neu:f1881m42v+mods+mods.4\",\"dsLocationType\":\"INTERNAL_ID\",\"dsChecksumType\":\"DISABLED\",\"dsChecksum\":\"none\"}},\"objLabel\":null,\"objOwnerId\":\"fedoraAdmin\",\"objModels\":[\"info:fedora/fedora-system:FedoraObject-3.0\",\"info:fedora/afmodel:CoreFile\"],\"objCreateDate\":\"2019-02-06T20:19:25Z\",\"objLastModDate\":\"2020-12-15T21:21:18Z\",\"objDissIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Af1881m42v/methods/fedora-system%3A3/viewMethodIndex\",\"objItemIndexViewURL\":\"http://localhost:8080/fedora/objects/neu%3Af1881m42v/methods/fedora-system%3A3/viewItemIndex\",\"objState\":\"A\"}<br/>northeastern:drs:repository:staff<br/>northeastern:drs:library:dmc_studios<br/>public<br/>000127586<br/>neu:gm80mq77m<br/>neu:gm80mq77m<br/>000127586<br/>000127586<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_1<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_2<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_3<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_4<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_5<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_1<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_2<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_3<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_4<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_5<br/>VideoFile<br/>VideoFile<br/>neu:gm80mq77m<br/>000127586<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_1<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_2<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_3<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_4<br/>/downloads/neu:m043qk94v?datastream_id=thumbnail_5<br/>VideoFile<br/>Video Production Episode 1<br/>Video Production Episode 1<br/>Video Production Episode 1<br/>Video Production Episode 1<br/>Part one in a helpful tutorial series.<br/>Video production<br/>Recording Studios<br/>Snell Library<br/>Video production<br/>Recording Studios<br/>Snell Library<br/>http://hdl.handle.net/2047/D20298558<br/>http://hdl.handle.net/2047/D20298558<br/>Video production<br/>Recording Studios<br/>Snell Library<br/>Video Production Episode 1<br/>Video Production Episode 1<br/>video production episode 000001<br/>Video Production Episode 1<br/>Video production<br/>Banrey, Antonio<br/>Banrey, Antonio<br/>Banrey, Antonio<br/>info:fedora/afmodel:CoreFile<br/>info:fedora/neu:gm80mq77m<br/>2020-12-15T21:21:44.903Z<br/></div></div>","no");


CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1791 DEFAULT CHARSET=utf8;

INSERT INTO `wp_postmeta` VALUES ("39","6","_edit_lock","1622034042:15");
INSERT INTO `wp_postmeta` VALUES ("40","6","_edit_last","15");
INSERT INTO `wp_postmeta` VALUES ("41","6","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES ("42","17","_edit_lock","1562684237:15");
INSERT INTO `wp_postmeta` VALUES ("43","17","_edit_last","11");
INSERT INTO `wp_postmeta` VALUES ("44","17","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES ("45","5","_edit_lock","1472672161:3");
INSERT INTO `wp_postmeta` VALUES ("53","23","_edit_last","15");
INSERT INTO `wp_postmeta` VALUES ("54","23","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES ("55","23","_edit_lock","1563377000:15");
INSERT INTO `wp_postmeta` VALUES ("56","26","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES ("57","26","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES ("58","26","_menu_item_object_id","23");
INSERT INTO `wp_postmeta` VALUES ("59","26","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES ("60","26","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES ("61","26","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES ("62","26","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES ("63","26","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES ("65","27","_menu_item_type","post_type");
INSERT INTO `wp_postmeta` VALUES ("66","27","_menu_item_menu_item_parent","0");
INSERT INTO `wp_postmeta` VALUES ("67","27","_menu_item_object_id","17");
INSERT INTO `wp_postmeta` VALUES ("68","27","_menu_item_object","page");
INSERT INTO `wp_postmeta` VALUES ("69","27","_menu_item_target","");
INSERT INTO `wp_postmeta` VALUES ("70","27","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES ("71","27","_menu_item_xfn","");
INSERT INTO `wp_postmeta` VALUES ("72","27","_menu_item_url","");
INSERT INTO `wp_postmeta` VALUES ("75","17","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:7:{s:5:\"title\";s:28:\"2018 - 2019 Audio Collection\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"eb5fd7f2-1f18-4ce8-b178-fa68b9a0dd5b\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:12:\"text-1710000\";s:11:\"option_name\";s:11:\"widget_text\";}i:1;a:7:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"[drstk_tile id=\"neu:cj82sz05q\" tile-type=\"pinterest-hover\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"e17dc3d1-b078-41a5-bee7-48c108e0435e\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:28:\"black-studio-tinymce-1710001\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";}i:2;a:7:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:8:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:12:\"text-1710002\";s:11:\"option_name\";s:11:\"widget_text\";}i:3;a:7:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:188:\"[drstk_tile id=\"neu:cj82r264b,neu:cj82r2632,neu:cj82r265m\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:28:\"black-studio-tinymce-1710003\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";}i:4;a:7:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:8:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:12:\"text-1710004\";s:11:\"option_name\";s:11:\"widget_text\";}i:5;a:7:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:28:\"black-studio-tinymce-1710005\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";}}s:5:\"grids\";a:10:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:2;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:6;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:7;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:8;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:9;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:15:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:8;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:13;a:4:{s:4:\"grid\";i:8;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:14;a:4:{s:4:\"grid\";i:9;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("250","149","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:260:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("283","168","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:196:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in the audio studios located on the second floor.\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:181:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/3d-printing\">3D Printing</a></p>

These molds were created in the DMC 3D studios.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("78","39","panels_data","a:3:{s:7:\"widgets\";a:3:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:256:\"[drstk_tiles id=\"neu:rx918154k, neu:rx918365h, neu:rx9183647, neu:rx918359c, neu:rx918366s, neu:rx9183604, neu:rx918361d, neu:rx918362p\" type=\"pinterest-below\" metadata=\"full_title_ssi\" cell-width=\"200\" cell-height=\"200\" image-size=\"4\" text-align=\"center\"]\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:34:\"Test text for Blessing and a Curse\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:3:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.381966007907942717292115730742807500064373016357421875;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.61803399209205733821903550051501952111721038818359375;}}}");
INSERT INTO `wp_postmeta` VALUES ("249","148","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("125","63","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque non nunc lacus. Praesent eu dolor eget justo pretium ullamcorper bibendum nec felis. Nullam malesuada libero ipsum, sit amet interdum velit sagittis id. Aliquam elementum eu arcu vitae rutrum. Fusce in tincidunt sapien. Etiam tempor lobortis convallis. Aliquam felis purus, iaculis id augue quis, pharetra tempor mauris. Donec non sollicitudin neque, ut pharetra nunc. Maecenas imperdiet feugiat condimentum.

Phasellus fringilla mauris arcu, eu porttitor eros faucibus eget. Curabitur fringilla velit id enim posuere consectetur. Nullam fringilla molestie fringilla. Curabitur ut turpis eget dui congue pellentesque. Cras egestas mauris eget ex viverra pharetra in et libero. Nullam cursus suscipit nisl vitae bibendum. Morbi non est augue. In hac habitasse platea dictumst.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:6:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("85","43","panels_data","a:3:{s:7:\"widgets\";a:3:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:174:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Creator,Date created,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:6:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("81","40","panels_data","a:3:{s:7:\"widgets\";a:3:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:256:\"[drstk_tiles id=\"neu:rx918154k, neu:rx918365h, neu:rx9183647, neu:rx918359c, neu:rx918366s, neu:rx9183604, neu:rx918361d, neu:rx918362p\" type=\"pinterest-below\" metadata=\"full_title_ssi\" cell-width=\"200\" cell-height=\"200\" image-size=\"4\" text-align=\"center\"]\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:145:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}s:10:\"grid_cells\";a:3:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904196064098272245246334932744503021240234375;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095803935901727754753665067255496978759765625;}}}");
INSERT INTO `wp_postmeta` VALUES ("84","42","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:256:\"[drstk_tiles id=\"neu:rx918154k, neu:rx918365h, neu:rx9183647, neu:rx918359c, neu:rx918366s, neu:rx9183604, neu:rx918361d, neu:rx918362p\" type=\"pinterest-below\" metadata=\"full_title_ssi\" cell-width=\"200\" cell-height=\"200\" image-size=\"4\" text-align=\"center\"]\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:174:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("83","41","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:256:\"[drstk_tiles id=\"neu:rx918154k, neu:rx918365h, neu:rx9183647, neu:rx918359c, neu:rx918366s, neu:rx9183604, neu:rx918361d, neu:rx918362p\" type=\"pinterest-below\" metadata=\"full_title_ssi\" cell-width=\"200\" cell-height=\"200\" image-size=\"4\" text-align=\"center\"]\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:145:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:174:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("124","17","_panels_data_preview","a:3:{s:7:\"widgets\";a:2:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:165:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:260:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("88","45","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:174:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque non nunc lacus. Praesent eu dolor eget justo pretium ullamcorper bibendum nec felis. Nullam malesuada libero ipsum, sit amet interdum velit sagittis id. Aliquam elementum eu arcu vitae rutrum. Fusce in tincidunt sapien. Etiam tempor lobortis convallis. Aliquam felis purus, iaculis id augue quis, pharetra tempor mauris. Donec non sollicitudin neque, ut pharetra nunc. Maecenas imperdiet feugiat condimentum.

Phasellus fringilla mauris arcu, eu porttitor eros faucibus eget. Curabitur fringilla velit id enim posuere consectetur. Nullam fringilla molestie fringilla. Curabitur ut turpis eget dui congue pellentesque. Cras egestas mauris eget ex viverra pharetra in et libero. Nullam cursus suscipit nisl vitae bibendum. Morbi non est augue. In hac habitasse platea dictumst.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}}}");
INSERT INTO `wp_postmeta` VALUES ("87","44","panels_data","a:3:{s:7:\"widgets\";a:3:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:174:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"hover\" image-size=\"4\" metadata=\"Title,Creator,Date created,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}}}");
INSERT INTO `wp_postmeta` VALUES ("89","46","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque non nunc lacus. Praesent eu dolor eget justo pretium ullamcorper bibendum nec felis. Nullam malesuada libero ipsum, sit amet interdum velit sagittis id. Aliquam elementum eu arcu vitae rutrum. Fusce in tincidunt sapien. Etiam tempor lobortis convallis. Aliquam felis purus, iaculis id augue quis, pharetra tempor mauris. Donec non sollicitudin neque, ut pharetra nunc. Maecenas imperdiet feugiat condimentum.

Phasellus fringilla mauris arcu, eu porttitor eros faucibus eget. Curabitur fringilla velit id enim posuere consectetur. Nullam fringilla molestie fringilla. Curabitur ut turpis eget dui congue pellentesque. Cras egestas mauris eget ex viverra pharetra in et libero. Nullam cursus suscipit nisl vitae bibendum. Morbi non est augue. In hac habitasse platea dictumst.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}}}");
INSERT INTO `wp_postmeta` VALUES ("251","152","_edit_lock","1495119126:3");
INSERT INTO `wp_postmeta` VALUES ("252","152","_edit_last","3");
INSERT INTO `wp_postmeta` VALUES ("253","153","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:121:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/\">3D Printing</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("91","49","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque non nunc lacus. Praesent eu dolor eget justo pretium ullamcorper bibendum nec felis. Nullam malesuada libero ipsum, sit amet interdum velit sagittis id. Aliquam elementum eu arcu vitae rutrum. Fusce in tincidunt sapien. Etiam tempor lobortis convallis. Aliquam felis purus, iaculis id augue quis, pharetra tempor mauris. Donec non sollicitudin neque, ut pharetra nunc. Maecenas imperdiet feugiat condimentum.

Phasellus fringilla mauris arcu, eu porttitor eros faucibus eget. Curabitur fringilla velit id enim posuere consectetur. Nullam fringilla molestie fringilla. Curabitur ut turpis eget dui congue pellentesque. Cras egestas mauris eget ex viverra pharetra in et libero. Nullam cursus suscipit nisl vitae bibendum. Morbi non est augue. In hac habitasse platea dictumst.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:6:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("92","6","_panels_data_preview","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:763:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.  Located in the Digital Media Commons (DMC) on Snell Library\'s second level, the 3D Printing Studio offers the resources of a full suite of 3D fabrication and modeling technologies to members of the Northeastern community: students (undergraduate and graduate), faculty, and staff. Whether it\'s classwork, research or a personal project, we can 3D print your model.
 
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:196:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in the audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:184:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that created for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:181:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/3d-printing\">3D Printing</a></p>

These molds were created in the DMC 3D studios.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("96","52","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:245:\"<div class=\"row\">[drstk_gallery id=\"neu:rx918154k, neu:rx918365h\" caption=\"on\" caption-align=\"center\" caption-position=\"absolute\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,personal_creators_tesim\"]</div><div class=\"row\"> </div>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"Homepage Slider\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:14:\"Home Page Text\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Audio</a></p>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("95","51","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:6:\"filter\";s:1:\"1\";s:4:\"text\";s:245:\"<div class=\"row\">[drstk_gallery id=\"neu:rx918154k, neu:rx918365h\" caption=\"on\" caption-align=\"center\" caption-position=\"absolute\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,personal_creators_tesim\"]</div><div class=\"row\"> </div>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"visual\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:31:\"SiteOrigin_Widget_Editor_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"Homepage Slider\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:14:\"Home Page Text\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:4:{s:5:\"title\";s:12:\"Audio Button\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Audio</a></p>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:4;a:4:{s:5:\"title\";s:12:\"Video Button\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.0997437413759116597855580721443402580916881561279296875;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.800512517248176624917732624453492462635040283203125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.0997437413759116597855580721443402580916881561279296875;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.332741967277744910003178802071488462388515472412109375;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.33451606544451017999364239585702307522296905517578125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.332741967277744910003178802071488462388515472412109375;}}}");
INSERT INTO `wp_postmeta` VALUES ("93","6","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:7:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:258:\"<p>[drstk_slider id=\"neu:cj82r264b,neu:rx918154k,neu:rx9183647\" image-size=\"3\" auto=\"on\" nav=\"on\" pager=\"on\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" transition=\"slide\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"black-studio-tinymce-610000\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";}i:1;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1098:\"&nbsp;

Welcome to the Recording Studios Showcase. These original audio and video works were produced by Northeastern students in the library’s studios and curated by its staff. Whether for class assignment or personal enrichment, these samples represent the diversity of creative talent on our campus.
<ul>
 	<li>For more information about the Studios, go to our <a href=\"http://library.northeastern.edu/services/recording-studios\">website</a>.</li>
 	<li>Register for a Recording Studios <a href=\"http://northeastern.libcal.com/\">workshop</a> to hone your audio and video skills.</li>
 	<li>To submit work produced in the Studios, review this <a href=\"https://repository.library.northeastern.edu/downloads/neu:m043gs93m?datastream_id=content\">criteria</a> and use this <a href=\"http://library.northeastern.edu/services/digital-media-commons-studios/submit-your-project-to-our-studio-showcase\">form.</a></li>
 	<li>For further questions, please contact Jon Reed, Digital Media and Audio Production Specialist: <a href=\"mailto:d.jo.reedl@northeastern.edu\">jo.reed@northeastern.edu</a>.</li>
</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:11:\"text-610001\";s:11:\"option_name\";s:11:\"widget_text\";}i:2;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:185:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Recording Studios Audio</a></p>

These are songs created in the audio studios.\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:11:\"text-610002\";s:11:\"option_name\";s:11:\"widget_text\";}i:3;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:212:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Listen and View Class Projects</a></p>

These are audio and video projects created for class assignments.\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:11:\"text-610003\";s:11:\"option_name\";s:11:\"widget_text\";}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.8005125172481799555868064999231137335300445556640625;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:2;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("97","53","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Audio</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("98","23","_panels_data_preview","a:3:{s:7:\"widgets\";a:6:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"9a5b03f6-3198-4b1a-a4aa-7d6b80506ff1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1299:\"</br>
The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"91c76fa0-53ed-4114-8156-d95500ad4336\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:186:\"<p>[drstk_single id=\"neu:cj82nh78v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"a8b30416-4f1c-487b-8ab0-eab2e7a81db9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:562:\"</br>
Drawing influences from both modern indie, as well as the tried and true formulas of old time-y folk and country western, Musket\'s music is both familiar and fresh all at once. The incorporation of the classic and largely forgotten folk instru- ment, the autoharp, in conjunction with whimsi- cal songwriting gives Little Musket her trade- mark dark, yet playful sound, creating a genre she likes to call \"Melancountry\" Little Musket released her debut EP of live songs in October 2015. Follow the journey on Facebook, and watch for new music on Band camp.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"09cb10b0-9f49-4a29-90c7-7e3bec23d2b0\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"17ec6f64-4a1c-4282-8ca7-c46adb7bcf85\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:731:\"</br>
Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"70246a07-896d-4134-a833-4979005e771e\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:6:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("99","23","panels_data","a:3:{s:7:\"widgets\";a:17:{i:0;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:1293:\"<h3><strong>Course: LARC 2340 Cities, Landscape, and Contemporary Culture
Professor: Nick Brown
Semester: Spring 2018, Fall 2018, Spring 2019</strong></h3>
<strong>Assignment:</strong>

\"Landscape Dialogues\" an original production by Northeastern’s Cities, Landscape, and Contemporary Culture class taught by instructor Nicholas Brown. This podcast is an introduction into some of today’s most influential landscape architects, designers, firms, and theorists, all within the context of the many different projects, communities, and ideologies they are responsible for shaping. These discussions shed light on current and futures trends in the field of landscape architecture, calling specific attention to the personal declarations presented in the Landscape Architecture Foundation’s summit that took place two years ago. The summit gathered all the major leaders within the field to reflect on the last half-century of landscape design and present bold ideas for the future. So throughout this podcast we will explore these landscape architects. We will look at the role that they play in developing and modernizing the ways that we interact with space. These podcasts present viable examples of the work that they have done and usher in conversation regarding their work and impact.\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310000\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6d723f6a-2cb7-40df-940c-3fcfdbd4f91a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310000\";}i:1;a:8:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"[drstk_tile id=\"neu:cj82r939f,neu:cj82r9406,neu:cj82r941g\" tile-type=\"pinterest-hover\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]

&nbsp
<hr>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310001\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"becabe8e-a032-44ec-be04-54927923a386\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310001\";}i:2;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:1274:\"<h3><strong>Course: AFAM 1225 16350 Gender, Race, and Medicine</strong>
<strong>Professor: Moya Bailey</strong>
<strong>Semester:  Fall 2017</strong></h3>
<strong>Assignment:</strong>
<div class=\"page\" title=\"Page 1\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">

Student pairs will produce a 6-10 minute podcast episode on a topic of their choosing related to the class content. Possible topics include but are not limited to:</div>
</div>
</div>
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<ul>
 	<li>Water quality in Boston neighborhoods</li>
 	<li>Environmental racism in Boston</li>
 	<li>Different framing of “crack babies” and “opioid dependent newborns”</li>
 	<li>Race and gender in medical schools</li>
 	<li>Race and gender in different medical professions</li>
 	<li>Health care disparities by region, age, ability, race etc.</li>
</ul>
</div>
</div>
</div>
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">

Student pairs are encouraged to be creative with the podcast – to have fun, and find ways to provide an informative and entertaining podcast. Students are encouraged to interview experts on the topic, and find other content to bring into the podcast.</div>
</div>
</div>
</div>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310002\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"e9f967a4-1a8d-43d6-a987-f65dd65ba988\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310002\";}i:3;a:8:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"[drstk_tile id=\"neu:cj82qp53c,neu:cj82qp477,neu:cj82qp55x\" tile-type=\"pinterest-hover\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]

&nbsp
<hr>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310003\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"f605c602-2ffb-40a0-9d92-032166301262\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310003\";}i:4;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:700:\"<h3><strong>Course: The Record Industry MUSI 3333</strong>
<strong>Professor: David Herlihy</strong>
<strong>Semester: Spring 2015, Spring 2019</strong></h3>
<strong>Assignment:</strong>

The Groups will produce a video of the Master recording and post it on the web (e.g., youTube and the Artist’s site). The process of producing the video will include working with the artist, developing a “concept”, including assessing different esthetic approaches to determine what works best for the artist/recording (e.g., black and white, abstract, performance video, etc…), storyboarding, creating b-rolls, scheduling shoot(s), post production and editing a finished version of the completed video.\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310004\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"6589be5e-1438-4f6d-b7f1-7a66762e541d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310004\";}i:5;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Flash Paper\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px10v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310005\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"572d6eb2-985a-4110-8dbd-cf75be444ba1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310005\";}i:6;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:341:\"</br>
</br>
</br>
Build iT! is a Boston based punk band who love being sad, big beautiful penguins and sometimes writing banger tunes. It has been heavily rumored that this band does indeed play music, but there is still research to be done. There are currently four members of the band, but they are willing and open to add a third member. \";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310006\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"049bdb53-a36c-4383-9cae-cf733357bf2c\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310006\";}i:7;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Kaleidoscope\";s:4:\"text\";s:208:\"<p>[drstk_single id=\"neu:cj82px093\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310007\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"06cc7215-eecc-40fe-8ae0-65ffda4516eb\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310007\";}i:8;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:474:\"</br>
</br>
</br>
	The artist we’ve chosen to work with is a rapper named Tirelle Barron who releases music under the moniker The Noise Above. Tirelle’s style is an intellectual blend of lyricism and low-key funk and jazz-inspired beats which are complex yet accessible. His work is uniquely personal as he creates and produces all of his own beats and writes deeply introspective lyrics regarding personal experience, perspective, and growth through various struggles.
\";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310008\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"0eea7bd5-9cfa-4e14-bc62-9b3b70782291\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310008\";}i:9;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Jelly Apple\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px08t\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310009\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:7;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"c2802957-0c83-4fad-bd3c-9661e1d58519\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310009\";}i:10;a:8:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:466:\"</br>
</br>
</br>
Singer-songwriter Mike Orent is set to break into the Boston music scene with his “sad folk / twinkly emo” catalogue. Orent began playing the guitar over a decade ago and hasn’t been able to put it down since. 
Drawing inspiration and influence from a variety of artists such as Elvis Costello, The Smiths, Pile, Elliot Smith, and Saves The Day, you are sure to be moved after hearing the honest lyrics and impressive vocals Mike offers up. 
\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:2:\"id\";s:12:\"text-2310010\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:7;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"39fb2013-aeac-4017-9be5-91c1702e7c25\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310010\";}i:11;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:161:\"[drstk_single id=\"neu:cj82kh556\" image-size=\"4\" display-video=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom-position=\"1\"]\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310011\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:8;s:4:\"cell\";i:0;s:2:\"id\";i:11;s:9:\"widget_id\";s:36:\"1c04785c-3d43-46c6-b516-308259ccce2f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310011\";}i:12;a:8:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:582:\"</br>
The Ryan Martin Band is an Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. \";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:2:\"id\";s:12:\"text-2310012\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:8;s:4:\"cell\";i:1;s:2:\"id\";i:12;s:9:\"widget_id\";s:36:\"5f235ad2-84c8-452a-8eba-8b9eabc250ee\";s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"25px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310012\";}i:13;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:186:\"<p>[drstk_single id=\"neu:cj82nh78v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310013\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:9;s:4:\"cell\";i:0;s:2:\"id\";i:13;s:9:\"widget_id\";s:36:\"a8b30416-4f1c-487b-8ab0-eab2e7a81db9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310013\";}i:14;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:562:\"</br>
Drawing influences from both modern indie, as well as the tried and true formulas of old time-y folk and country western, Musket\'s music is both familiar and fresh all at once. The incorporation of the classic and largely forgotten folk instru- ment, the autoharp, in conjunction with whimsi- cal songwriting gives Little Musket her trade- mark dark, yet playful sound, creating a genre she likes to call \"Melancountry\" Little Musket released her debut EP of live songs in October 2015. Follow the journey on Facebook, and watch for new music on Band camp.\";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310014\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:9;s:4:\"cell\";i:1;s:2:\"id\";i:14;s:9:\"widget_id\";s:36:\"09cb10b0-9f49-4a29-90c7-7e3bec23d2b0\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310014\";}i:15;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:17:\"All I Had to Give\";s:4:\"text\";s:192:\"[drstk_single id=\"neu:cj82kv92d\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310015\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:10;s:4:\"cell\";i:0;s:2:\"id\";i:15;s:9:\"widget_id\";s:36:\"20e0559e-a21c-468f-b11c-4ff511352d17\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:28:\"black-studio-tinymce-2310015\";}i:16;a:8:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:471:\"</br>
Blindspot is a female-fronted indie rock band from Boston, MA. They have been influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. Blindspot has opened for Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. \";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:2:\"id\";s:12:\"text-2310016\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:10;s:4:\"cell\";i:1;s:2:\"id\";i:16;s:9:\"widget_id\";s:36:\"09d614dd-69ef-4cb0-b8de-9b4145336800\";s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"25px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:12:\"text-2310016\";}}s:5:\"grids\";a:11:{i:0;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:2;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:3;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:4;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:7;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:8;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:9;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:10;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:17:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:8;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:8;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:13;a:4:{s:4:\"grid\";i:9;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:14;a:4:{s:4:\"grid\";i:9;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:15;a:4:{s:4:\"grid\";i:10;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:16;a:4:{s:4:\"grid\";i:10;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("104","56","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Bee Charmer\";s:4:\"text\";s:162:\"<p>[drstk_collection_playlist id=\"neu:cj82kv87j, neu:cj82kv92d, neu:cj82kh556, neu:cj82kv93p, neu:cj82kv87j, neu:cj82kh556, neu:cj82kv93p\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("103","55","panels_data","a:3:{s:7:\"widgets\";a:1:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:145:\"<p style=\"text-align: center;\">[drstk_collection_playlist id=\"neu:cj82kv92d, neu:cj82kv87j, neu:cj82kh556, neu:cj82kv93p\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}}}");
INSERT INTO `wp_postmeta` VALUES ("106","57","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Bee Charmer\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv87j\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("263","161","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:132:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/3d-printing\">3D Printing</a></p>\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("261","160","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:186:\"<p>[drstk_single id=\"neu:cj82ng34k\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"45b87106-5754-4cca-b36b-2d0eeb7b0c04\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"</br>
I wanted to create a capstone project that reflected the culmination of skills I developed during my time at northeastern. Thus I chose to create a 3D character in the 3D sculpting software Zbrush. While creating my character I realized I was not succeeding in that aspiration as a big part of my experience at northeastern was working in the theater department costume shop sewing clothing. So I decided to do a side project where I would create a physical representation of my character using 3D printing. I split the body of my character in parts; head, torso, upper arm, lower arm, upper leg, lower leg. And worked with the 3D printing studio staff to print each individual part. Then I strung the parts together with elastic and voila! I had something similar to a barbie doll that I could proceed to paint and sew clothing for. \";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"29270e4d-2a3c-4a78-8228-6d452e9c9c6d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("108","58","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Bee Charmer\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv87j\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:74:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("111","60","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:158:\"<p>[drstk_item id=\"neu:cj82kv92d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:16:\"insert text here\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("109","59","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv87j\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:16:\"insert text here\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("236","138","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:366:\"<p>[drstk_tileid=\"neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918362p,neu:rx918361d,neu:rx918365h,neu:rx918154k\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("142","74","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("140","72","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1293:\"The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"30px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:725:\"Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("135","69","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1293:\"The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:725:\"Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("118","61","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Audio</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:120:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:121:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/\">3D Printing</a></p>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("257","152","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:58:\"[drstk_media id=\"neu:cj82ng34k\" height=\"270\" width=\"100%\"]\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"66f649d8-6291-409d-9843-9c49b3e1d991\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"</br>
I wanted to create a capstone project that reflected the culmination of skills I developed during my time at northeastern. Thus I chose to create a 3D character in the 3D sculpting software Zbrush. While creating my character I realized I was not succeeding in that aspiration as a big part of my experience at northeastern was working in the theater department costume shop sewing clothing. So I decided to do a side project where I would create a physical representation of my character using 3D printing. I split the body of my character in parts; head, torso, upper arm, lower arm, upper leg, lower leg. And worked with the 3D printing studio staff to print each individual part. Then I strung the parts together with elastic and voila! I had something similar to a barbie doll that I could proceed to paint and sew clothing for. \";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"29270e4d-2a3c-4a78-8228-6d452e9c9c6d\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("537","268","panels_data","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:58:\"[drstk_media id=\"neu:cj82ng34k\" height=\"270\" width=\"100%\"]\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"66f649d8-6291-409d-9843-9c49b3e1d991\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"</br>
I wanted to create a capstone project that reflected the culmination of skills I developed during my time at northeastern. Thus I chose to create a 3D character in the 3D sculpting software Zbrush. While creating my character I realized I was not succeeding in that aspiration as a big part of my experience at northeastern was working in the theater department costume shop sewing clothing. So I decided to do a side project where I would create a physical representation of my character using 3D printing. I split the body of my character in parts; head, torso, upper arm, lower arm, upper leg, lower leg. And worked with the 3D printing studio staff to print each individual part. Then I strung the parts together with elastic and voila! I had something similar to a barbie doll that I could proceed to paint and sew clothing for. \";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"29270e4d-2a3c-4a78-8228-6d452e9c9c6d\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("258","152","_panels_data_preview","a:3:{s:7:\"widgets\";a:2:{i:0;a:5:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:58:\"[drstk_media id=\"neu:cj82ng34k\" height=\"270\" width=\"100%\"]\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"66f649d8-6291-409d-9843-9c49b3e1d991\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:840:\"</br>
I wanted to create a capstone project that reflected the culmination of skills I developed during my time at northeastern. Thus I chose to create a 3D character in the 3D sculpting software Zbrush. While creating my character I realized I was not succeeding in that aspiration as a big part of my experience at northeastern was working in the theater department costume shop sewing clothing. So I decided to do a side project where I would create a physical representation of my character using 3D printing. I split the body of my character in parts; head, torso, upper arm, lower arm, upper leg, lower leg. And worked with the 3D printing studio staff to print each individual part. Then I strung the parts together with elastic and voila! I had something similar to a barbie doll that I could proceed to paint and sew clothing for. \";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"29270e4d-2a3c-4a78-8228-6d452e9c9c6d\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:2:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("176","5","_edit_last","2");
INSERT INTO `wp_postmeta` VALUES ("177","5","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES ("235","137","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918359c,neu:rx918366s,neu:rx9183604,neu:rx918362p,neu:rx918361d,neu:rx918365h,neu:rx918154k\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("127","64","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:6:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("282","167","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:181:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/3d-printing\">3D Printing</a></p>

These molds were created in the DMC 3D studios.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("246","146","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("234","136","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:516:\"<p>[drstk_tile id=\"neu:rx918359c,neu:rx918366s,neu:rx9183604,neu:rx918362p,neu:rx918361d,neu:rx918365h,neu:rx918154k\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p>neu:rx918361d\" tile-type=\"pinterest-below\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("233","135","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:265:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p>neu:rx918361d\" tile-type=\"pinterest-below\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("208","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("242","143","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p,neu:rx918361d\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("129","65","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("141","73","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1299:\"</br>
The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"25px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:725:\"Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("131","66","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:32:\"JOFJOJOFJDOFJDOFJDOFJODFJODFJOJF\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:16:\"insert text here\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("137","70","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1298:\"




The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:725:\"Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("133","67","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1293:\"The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:16:\"insert text here\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("1275","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("231","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("148","76","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("207","121","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"bc571a53-777a-421f-951b-ab7124fb98c2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"6692ddc9-d319-4ec1-b0b7-2b7d9bb6984a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:188:\"<p>[drstk_single id=\"neu:rx9183647\" image-size=\"2\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"center\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"9cded855-ae84-4d44-9048-2790adedb3e6\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:6:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";i:1;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("152","78","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("150","77","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:25:\"Blessing and a Curse test\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 2\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:6:\"Part 3\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:3;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.25;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.25;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.25;}i:3;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.25;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.49987837904195997484890767736942507326602935791015625;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.50012162095804002515109232263057492673397064208984375;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("229","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("1274","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("232","134","panels_data","a:3:{s:7:\"widgets\";a:12:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:202:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647\" tile-type=\"pinterest-below\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"bc571a53-777a-421f-951b-ab7124fb98c2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"6692ddc9-d319-4ec1-b0b7-2b7d9bb6984a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:167:\"<p>[drstk_single id=\"neu:rx9183647\" image-size=\"2\" display-issuu=\"true\" align=\"center\" caption-align=\"center\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"9cded855-ae84-4d44-9048-2790adedb3e6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:11;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:11;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("230","133","panels_data","a:3:{s:7:\"widgets\";a:12:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:202:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647\" tile-type=\"pinterest-below\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"bc571a53-777a-421f-951b-ab7124fb98c2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"6692ddc9-d319-4ec1-b0b7-2b7d9bb6984a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:167:\"<p>[drstk_single id=\"neu:rx9183647\" image-size=\"2\" display-issuu=\"true\" align=\"center\" caption-align=\"center\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"9cded855-ae84-4d44-9048-2790adedb3e6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:11;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:11;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("155","80","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:175:\"<p>&lt;/br&gt;</p><p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:186:\"<p>&lt;/br&gt;</p><p>[drstk_item id=\"neu:rx9183647\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("154","79","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:165:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("156","81","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:175:\"<p>&lt;br/&gt;</p><p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:186:\"<p>&lt;br/&gt;</p><p>[drstk_item id=\"neu:rx9183647\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("157","82","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:1:\" \";s:4:\"text\";s:157:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:1:\" \";s:4:\"text\";s:168:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"center\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("241","142","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918361d,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918362p,neu:rx918361d\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("164","88","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:56:\"<h5>Bruno Gaucho, A Blessing and a Curse, Parts 1-3</h5>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:9:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:8;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("160","84","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:4:{s:5:\"title\";s:20:\"Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:2;a:4:{s:5:\"title\";s:9:\"Parts 1-3\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("159","83","panels_data","a:3:{s:7:\"widgets\";a:8:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Bruno Gaucho\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:2;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:8:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}i:7;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("161","85","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:9:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:8;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("162","86","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:56:\"<h1>Bruno Gaucho, A Blessing and a Curse, Parts 1-3</h1>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:9:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:8;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("163","87","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:56:\"<h3>Bruno Gaucho, A Blessing and a Curse, Parts 1-3</h3>\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:9:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:8;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("175","98","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:166:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("168","92","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:196:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("165","89","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:4:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:9:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}i:8;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("167","91","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:196:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("166","90","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:198:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource,Format,Subjects and keywords\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("169","93","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("170","94","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2.5\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("171","95","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("172","96","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"3\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("213","124","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:121:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/\">3D Printing</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("174","97","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:169:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"center\" caption-position=\"below\" image-size=\"4\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("179","106","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:47:\"Bruno Gaucho, A Blessing and a Curse, Parts 1-3\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("1546","656","panels_data","a:3:{s:7:\"widgets\";a:14:{i:0;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:554:\"David Herlihy Music

Assignment:

The Groups will produce a video of the Master recording and post it on the web (e.g., youTube and the Artist’s site). The process of producing the video will include working with the artist, developing a “concept”, including assessing different esthetic approaches to determine what works best for the artist/recording (e.g., black and white, abstract, performance video, etc…), storyboarding, creating b-rolls, scheduling shoot(s), post production and editing a finished version of the completed video;

&nbsp;\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"cfb5a72b-12fc-4d11-8828-e34358d3d686\";s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:36:\"background_image_attachment_fallback\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Flash Paper\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px10v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"572d6eb2-985a-4110-8dbd-cf75be444ba1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:341:\"</br>
</br>
</br>
Build iT! is a Boston based punk band who love being sad, big beautiful penguins and sometimes writing banger tunes. It has been heavily rumored that this band does indeed play music, but there is still research to be done. There are currently four members of the band, but they are willing and open to add a third member. \";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"049bdb53-a36c-4383-9cae-cf733357bf2c\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Kaleidoscope\";s:4:\"text\";s:208:\"<p>[drstk_single id=\"neu:cj82px093\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"06cc7215-eecc-40fe-8ae0-65ffda4516eb\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:474:\"</br>
</br>
</br>
	The artist we’ve chosen to work with is a rapper named Tirelle Barron who releases music under the moniker The Noise Above. Tirelle’s style is an intellectual blend of lyricism and low-key funk and jazz-inspired beats which are complex yet accessible. His work is uniquely personal as he creates and produces all of his own beats and writes deeply introspective lyrics regarding personal experience, perspective, and growth through various struggles.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"0eea7bd5-9cfa-4e14-bc62-9b3b70782291\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Jelly Apple\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px08t\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"c2802957-0c83-4fad-bd3c-9661e1d58519\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:968:\"</br>
</br>
</br>
Hailing from Westport, Connecticut, singer-songwriter Mike Orent is set to break into the Boston music scene with his self proclaimed “sad folk / twinkly emo” catalogue. Orent began playing the guitar over a decade ago and hasn’t been able to put it down since. You can tell when he plays that his instrument is organically a part of him and that his comfortability with it has contributed to the conception of his several earnest, sincere, and wholehearted refrains. 

Drawing inspiration and influence from a variety of artists such as Elvis Costello, The Smiths, Pile, Elliot Smith, and Saves The Day, you are sure to be moved after hearing the honest lyrics and impressive vocals Mike offers up. Although this is Orents first solo project outside of his Alt-Rock band “Pennies In The Couch”, his songs, especially Connect The Locks and Jelly Apple, tug at the heartstrings of listeners, showcasing his vulnerability and dynamic range. 
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"39fb2013-aeac-4017-9be5-91c1702e7c25\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"9a5b03f6-3198-4b1a-a4aa-7d6b80506ff1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1299:\"</br>
The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"91c76fa0-53ed-4114-8156-d95500ad4336\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:186:\"<p>[drstk_single id=\"neu:cj82nh78v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"a8b30416-4f1c-487b-8ab0-eab2e7a81db9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:562:\"</br>
Drawing influences from both modern indie, as well as the tried and true formulas of old time-y folk and country western, Musket\'s music is both familiar and fresh all at once. The incorporation of the classic and largely forgotten folk instru- ment, the autoharp, in conjunction with whimsi- cal songwriting gives Little Musket her trade- mark dark, yet playful sound, creating a genre she likes to call \"Melancountry\" Little Musket released her debut EP of live songs in October 2015. Follow the journey on Facebook, and watch for new music on Band camp.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"09cb10b0-9f49-4a29-90c7-7e3bec23d2b0\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}i:11;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:11;s:9:\"widget_id\";s:36:\"17ec6f64-4a1c-4282-8ca7-c46adb7bcf85\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:12;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:12;s:9:\"widget_id\";s:36:\"eabee72a-3d75-465c-ad3e-f6389dbcd9dc\";s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:36:\"background_image_attachment_fallback\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:13;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:731:\"</br>
Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:13;s:9:\"widget_id\";s:36:\"70246a07-896d-4134-a833-4979005e771e\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:4:{s:5:\"cells\";i:1;s:5:\"style\";a:4:{s:27:\"background_image_attachment\";b:0;s:36:\"background_image_attachment_fallback\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:3;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("1631","698","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:258:\"<p>[drstk_slider id=\"neu:cj82r264b,neu:rx918154k,neu:rx9183647\" image-size=\"3\" auto=\"on\" nav=\"on\" pager=\"on\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" transition=\"slide\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1130:\"&nbsp;

Welcome to the Recording Studios Showcase. These original audio and video works were produced by Northeastern students in the library’s studios and curated by its staff. Whether for class assignment or personal enrichment, these samples represent the diversity of creative talent on our campus.
<ul>
 	<li>For more information about the Studios, go to our <a href=\"http://library.northeastern.edu/services/recording-studios\">website</a>.</li>
 	<li>Register for a Recording Studios <a href=\"http://northeastern.libcal.com/\">workshop</a> to hone your audio and video skills.</li>
 	<li>To submit work produced in the Studios, review this <a href=\"https://library.northeastern.edu/sites/default/files/public/atttachments/FIELD_PAGE_FILES/2017/recording_studios_showcase_flyer_12_2018.pdf\">criteria</a> and use this <a href=\"http://library.northeastern.edu/services/digital-media-commons-studios/submit-your-project-to-our-studio-showcase\">form.</a></li>
 	<li>For further questions, contact Thomas Bary, Recordings Studio Digital Specialist: <a href=\"mailto:t.bary@northeastern.edu\">t.bary@northeastern.edu</a>.</li>
</ul>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:185:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Recording Studios Audio</a></p>

These are songs created in the audio studios.\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:6:\"visual\";b:0;s:5:\"title\";s:0:\"\";s:4:\"text\";s:199:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Listen and View Class Projects</a></p>

These are videos that created for class assignments.\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.8005125172481799555868064999231137335300445556640625;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:2;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("228","132","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:121:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/\">3D Printing</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"acb36f12-4bf4-4782-9462-2a4018f19aba\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("1272","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("212","123","panels_data","a:3:{s:7:\"widgets\";a:5:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:395:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Audio</a></p>

These are songs created in Snell Libraries audio studios located on the second floor.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:208:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">Video</a></p>

These are videos that are worked on in Snell Library for class, and personal projects.\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:4;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:121:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/\">3D Printing</a></p>\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:7:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.80051251724817673594003508696914650499820709228515625;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.0997437413759116042744068408865132369101047515869140625;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}i:5;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.334516065444513344129262577553163282573223114013671875;}i:6;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.332741967277743355690944326852331869304180145263671875;}}}");
INSERT INTO `wp_postmeta` VALUES ("209","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("183","107","panels_data","a:3:{s:7:\"widgets\";a:10:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:2;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:5:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:10:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}i:9;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("206","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("1273","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("185","108","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:153:\"<p>[drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:2;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:6:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";i:1;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("211","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("210","122","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"bc571a53-777a-421f-951b-ab7124fb98c2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"6692ddc9-d319-4ec1-b0b7-2b7d9bb6984a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:167:\"<p>[drstk_single id=\"neu:rx9183647\" image-size=\"2\" display-issuu=\"true\" align=\"center\" caption-align=\"center\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"9cded855-ae84-4d44-9048-2790adedb3e6\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:6:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";i:1;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("204","118","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:164:\"<p>[drstk_item id=\"neu:rx9183647\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:6:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";i:1;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("1276","546","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:165:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("205","119","panels_data","a:3:{s:7:\"widgets\";a:11:{i:0;a:4:{s:5:\"title\";s:35:\"Andrew Noll, A Blessing and a Curse\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:21:\"Bruno Rosa Part 1 & 2\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"bc571a53-777a-421f-951b-ab7124fb98c2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:4:\"    \";s:4:\"text\";s:155:\"<p> [drstk_item id=\"neu:rx918365h\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Permanent URL\"] </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"6692ddc9-d319-4ec1-b0b7-2b7d9bb6984a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:5:\"     \";s:4:\"text\";s:188:\"<p>[drstk_tile id=\"neu:rx9183647\" tile-type=\"pinterest-hover\" text-align=\"center\" cell-height=\"200\" cell-width=\"200\" image-size=\"2\" metadata=\"Title,Creator,Date created,Permanent URL\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"9cded855-ae84-4d44-9048-2790adedb3e6\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:1;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:2;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:9;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:10;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:6:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:11:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:3;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";i:1;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:7;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}i:10;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("237","139","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918362p,neu:rx918361d,neu:rx918365h,neu:rx918154k\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("238","140","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<p>[drstk_tile id=\"neu:rx918361d,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918362p,neu:rx918361d,neu:rx918154k\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("239","141","panels_data","a:3:{s:7:\"widgets\";a:9:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:353:\"<p>[drstk_tile id=\"neu:rx918361d,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918362p,neu:rx918361d\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:5:\"Sayeh\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"3d6c7573-c4f8-40a4-a85b-515ed1562b29\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918366s\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"f2adfb84-d896-4123-9694-19320a7f51d6\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918359c\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"946947d6-277a-4b55-bee6-7d12315c44ef\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:7;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:8;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("240","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("243","144","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:353:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("245","120","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:5:\"title\";s:28:\"2017 - 2018 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2017-2018 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"e4f15fc8-a0f8-4723-8a23-e3e77f77d037\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:78:\"<p>[drstk_media id=\"neu:cj82r264b,neu:cj82r265m\" height=\"270\" width=\"30%\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"be268004-d2a1-4c7e-b216-934b359a2e52\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:81:\"These are the audio tracks the studios have collected for the 2015-2016 semester.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:251:\"<p>[drstk_tile id=\"neu:rx918154k,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:8:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:3;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:4;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:7;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:2:{s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:13:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:3;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:6;a:4:{s:4:\"grid\";i:4;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:7;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:0;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:8;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:1;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:9;a:4:{s:4:\"grid\";i:5;s:5:\"index\";i:2;s:6:\"weight\";d:0.333333333333329984160542380777769722044467926025390625;s:5:\"style\";a:0:{}}i:10;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:11;a:4:{s:4:\"grid\";i:6;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:12;a:4:{s:4:\"grid\";i:7;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("244","145","panels_data","a:3:{s:7:\"widgets\";a:6:{i:0;a:4:{s:5:\"title\";s:26:\"2015-2016 Audio Collection\";s:4:\"text\";s:168:\"These are the audio tracks the studios have collected for the 2015-2016 semester.  We will be continue collecting and posting for the 2016-2017 semester, so stay tuned!\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"0b29f3c9-0520-4553-9535-426d11dc7fd2\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:374:\"<p>[drstk_tile id=\"neu:rx918154k,</p><p>neu:rx918365h,neu:rx918366s,neu:rx918359c,neu:rx9183604,neu:rx918361d,neu:rx918362p\" tile-type=\"even-row\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]</p><p>[drstk_tile id=\"neu:rx918154k,neu:rx918365h,neu:rx9183647,neu:rx918366s,neu:rx918359c,neu:rx9183604,</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"284053c2-e268-4d1f-8df4-0323dbf4a9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:163:\"<p>[drstk_item id=\"neu:rx918154k\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Date created,Abstract/Description\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"d0b32489-38f6-46e5-9d84-4160ed2258f9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:161:\"<p>[drstk_item id=\"neu:rx9183604\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Type of resource,Format\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:2;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"07cc3f28-b307-479c-80f8-4a809e6b6918\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918361d\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"a70b4b4b-aac7-45d4-8f63-f972f333ed3b\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:167:\"<p>[drstk_item id=\"neu:rx918362p\" align=\"left\" caption-align=\"left\" caption-position=\"below\" image-size=\"2\" metadata=\"Title,Creator,Date created,Type of resource\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"29fe08a8-aa7f-4257-9897-6758ac6a8e16\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:7:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:2;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:3;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:4;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:5;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}i:6;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:12:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";i:1;}i:1;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";i:1;}i:2;a:2:{s:4:\"grid\";i:2;s:6:\"weight\";i:1;}i:3;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:4;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:5;a:2:{s:4:\"grid\";i:3;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:6;a:2:{s:4:\"grid\";i:4;s:6:\"weight\";i:1;}i:7;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:8;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:9;a:2:{s:4:\"grid\";i:5;s:6:\"weight\";d:0.333333333333333314829616256247390992939472198486328125;}i:10;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}i:11;a:2:{s:4:\"grid\";i:6;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("248","147","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kh556\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1299:\"</br>
The Ryan Martin Band is a newly formed Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. In addition to writing for The Ryan Martin Band, Martin also serves as an engineer for Pop, Soul and Indie releases, working with local artists such as Godwin, The New Review, and Rob Ballantine. During his captivating performances, lead vocalist Ryan Martin performs alongside percussionist Diego Diaz, bassist Alex Gorchesky, guitarist Chris Davis, and pianist Danny Godwin, to deliver powerful, thought-provoking vocals, aggressively distorted passages, and blissful melodic lines that hook the listener into pensive tales of love, soul, and tireless minds. The upcoming singles \'Hollow Heart\' and \'Go Now, Go On\' will preview his upcoming EP, Hymns of the Wanderer, scheduled for release in June 2016.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:6:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:18:\"All I Have to Give\";s:4:\"text\";s:72:\"<p>[drstk_collection_playlist id=\"neu:cj82kv92d\" width=\"\" height=\"\"]</p>\";s:6:\"filter\";s:1:\"0\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:731:\"</br>
Blindspot is a female-fronted indie rock band from Boston, MA. They have been together for 2 years and are influenced by artists such as U2, The Killers, Paramore, Kings of Leon, Neon Trees, and Coldplay. Their unique sound, passion, and drive make them stand out against other musicians of their age. blindspot has opened for internationally recognized bands such as Gin Blossoms, Candlebox, Plain White T\'s, Buckcherry, Puddle of Mudd, Scott Weiland of Stone Temple Pilots, Finger Eleven, Saving Abel, Smile Empty Soul, and Tantric. They are constantly striving to gain as much exposure as possible in order to expand their fan base and have people hear their music. Look out for them because they want to change the world!\";s:11:\"panels_info\";a:5:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"25px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"filter\";b:0;}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:4:{i:0;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:1;a:2:{s:4:\"grid\";i:0;s:6:\"weight\";d:0.5;}i:2;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}i:3;a:2:{s:4:\"grid\";i:1;s:6:\"weight\";d:0.5;}}}");
INSERT INTO `wp_postmeta` VALUES ("254","152","_wp_page_template","default");
INSERT INTO `wp_postmeta` VALUES ("1257","541","panels_data","a:3:{s:7:\"widgets\";a:4:{i:0;a:5:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:231:\"<p>[drstk_gallery id=\"neu:rx918366s, neu:cj82kh556, neu:rx918154k\" caption=\"on\" caption-align=\"center\" caption-position=\"relative\" caption-width=\"image\" auto=\"on\" nav=\"on\" image-size=\"3\" metadata=\"full_title_ssi,creator_tesim\"]</p>\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"c90b6e0a-bf74-4c33-9f7e-5dd2d008b52a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:763:\"Northeastern students, faculty, and staff may use the DMC Studios to create projects, presentations and online instruction. DMC Studios staff collaborate with faculty across the curriculum to help plan and implement media-based assignments and teach skills. During hours of service, DMC Studios and staff assist individuals and groups with scholarly projects on a walk-in and appointment basis.  Located in the Digital Media Commons (DMC) on Snell Library\'s second level, the 3D Printing Studio offers the resources of a full suite of 3D fabrication and modeling technologies to members of the Northeastern community: students (undergraduate and graduate), faculty, and staff. Whether it\'s classwork, research or a personal project, we can 3D print your model.
 
\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"f426cda1-e2a4-44fe-8b77-9cc251b2a9d8\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:196:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/audio\">Listen</a></p>

These are songs created in the audio studios located on the second floor.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9285c388-3a98-4b74-92f1-0098302a4e9a\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:184:\"<p class=\"text-center\"><a class=\"btn button\" href=\"http://recordingstudios.library.northeastern.edu/video\">View</a></p>

These are videos that created for class, and personal projects.\";s:6:\"filter\";b:0;s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7400fc6c-944d-417e-a3a1-f7640f8887c1\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}i:1;a:2:{s:5:\"cells\";i:3;s:5:\"style\";a:0:{}}i:2;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";i:1;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.8005125172481799555868064999231137335300445556640625;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:2;s:6:\"weight\";d:0.09974374137591200673025326750575914047658443450927734375;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `wp_postmeta` VALUES ("1743","796","panels_data","a:3:{s:7:\"widgets\";a:17:{i:0;a:7:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:1293:\"<h3><strong>Course: LARC 2340 Cities, Landscape, and Contemporary Culture
Professor: Nick Brown
Semester: Spring 2018, Fall 2018, Spring 2019</strong></h3>
<strong>Assignment:</strong>

\"Landscape Dialogues\" an original production by Northeastern’s Cities, Landscape, and Contemporary Culture class taught by instructor Nicholas Brown. This podcast is an introduction into some of today’s most influential landscape architects, designers, firms, and theorists, all within the context of the many different projects, communities, and ideologies they are responsible for shaping. These discussions shed light on current and futures trends in the field of landscape architecture, calling specific attention to the personal declarations presented in the Landscape Architecture Foundation’s summit that took place two years ago. The summit gathered all the major leaders within the field to reflect on the last half-century of landscape design and present bold ideas for the future. So throughout this podcast we will explore these landscape architects. We will look at the role that they play in developing and modernizing the ways that we interact with space. These podcasts present viable examples of the work that they have done and usher in conversation regarding their work and impact.\";s:6:\"filter\";s:1:\"1\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6d723f6a-2cb7-40df-940c-3fcfdbd4f91a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610000\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";}i:1;a:8:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"[drstk_tile id=\"neu:cj82r939f,neu:cj82r9406,neu:cj82r941g\" tile-type=\"pinterest-hover\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]

&nbsp
<hr>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310001\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"becabe8e-a032-44ec-be04-54927923a386\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610001\";}i:2;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:1274:\"<h3><strong>Course: AFAM 1225 16350 Gender, Race, and Medicine</strong>
<strong>Professor: Moya Bailey</strong>
<strong>Semester:  Fall 2017</strong></h3>
<strong>Assignment:</strong>
<div class=\"page\" title=\"Page 1\">
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">

Student pairs will produce a 6-10 minute podcast episode on a topic of their choosing related to the class content. Possible topics include but are not limited to:</div>
</div>
</div>
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">
<ul>
 	<li>Water quality in Boston neighborhoods</li>
 	<li>Environmental racism in Boston</li>
 	<li>Different framing of “crack babies” and “opioid dependent newborns”</li>
 	<li>Race and gender in medical schools</li>
 	<li>Race and gender in different medical professions</li>
 	<li>Health care disparities by region, age, ability, race etc.</li>
</ul>
</div>
</div>
</div>
<div class=\"section\">
<div class=\"layoutArea\">
<div class=\"column\">

Student pairs are encouraged to be creative with the podcast – to have fun, and find ways to provide an informative and entertaining podcast. Students are encouraged to interview experts on the topic, and find other content to bring into the podcast.</div>
</div>
</div>
</div>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310002\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"e9f967a4-1a8d-43d6-a987-f65dd65ba988\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610002\";}i:3;a:8:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:207:\"[drstk_tile id=\"neu:cj82qp53c,neu:cj82qp477,neu:cj82qp55x\" tile-type=\"pinterest-hover\" text-align=\"left\" cell-height=\"200\" cell-width=\"200\" image-size=\"4\" metadata=\"full_title_ssi,creator_tesim\"]

&nbsp
<hr>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310003\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:3;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"f605c602-2ffb-40a0-9d92-032166301262\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610003\";}i:4;a:8:{s:4:\"type\";s:4:\"html\";s:5:\"title\";s:0:\"\";s:4:\"text\";s:689:\"<h3><strong>Course: The Record Industry MUSI 3333</strong>
<strong>Professor: David Herlihy</strong>
<strong>Semester: Spring 2015</strong></h3>
<strong>Assignment:</strong>

The Groups will produce a video of the Master recording and post it on the web (e.g., youTube and the Artist’s site). The process of producing the video will include working with the artist, developing a “concept”, including assessing different esthetic approaches to determine what works best for the artist/recording (e.g., black and white, abstract, performance video, etc…), storyboarding, creating b-rolls, scheduling shoot(s), post production and editing a finished version of the completed video.

\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310004\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:4;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"6589be5e-1438-4f6d-b7f1-7a66762e541d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610004\";}i:5;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Flash Paper\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px10v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310005\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"572d6eb2-985a-4110-8dbd-cf75be444ba1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610005\";}i:6;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:341:\"</br>
</br>
</br>
Build iT! is a Boston based punk band who love being sad, big beautiful penguins and sometimes writing banger tunes. It has been heavily rumored that this band does indeed play music, but there is still research to be done. There are currently four members of the band, but they are willing and open to add a third member. \";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310006\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:5;s:4:\"cell\";i:1;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"049bdb53-a36c-4383-9cae-cf733357bf2c\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:13:\"text-79610006\";}i:7;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Kaleidoscope\";s:4:\"text\";s:208:\"<p>[drstk_single id=\"neu:cj82px093\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p><p> </p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310007\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:0;s:2:\"id\";i:7;s:9:\"widget_id\";s:36:\"06cc7215-eecc-40fe-8ae0-65ffda4516eb\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610007\";}i:8;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:474:\"</br>
</br>
</br>
	The artist we’ve chosen to work with is a rapper named Tirelle Barron who releases music under the moniker The Noise Above. Tirelle’s style is an intellectual blend of lyricism and low-key funk and jazz-inspired beats which are complex yet accessible. His work is uniquely personal as he creates and produces all of his own beats and writes deeply introspective lyrics regarding personal experience, perspective, and growth through various struggles.
\";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310008\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:6;s:4:\"cell\";i:1;s:2:\"id\";i:8;s:9:\"widget_id\";s:36:\"0eea7bd5-9cfa-4e14-bc62-9b3b70782291\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:13:\"text-79610008\";}i:9;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:11:\"Jelly Apple\";s:4:\"text\";s:199:\"<p>[drstk_single id=\"neu:cj82px08t\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310009\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:7;s:4:\"cell\";i:0;s:2:\"id\";i:9;s:9:\"widget_id\";s:36:\"c2802957-0c83-4fad-bd3c-9661e1d58519\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610009\";}i:10;a:8:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:466:\"</br>
</br>
</br>
Singer-songwriter Mike Orent is set to break into the Boston music scene with his “sad folk / twinkly emo” catalogue. Orent began playing the guitar over a decade ago and hasn’t been able to put it down since. 
Drawing inspiration and influence from a variety of artists such as Elvis Costello, The Smiths, Pile, Elliot Smith, and Saves The Day, you are sure to be moved after hearing the honest lyrics and impressive vocals Mike offers up. 
\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:2:\"id\";s:12:\"text-2310010\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:7;s:4:\"cell\";i:1;s:2:\"id\";i:10;s:9:\"widget_id\";s:36:\"39fb2013-aeac-4017-9be5-91c1702e7c25\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:13:\"text-79610010\";}i:11;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:12:\"Hollow Heart\";s:4:\"text\";s:161:\"[drstk_single id=\"neu:cj82kh556\" image-size=\"4\" display-video=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom-position=\"1\"]\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310011\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:8;s:4:\"cell\";i:0;s:2:\"id\";i:11;s:9:\"widget_id\";s:36:\"1c04785c-3d43-46c6-b516-308259ccce2f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610011\";}i:12;a:8:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:582:\"</br>
The Ryan Martin Band is an Indie Folk band based in Boston, MA, fronted by lead vocalist and songwriter, Ryan Martin. An avid guitarist and student to award-winning engineers at Berklee College of Music, The Ryan Martin Band is his first foray into showcasing his composition prowess. Martin’s composition experience extends over eight years, originally starting in R&B, Soul, and Jazz arrangements until finding his voice in Indie Folk genre after being inspired by bands such as Damien Rice, Mumford & Sons, Daughter, Fleet Foxes, Johnnyswim, Coldplay, and The Lumineers. \";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:2:\"id\";s:12:\"text-2310012\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:8;s:4:\"cell\";i:1;s:2:\"id\";i:12;s:9:\"widget_id\";s:36:\"5f235ad2-84c8-452a-8eba-8b9eabc250ee\";s:5:\"style\";a:3:{s:7:\"padding\";s:4:\"25px\";s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:13:\"text-79610012\";}i:13;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:15:\"The Bee Charmer\";s:4:\"text\";s:186:\"<p>[drstk_single id=\"neu:cj82nh78v\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]</p>\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310013\";s:11:\"option_name\";s:27:\"widget_black-studio-tinymce\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:30:\"WP_Widget_Black_Studio_TinyMCE\";s:3:\"raw\";b:0;s:4:\"grid\";i:9;s:4:\"cell\";i:0;s:2:\"id\";i:13;s:9:\"widget_id\";s:36:\"a8b30416-4f1c-487b-8ab0-eab2e7a81db9\";s:5:\"style\";a:1:{s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:29:\"black-studio-tinymce-79610013\";}i:14;a:7:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:562:\"</br>
Drawing influences from both modern indie, as well as the tried and true formulas of old time-y folk and country western, Musket\'s music is both familiar and fresh all at once. The incorporation of the classic and largely forgotten folk instru- ment, the autoharp, in conjunction with whimsi- cal songwriting gives Little Musket her trade- mark dark, yet playful sound, creating a genre she likes to call \"Melancountry\" Little Musket released her debut EP of live songs in October 2015. Follow the journey on Facebook, and watch for new music on Band camp.\";s:6:\"filter\";b:0;s:2:\"id\";s:12:\"text-2310014\";s:11:\"option_name\";s:11:\"widget_text\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:14:\"WP_Widget_Text\";s:3:\"raw\";b:0;s:4:\"grid\";i:9;s:4:\"cell\";i:1;s:2:\"id\";i:14;s:9:\"widget_id\";s:36:\"09cb10b0-9f49-4a29-90c7-7e3bec23d2b0\";s:5:\"style\";a:2:{s:7:\"padding\";s:4:\"25px\";s:18:\"background_display\";s:4:\"tile\";}}s:22:\"so_sidebar_emulator_id\";s:13:\"text-79610014\";}i:15;a:8:{s:4:\"type\";s:6:\"visual\";s:5:\"title\";s:17:\"All I Had to Give\";s:4:\"text\";s:192:\"[drstk_single id=\"neu:cj82kv92d\" image-size=\"4\" display-video=\"true\" display-issuu=\"true\" align=\"center\" float=\"none\" caption-align=\"left\" caption-position=\"below\" zoom=\"on\" zoom-position=\"1\"]\";s:6:\"filter\";s:1:\"1\";s:2:\"id\";s:28:\"black-studio-tinymce-2310015\";s:11:\"option_nam